/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedVertexConsumerWrapper;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import java.nio.ByteBuffer;
import lombok.Generated;
import net.minecraft.class_2350;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AcceleratedSheetedDecalTextureGenerator
extends AcceleratedVertexConsumerWrapper {
    private final class_4588 delegate;
    private final Matrix4f cameraInverse;
    private final Matrix3f normalInverse;
    private final float textureScale;
    private final Vector3f cachedCamera;
    private final Vector3f cachedNormal;
    private float vertexX;
    private float vertexY;
    private float vertexZ;
    private float normalX;
    private float normalY;
    private float normalZ;

    public AcceleratedSheetedDecalTextureGenerator(class_4588 delegate, Matrix4f cameraInverse, Matrix3f normalInverse, float textureScale) {
        this.delegate = delegate;
        this.cameraInverse = cameraInverse;
        this.normalInverse = normalInverse;
        this.textureScale = textureScale;
        this.cachedCamera = new Vector3f();
        this.cachedNormal = new Vector3f();
        this.vertexX = 0.0f;
        this.vertexY = 0.0f;
        this.vertexZ = 0.0f;
        this.normalX = 0.0f;
        this.normalY = 0.0f;
        this.normalZ = 0.0f;
    }

    @Override
    protected class_4588 getDelegate() {
        return this.delegate;
    }

    @Override
    public class_4588 decorate(class_4588 buffer) {
        return new AcceleratedSheetedDecalTextureGenerator(VertexConsumerExtension.getAccelerated(this.getDelegate()).decorate(buffer), this.cameraInverse, this.normalInverse, this.textureScale);
    }

    @Override
    public void addClientMesh(ByteBuffer meshBuffer, int size, int color, int light, int overlay) {
        VertexConsumerExtension.getAccelerated(this.getDelegate()).addClientMesh(meshBuffer, size, -1, light, overlay);
    }

    @Override
    public void addServerMesh(ServerMesh serverMesh, int color, int light, int overlay) {
        VertexConsumerExtension.getAccelerated(this.getDelegate()).addServerMesh(serverMesh, -1, light, overlay);
    }

    @Override
    public class_4588 method_22912(double pX, double pY, double pZ) {
        this.vertexX = (float)pX;
        this.vertexY = (float)pY;
        this.vertexZ = (float)pZ;
        this.delegate.method_22912(pX, pY, pZ);
        return this;
    }

    @Override
    public class_4588 method_22913(float pU, float pV) {
        return this;
    }

    @Override
    public class_4588 method_1336(int pRed, int pGreen, int pBlue, int pAlpha) {
        this.delegate.method_39415(-1);
        return this;
    }

    @Override
    public class_4588 method_22914(float pNormalX, float pNormalY, float pNormalZ) {
        this.normalX = pNormalX;
        this.normalY = pNormalY;
        this.normalZ = pNormalZ;
        this.delegate.method_22914(pNormalX, pNormalY, pNormalZ);
        return this;
    }

    @Override
    public void method_23919(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, int packedOverlay, int packedLight, float normalX, float normalY, float normalZ) {
        this.method_22912(x, y, z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(packedOverlay).method_22916(packedLight).method_22914(normalX, normalY, normalZ).method_1344();
    }

    @Override
    public void method_1344() {
        Vector3f normal = this.normalInverse.transform(this.normalX, this.normalY, this.normalZ, this.cachedNormal);
        Vector3f camera = this.cameraInverse.transformPosition(this.vertexX, this.vertexY, this.vertexZ, this.cachedCamera);
        class_2350 direction = class_2350.method_10147((float)normal.x(), (float)normal.y(), (float)normal.z());
        camera.rotateY((float)Math.PI);
        camera.rotateX(-1.5707964f);
        camera.rotate((Quaternionfc)direction.method_23224());
        this.delegate.method_22913(-camera.x() * this.textureScale, -camera.y() * this.textureScale);
        super.method_1344();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceleratedSheetedDecalTextureGenerator)) {
            return false;
        }
        AcceleratedSheetedDecalTextureGenerator other = (AcceleratedSheetedDecalTextureGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        class_4588 this$delegate = this.getDelegate();
        class_4588 other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        Matrix4f this$cameraInverse = this.cameraInverse;
        Matrix4f other$cameraInverse = other.cameraInverse;
        return !(this$cameraInverse == null ? other$cameraInverse != null : !this$cameraInverse.equals(other$cameraInverse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcceleratedSheetedDecalTextureGenerator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        class_4588 $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        Matrix4f $cameraInverse = this.cameraInverse;
        result = result * 59 + ($cameraInverse == null ? 43 : $cameraInverse.hashCode());
        return result;
    }
}

