/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import sun.misc.Unsafe;

public class UnsafeMemoryMeshInfoCache
implements IMeshInfoCache {
    public static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    public static final long MESH_INFO_SIZE = 20L;
    public static final long COLOR_OFFSET = 0L;
    public static final long LIGHT_OFFSET = 4L;
    public static final long OVERLAY_OFFSET = 8L;
    public static final long SHARING_OFFSET = 12L;
    public static final long SHOULD_CULL_OFFSET = 16L;
    private long address = UNSAFE.allocateMemory((long)this.size * 20L);
    private int size = 128;
    private int count = 0;

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void delete() {
        UNSAFE.freeMemory(this.address);
    }

    @Override
    public void setup(int color, int light, int overlay, int sharing, int shouldCull) {
        if (this.count >= this.size) {
            this.size *= 2;
            this.address = UNSAFE.reallocateMemory(this.address, (long)this.size * 20L);
        }
        long infoAddress = this.address + (long)this.count * 20L;
        UNSAFE.putInt(infoAddress + 0L, color);
        UNSAFE.putInt(infoAddress + 4L, light);
        UNSAFE.putInt(infoAddress + 8L, overlay);
        UNSAFE.putInt(infoAddress + 12L, sharing);
        UNSAFE.putInt(infoAddress + 16L, shouldCull);
        ++this.count;
    }

    @Override
    public int getMeshCount() {
        return this.count;
    }

    @Override
    public int getSharing(int i) {
        return UNSAFE.getInt(this.address + (long)i * 20L + 12L);
    }

    @Override
    public int getShouldCull(int i) {
        return UNSAFE.getInt(this.address + (long)i * 20L + 16L);
    }

    @Override
    public int getColor(int i) {
        return UNSAFE.getInt(this.address + (long)i * 20L + 0L);
    }

    @Override
    public int getLight(int i) {
        return UNSAFE.getInt(this.address + (long)i * 20L + 4L);
    }

    @Override
    public int getOverlay(int i) {
        return UNSAFE.getInt(this.address + (long)i * 20L + 8L);
    }
}

