/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.utils;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class ByteBufferBuilder
implements AutoCloseable {
    private long address;
    private int position;

    public ByteBufferBuilder(int capacity) {
        this.address = MemoryUtil.nmemAlloc((long)capacity);
    }

    public long reserve(int bytes) {
        int oldPosition = this.position;
        int newPosition = oldPosition + bytes;
        this.resize(Integer.highestOneBit(newPosition) << 1);
        this.position = newPosition;
        return this.address + (long)oldPosition;
    }

    private void resize(int newSize) {
        this.address = MemoryUtil.nmemRealloc((long)this.address, (long)newSize);
    }

    @Nullable
    public Result build() {
        return this.position > 0 ? new Result(this.position) : null;
    }

    private void free() {
        this.position = 0;
    }

    @Override
    public void close() {
        MemoryUtil.nmemFree((long)this.address);
    }

    public class Result
    implements AutoCloseable {
        private final int capacity;

        Result(int capacity) {
            this.capacity = capacity;
        }

        public ByteBuffer byteBuffer() {
            return MemoryUtil.memByteBuffer((long)ByteBufferBuilder.this.address, (int)this.capacity);
        }

        @Override
        public void close() {
            ByteBufferBuilder.this.free();
        }
    }
}

