/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedRingBuffers;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerDrawType;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerKey;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.CustomLayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.EmptyLayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.ILayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.ILayerContexts;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.ILayerStorage;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.empty.EmptyLayerStorage;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.DrawContextPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import com.github.argon4w.acceleratedrendering.core.utils.ShaderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL46;

public class AcceleratedBufferSource
implements IAcceleratedBufferSource {
    private final IBufferEnvironment environment;
    private final AcceleratedRingBuffers ringBuffers;
    private final Set<AcceleratedRingBuffers.Buffers> buffers;
    private final Map<LayerKey, AcceleratedBufferBuilder> activeBuilders;
    private final IntSet activeLayers;
    private AcceleratedRingBuffers.Buffers currentBuffer;
    private boolean used;

    public AcceleratedBufferSource(IBufferEnvironment bufferEnvironment) {
        this.environment = bufferEnvironment;
        this.ringBuffers = new AcceleratedRingBuffers(this.environment);
        this.currentBuffer = (AcceleratedRingBuffers.Buffers)this.ringBuffers.get(false);
        this.buffers = ObjectLinkedOpenHashSet.of((Object)this.currentBuffer);
        this.activeBuilders = new Object2ObjectOpenHashMap();
        this.activeLayers = new IntAVLTreeSet();
        this.used = false;
    }

    public void delete() {
        this.ringBuffers.delete();
    }

    @Override
    public AcceleratedBufferBuilder getBuffer(class_1921 renderType, Runnable before, Runnable after, int layerIndex) {
        LayerKey layerKey = new LayerKey(layerIndex, renderType);
        AcceleratedBufferBuilder builder = this.activeBuilders.get(layerKey);
        Map<LayerKey, AcceleratedBufferBuilder> builders = this.currentBuffer.getBuilders();
        Int2ReferenceMap<ILayerFunction> functions = this.currentBuffer.getFunctions();
        Int2ReferenceMap<ILayerStorage> layers = this.currentBuffer.getLayers();
        ILayerFunction function = (ILayerFunction)functions.get(layerIndex);
        ILayerStorage layer = (ILayerStorage)layers.get(layerIndex);
        if (builder != null) {
            function = builder.getFunction();
            function.addBefore(before);
            function.addAfter(after);
            return builder;
        }
        StagingBufferPool.StagingBuffer vertexBuffer = this.currentBuffer.getVertexBuffer();
        StagingBufferPool.StagingBuffer varyingBuffer = this.currentBuffer.getVaryingBuffer();
        ElementBufferPool.ElementSegment elementSegment = this.currentBuffer.getElementSegment();
        if (vertexBuffer == null) {
            this.currentBuffer = (AcceleratedRingBuffers.Buffers)this.ringBuffers.get(true);
            builders = this.currentBuffer.getBuilders();
            functions = this.currentBuffer.getFunctions();
            layers = this.currentBuffer.getLayers();
            function = (ILayerFunction)functions.get(layerIndex);
            layer = (ILayerStorage)layers.get(layerIndex);
            vertexBuffer = this.currentBuffer.getVertexBuffer();
            varyingBuffer = this.currentBuffer.getVaryingBuffer();
            elementSegment = this.currentBuffer.getElementSegment();
            this.buffers.add(this.currentBuffer);
        }
        if (layer == null) {
            function = new CustomLayerFunction();
            layer = CoreFeature.createLayerStorage();
            layers.put(layerIndex, (Object)layer);
            functions.put(layerIndex, (Object)function);
        }
        builder = new AcceleratedBufferBuilder(vertexBuffer, varyingBuffer, elementSegment, this.currentBuffer, function, renderType);
        this.used = true;
        builders.put(layerKey, builder);
        function.addBefore(before);
        function.addAfter(after);
        this.activeBuilders.put(layerKey, builder);
        this.activeLayers.add(layerIndex);
        return builder;
    }

    public void prepareBuffers() {
        if (!this.used) {
            return;
        }
        for (AcceleratedRingBuffers.Buffers buffer : this.buffers) {
            Map<LayerKey, AcceleratedBufferBuilder> builders = buffer.getBuilders();
            int program = GL46.glGetInteger((int)35725);
            int barrier = 0;
            if (builders.isEmpty()) continue;
            this.environment.getImmediateMeshBuffer().bindBase(37074, 5);
            this.environment.selectMeshUploadingProgramDispatcher().dispatch(builders.values(), buffer);
            this.environment.selectTransformProgramDispatcher().dispatch(builders.values());
            for (LayerKey layerKey : builders.keySet()) {
                AcceleratedBufferBuilder builder = builders.get(layerKey);
                if (builder.isEmpty()) continue;
                DrawContextPool.DrawContext drawContext = buffer.getDrawContext();
                ElementBufferPool.ElementSegment elementSegment = builder.getElementSegment();
                class_1921 renderType = layerKey.renderType();
                int layer = layerKey.layer();
                LayerDrawType drawType = RenderTypeUtils.getDrawType(renderType);
                builder.setOutdated();
                elementSegment.allocateOffset();
                buffer.bindElementBuffer(elementSegment);
                drawContext.bindComputeBuffers(elementSegment);
                drawContext.setRenderType(renderType);
                ((ILayerStorage)buffer.getLayers().get(layer)).get(drawType).add(drawContext);
                barrier |= this.environment.selectProcessingProgramDispatcher(renderType.method_23033()).dispatch(builder);
                barrier |= builder.getCullingProgramDispatcher().dispatch(builder);
            }
            GL46.glMemoryBarrier((int)barrier);
            GL46.glUseProgram((int)program);
        }
    }

    public void drawBuffers(LayerDrawType drawType) {
        if (!this.used) {
            return;
        }
        IntIterator intIterator = this.activeLayers.iterator();
        while (intIterator.hasNext()) {
            int layerIndex = (Integer)intIterator.next();
            for (AcceleratedRingBuffers.Buffers buffer : this.buffers) {
                ILayerFunction function = (ILayerFunction)buffer.getFunctions().getOrDefault(layerIndex, (Object)EmptyLayerFunction.INSTANCE);
                ILayerContexts contexts = ((ILayerStorage)buffer.getLayers().getOrDefault(layerIndex, (Object)EmptyLayerStorage.INSTANCE)).get(drawType);
                if (contexts.isEmpty()) continue;
                GL46.glMemoryBarrier((int)66);
                class_286.method_43436();
                buffer.bindDrawBuffers();
                contexts.prepare();
                function.runBefore();
                for (DrawContextPool.DrawContext drawContext : contexts) {
                    class_1921 renderType = drawContext.getRenderType();
                    renderType.method_23516();
                    class_293.class_5596 mode = renderType.method_23033();
                    class_5944 shader = RenderSystem.getShader();
                    ShaderUtils.setDefaultUniforms(mode, shader, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), class_310.method_1551().method_22683());
                    shader.method_34586();
                    drawContext.drawElements(mode);
                    shader.method_34585();
                    renderType.method_23518();
                }
                function.runAfter();
                contexts.reset();
                buffer.unbindVertexArray();
            }
        }
    }

    public void clearBuffers() {
        if (!this.used) {
            return;
        }
        for (AcceleratedRingBuffers.Buffers buffer : this.buffers) {
            buffer.reset();
            buffer.setInFlight();
        }
        this.used = false;
        this.currentBuffer = (AcceleratedRingBuffers.Buffers)this.ringBuffers.get(false);
        this.activeBuilders.clear();
        this.activeLayers.clear();
        this.buffers.clear();
        this.buffers.add(this.currentBuffer);
    }

    @Generated
    public IBufferEnvironment getEnvironment() {
        return this.environment;
    }
}

