/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.CullerUtils;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import net.minecraft.class_1011;
import net.minecraft.class_296;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class CulledMeshCollector
implements class_4588,
IMeshCollector {
    private final int polygonSize;
    private final class_1011 texture;
    private final IMemoryLayout<class_296> layout;
    private final SimpleMeshCollector meshCollector;
    private final Vertex[] polygon;
    private int vertexIndex;

    public CulledMeshCollector(IAcceleratedVertexConsumer vertexConsumer) {
        this.polygonSize = vertexConsumer.getPolygonSize();
        this.texture = vertexConsumer.downloadTexture();
        this.layout = vertexConsumer.getLayout();
        this.meshCollector = new SimpleMeshCollector(this.layout);
        this.polygon = new Vertex[this.polygonSize];
        this.vertexIndex = -1;
    }

    @Override
    public void flush() {
        if (this.vertexIndex >= this.polygonSize - 1) {
            this.vertexIndex = -1;
            if (!CullerUtils.shouldCull(this.polygon, this.texture)) {
                for (Vertex vertex : this.polygon) {
                    Vector3f vertexPosition = vertex.getPosition();
                    Vector4i vertexColor = vertex.getColor();
                    Vector2f vertexUV = vertex.getUv();
                    Vector3f vertexNormal = vertex.getNormal();
                    this.meshCollector.method_23919(vertexPosition.x, vertexPosition.y, vertexPosition.z, (float)vertexColor.x / 255.0f, (float)vertexColor.y / 255.0f, (float)vertexColor.z / 255.0f, (float)vertexColor.w / 255.0f, vertexUV.x, vertexUV.y, class_4608.field_21444, vertex.getPackedLight(), vertexNormal.x, vertexNormal.y, vertexNormal.z);
                }
            }
        }
    }

    public void method_1344() {
        this.flush();
    }

    public void method_35666() {
        this.meshCollector.method_35666();
    }

    public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {
        this.meshCollector.method_22901(defaultR, defaultG, defaultB, defaultA);
    }

    public class_4588 method_22912(double pX, double pY, double pZ) {
        this.flush();
        this.polygon[++this.vertexIndex] = new Vertex();
        this.polygon[this.vertexIndex].getPosition().x = (float)pX;
        this.polygon[this.vertexIndex].getPosition().y = (float)pY;
        this.polygon[this.vertexIndex].getPosition().z = (float)pZ;
        return this;
    }

    public class_4588 method_1336(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getColor().x = pRed;
        this.polygon[this.vertexIndex].getColor().y = pGreen;
        this.polygon[this.vertexIndex].getColor().z = pBlue;
        this.polygon[this.vertexIndex].getColor().w = pAlpha;
        return this;
    }

    public class_4588 method_22913(float pU, float pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getUv().x = pU;
        this.polygon[this.vertexIndex].getUv().y = pV;
        return this;
    }

    public class_4588 method_22917(int pU, int pV) {
        return this;
    }

    public class_4588 method_22921(int pU, int pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getLight().x = pU;
        this.polygon[this.vertexIndex].getLight().y = pV;
        return this;
    }

    public class_4588 method_22914(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getNormal().x = pNormalX;
        this.polygon[this.vertexIndex].getNormal().y = pNormalY;
        this.polygon[this.vertexIndex].getNormal().z = pNormalZ;
        return this;
    }

    @Override
    public IMeshData getData() {
        return this.meshCollector.getData();
    }

    @Override
    public ByteBufferBuilder getBuffer() {
        return this.meshCollector.getBuffer();
    }

    @Override
    public IMemoryLayout<class_296> getLayout() {
        return this.meshCollector.getLayout();
    }

    @Override
    public int getVertexCount() {
        return this.meshCollector.getVertexCount();
    }
}

