/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.PackedVector2i;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import lombok.Generated;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_4585;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class SimpleMeshCollector
extends class_4585
implements IMeshCollector {
    private final IMemoryLayout<class_296> layout;
    private final ByteBufferBuilder buffer;
    private final Vertex vertex;
    private final IMeshData data;
    private final long vertexSize;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private long vertexAddress;
    private int vertexCount;

    public SimpleMeshCollector(IMemoryLayout<class_296> layout) {
        this.layout = layout;
        this.buffer = new ByteBufferBuilder(1024);
        this.vertex = new Vertex();
        this.data = CoreFeature.createMeshData(layout);
        this.vertexSize = this.layout.getSize();
        this.posOffset = this.layout.getElement(class_290.field_1587);
        this.colorOffset = this.layout.getElement(class_290.field_1581);
        this.uv0Offset = this.layout.getElement(class_290.field_29335);
        this.uv2Offset = this.layout.getElement(class_290.field_20886);
        this.normalOffset = this.layout.getElement(class_290.field_1579);
        this.vertexAddress = -1L;
        this.vertexCount = 0;
    }

    @Override
    public void flush() {
        this.data.addVertex(this.vertex);
    }

    public void method_1344() {
    }

    public class_4588 method_22912(double pX, double pY, double pZ) {
        if (this.vertexCount != 0) {
            this.data.addVertex(this.vertex);
        }
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, (float)pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, (float)pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, (float)pZ);
        Vector3f vertexPosition = this.vertex.getPosition();
        vertexPosition.x = (float)pX;
        vertexPosition.y = (float)pY;
        vertexPosition.z = (float)pZ;
        return this;
    }

    public class_4588 method_1336(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        if (this.field_20889) {
            pRed = this.field_20890;
            pGreen = this.field_20891;
            pBlue = this.field_20892;
            pAlpha = this.field_20893;
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        Vector4i vertexColor = this.vertex.getColor();
        vertexColor.x = pRed;
        vertexColor.y = pGreen;
        vertexColor.z = pBlue;
        vertexColor.w = pAlpha;
        return this;
    }

    public class_4588 method_22913(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        Vector2f vertexUv = this.vertex.getUv();
        vertexUv.x = pU;
        vertexUv.y = pV;
        return this;
    }

    public class_4588 method_22917(int pU, int pV) {
        return this;
    }

    public class_4588 method_22921(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        Vector2i vertexLight = this.vertex.getLight();
        vertexLight.x = pU;
        vertexLight.y = pV;
        return this;
    }

    public class_4588 method_22914(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        Vector3f vertexNormal = this.vertex.getNormal();
        vertexNormal.x = pNormalX;
        vertexNormal.y = pNormalY;
        vertexNormal.z = pNormalZ;
        return this;
    }

    public void method_23919(float pX, float pY, float pZ, float red, float green, float blue, float alpha, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        if (this.field_20889) {
            red = (float)this.field_20890 / 255.0f;
            green = (float)this.field_20891 / 255.0f;
            blue = (float)this.field_20892 / 255.0f;
            alpha = (float)this.field_20893 / 255.0f;
        }
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        this.colorOffset.putInt(this.vertexAddress, class_5253.class_8045.method_48344((int)((int)(alpha * 255.0f)), (int)((int)(blue * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(red * 255.0f))));
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        this.uv2Offset.putInt(this.vertexAddress, pPackedLight);
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        this.data.addVertex(pX, pY, pZ, pU, pV, (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f), PackedVector2i.unpackU(pPackedLight), PackedVector2i.unpackV(pPackedLight), pNormalX, pNormalY, pNormalZ);
    }

    @Override
    @Generated
    public IMemoryLayout<class_296> getLayout() {
        return this.layout;
    }

    @Override
    @Generated
    public ByteBufferBuilder getBuffer() {
        return this.buffer;
    }

    @Generated
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    @Generated
    public IMeshData getData() {
        return this.data;
    }

    @Generated
    public long getVertexAddress() {
        return this.vertexAddress;
    }

    @Override
    @Generated
    public int getVertexCount() {
        return this.vertexCount;
    }
}

