/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.dispatchers;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import java.util.Collection;
import net.minecraft.class_2960;
import org.lwjgl.opengl.GL46;

public class TransformProgramDispatcher {
    public static final int VERTEX_BUFFER_IN_INDEX = 0;
    public static final int VARYING_BUFFER_IN_INDEX = 3;
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    private ITransformShaderProgramOverride lastOverride = null;

    public void dispatch(Collection<AcceleratedBufferBuilder> builders) {
        int barriers = 0;
        for (AcceleratedBufferBuilder builder : builders) {
            ITransformShaderProgramOverride currentOverride = builder.getTransformOverride();
            int vertexCount = builder.getVertexCount();
            StagingBufferPool.StagingBuffer vertexBuffer = builder.getVertexBuffer();
            StagingBufferPool.StagingBuffer varyingBuffer = builder.getVaryingBuffer();
            if (this.lastOverride != currentOverride) {
                this.lastOverride = currentOverride;
                this.lastOverride.useProgram();
                this.lastOverride.setupProgram();
            }
            if (vertexCount == 0) continue;
            vertexBuffer.bindBase(37074, 0);
            varyingBuffer.bindBase(37074, 3);
            barriers |= currentOverride.dispatchTransform(vertexCount, (int)(vertexBuffer.getOffset() / builder.getVertexSize()), (int)(varyingBuffer.getOffset() / builder.getVaryingSize()));
        }
        this.resetOverride();
        GL46.glUseProgram((int)0);
        GL46.glMemoryBarrier((int)barriers);
    }

    public int dispatch(AcceleratedBufferBuilder builder, StagingBufferPool.StagingBuffer vertexBuffer, StagingBufferPool.StagingBuffer varyingBuffer, long vertexCount, long vertexOffset, long varyingOffset) {
        ITransformShaderProgramOverride currentOverride = builder.getTransformOverride();
        if (this.lastOverride != currentOverride) {
            this.lastOverride = currentOverride;
            this.lastOverride.useProgram();
            this.lastOverride.setupProgram();
        }
        vertexBuffer.bindBase(37074, 0);
        varyingBuffer.bindBase(37074, 3);
        return currentOverride.dispatchTransform((int)vertexCount, (int)vertexOffset, (int)varyingOffset);
    }

    public void resetOverride() {
        this.lastOverride = null;
    }

    public static class Default
    implements ITransformShaderProgramOverride {
        private final long varyingSize;
        private final ComputeProgram program;
        private final Uniform vertexCountUniform;
        private final Uniform vertexOffsetUniform;
        private final Uniform varyingOffsetUniform;

        public Default(class_2960 key, long varyingSize) {
            this.varyingSize = varyingSize;
            this.program = ComputeShaderProgramLoader.getProgram(key);
            this.vertexCountUniform = this.program.getUniform("vertexCount");
            this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
            this.varyingOffsetUniform = this.program.getUniform("varyingOffset");
        }

        @Override
        public long getVaryingSize() {
            return this.varyingSize;
        }

        @Override
        public void useProgram() {
            this.program.useProgram();
        }

        @Override
        public void setupProgram() {
            this.program.setup();
        }

        @Override
        public void uploadVarying(long varyingAddress, int offset) {
        }

        @Override
        public int dispatchTransform(int vertexCount, int vertexOffset, int varyingOffset) {
            this.vertexCountUniform.uploadUnsignedInt(vertexCount);
            this.vertexOffsetUniform.uploadUnsignedInt(vertexOffset);
            this.varyingOffsetUniform.uploadUnsignedInt(varyingOffset);
            this.program.dispatch((vertexCount + 128 - 1) / 128, 1, 1);
            return this.program.getBarrierFlags();
        }
    }
}

