/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.entities;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_4538;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_765;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class AcceleratedEntityShadowRenderer
implements IAcceleratedRenderer<Context> {
    @Override
    public void render(class_4588 vertexConsumer, Context context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        class_4538 levelReader = context.levelReader();
        class_2791 chunkAccess = context.chunkAccess();
        class_2338 blockPos = context.blockPos();
        Vector3f center = context.center();
        float size = context.size();
        float weight = context.weight();
        class_2338 belowPos = context.blockPos().method_10074();
        class_2680 blockState = chunkAccess.method_8320(belowPos);
        if (blockState.method_26217() == class_2464.field_11455) {
            return;
        }
        int levelBrightness = levelReader.method_22339(blockPos);
        if (levelBrightness <= 3) {
            return;
        }
        if (!blockState.method_26234((class_1922)chunkAccess, belowPos)) {
            return;
        }
        class_265 voxelShape = blockState.method_26218((class_1922)chunkAccess, belowPos);
        if (voxelShape.method_1110()) {
            return;
        }
        float dimensionBrightness = class_765.method_23284((class_2874)levelReader.method_8597(), (int)levelBrightness);
        float shadowTransparency = weight * 0.5f * dimensionBrightness * 255.0f;
        if (shadowTransparency < 0.0f) {
            return;
        }
        if (shadowTransparency > 255.0f) {
            shadowTransparency = 255.0f;
        }
        class_238 bounds = voxelShape.method_1107();
        float minX = (float)blockPos.method_10263() + (float)bounds.field_1323;
        float maxX = (float)blockPos.method_10263() + (float)bounds.field_1320;
        float minY = (float)blockPos.method_10264() + (float)bounds.field_1322;
        float minZ = (float)blockPos.method_10260() + (float)bounds.field_1321;
        float maxZ = (float)blockPos.method_10260() + (float)bounds.field_1324;
        float minPosX = minX - center.x;
        float maxPosX = maxX - center.x;
        float minPosY = minY - center.y;
        float minPosZ = minZ - center.z;
        float maxPosZ = maxZ - center.z;
        float u0 = -minPosX / 2.0f / size + 0.5f;
        float u1 = -maxPosX / 2.0f / size + 0.5f;
        float v0 = -minPosZ / 2.0f / size + 0.5f;
        float v1 = -maxPosZ / 2.0f / size + 0.5f;
        extension.beginTransform(transform, normal);
        Vector3f[] positions = new Vector3f[]{new Vector3f(minPosX, minPosY, minPosZ), new Vector3f(minPosX, minPosY, maxPosZ), new Vector3f(maxPosX, minPosY, maxPosZ), new Vector3f(maxPosX, minPosY, minPosZ)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u0, v1), new Vector2f(u1, v1), new Vector2f(u1, v0)};
        for (int i = 0; i < 4; ++i) {
            Vector3f position = positions[i];
            Vector2f texCoord = texCoords[i];
            vertexConsumer.method_23919(position.x, position.y, position.z, (float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f, shadowTransparency / 255.0f, texCoord.x, texCoord.y, overlay, light, 0.0f, 1.0f, 0.0f);
        }
        extension.endTransform();
    }

    public record Context(class_4538 levelReader, class_2791 chunkAccess, class_2338 blockPos, Vector3f center, float size, float weight) {
    }
}

