/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.IntArrayHashStrategy;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedQuad;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_777;
import net.minecraftforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_777.class})
public abstract class BakedQuadMixin
implements IAcceleratedBakedQuad {
    @Unique
    private static final Map<int[], Map<IBufferGraph, IMesh>> MESHES = new Object2ObjectOpenCustomHashMap((Hash.Strategy)IntArrayHashStrategy.INSTANCE);
    @Unique
    private static final Map<int[], Map<IMeshData, IMesh>> MERGES = new Object2ObjectOpenCustomHashMap((Hash.Strategy)IntArrayHashStrategy.INSTANCE);
    @Shadow
    @Final
    protected int[] field_4175;

    @Shadow
    public abstract boolean method_3360();

    @Override
    @Unique
    public void renderFast(Matrix4f transform, Matrix3f normal, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay, int color) {
        IMesh mesh;
        Object2ObjectOpenHashMap meshes = MESHES.get(this.field_4175);
        Object2ObjectOpenHashMap merges = MERGES.get(this.field_4175);
        if (meshes == null) {
            meshes = new Object2ObjectOpenHashMap();
            merges = new Object2ObjectOpenHashMap();
            MESHES.put(this.field_4175, (Map<IBufferGraph, IMesh>)meshes);
            MERGES.put(this.field_4175, (Map<IMeshData, IMesh>)merges);
        }
        if ((mesh = meshes.get(extension)) != null) {
            mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        class_4588 meshBuilder = extension.decorate(culledMeshCollector);
        for (int i = 0; i < this.field_4175.length / 8; ++i) {
            int vertexOffset = i * IQuadTransformer.STRIDE;
            int posOffset = vertexOffset + IQuadTransformer.POSITION;
            int colorOffset = vertexOffset + IQuadTransformer.COLOR;
            int uv0Offset = vertexOffset + IQuadTransformer.UV0;
            int uv2Offset = vertexOffset + IQuadTransformer.UV2;
            int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
            int packedNormal = this.field_4175[normalOffset];
            int packedColor = this.field_4175[colorOffset];
            meshBuilder.method_23919(Float.intBitsToFloat(this.field_4175[posOffset + 0]), Float.intBitsToFloat(this.field_4175[posOffset + 1]), Float.intBitsToFloat(this.field_4175[posOffset + 2]), (float)class_5253.class_5254.method_27765((int)packedColor) / 255.0f, (float)class_5253.class_5254.method_27766((int)packedColor) / 255.0f, (float)class_5253.class_5254.method_27767((int)packedColor) / 255.0f, (float)class_5253.class_5254.method_27762((int)packedColor) / 255.0f, Float.intBitsToFloat(this.field_4175[uv0Offset + 0]), Float.intBitsToFloat(this.field_4175[uv0Offset + 1]), combinedOverlay, this.field_4175[uv2Offset], (float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = (IMesh)merges.get(data);
        if (mesh != null) {
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        meshes.put(extension, mesh);
        merges.put(data, mesh);
        mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
    }

    @Override
    @Unique
    public int getCustomColor(int color) {
        return this.method_3360() ? color : -1;
    }
}

