/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.modelparts.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_630;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_630.class})
public class ModelPartMixin
implements IAcceleratedRenderer<Void> {
    @Shadow
    @Final
    private List<class_630.class_628> field_3663;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    @Unique
    private final Map<IMeshData, IMesh> merges = new Object2ObjectOpenHashMap();

    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true)
    public void compileFast(class_4587.class_4665 pPose, class_4588 pBuffer, int pPackedLight, int pPackedOverlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(pBuffer);
        if (AcceleratedEntityRenderingFeature.isEnabled() && AcceleratedEntityRenderingFeature.shouldUseAcceleratedPipeline() && (CoreFeature.isRenderingLevel() || CoreFeature.isRenderingGui() && AcceleratedEntityRenderingFeature.shouldAccelerateInGui()) && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(this, null, pPose.method_23761(), pPose.method_23762(), pPackedLight, pPackedOverlay, class_5253.class_5254.method_27764((int)((int)(alpha * 255.0f)), (int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f))));
        }
    }

    @Override
    @Unique
    public void render(class_4588 vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        class_4588 meshBuilder = extension.decorate(culledMeshCollector);
        for (class_630.class_628 cube : this.field_3663) {
            for (class_630.class_593 polygon : cube.field_3649) {
                Vector3f polygonNormal = polygon.field_21618;
                for (class_630.class_618 vertex : polygon.field_3502) {
                    Vector3f vertexPosition = vertex.field_3605;
                    meshBuilder.method_23919(vertexPosition.x / 16.0f, vertexPosition.y / 16.0f, vertexPosition.z / 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, vertex.field_3604, vertex.field_3603, overlay, 0, polygonNormal.x, polygonNormal.y, polygonNormal.z);
                }
            }
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = this.merges.get(data);
        if (mesh != null) {
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        this.meshes.put(extension, mesh);
        this.merges.put(data, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

