/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.text;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedTextRenderingFeature;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_382;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class AcceleratedBakedGlyphRenderer
implements IAcceleratedRenderer<Vector2f> {
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    private final class_382 bakedGlyph;
    private final boolean italic;

    public AcceleratedBakedGlyphRenderer(class_382 bakedGlyph, boolean italic) {
        this.bakedGlyph = bakedGlyph;
        this.italic = italic;
    }

    @Override
    public void render(class_4588 vertexConsumer, Vector2f context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        TRANSFORM.set((Matrix4fc)transform);
        TRANSFORM.translate(context.x, context.y, 0.0f);
        extension.beginTransform(TRANSFORM, NORMAL);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        SimpleMeshCollector meshCollector = new SimpleMeshCollector(extension.getLayout());
        class_4588 meshBuilder = extension.decorate((class_4588)meshCollector);
        float italicOffsetUp = this.italic ? 1.0f - 0.25f * this.bakedGlyph.field_2279 : 0.0f;
        float italicOffsetDown = this.italic ? 1.0f - 0.25f * this.bakedGlyph.field_2278 : 0.0f;
        Vector2f[] positions = new Vector2f[]{new Vector2f(this.bakedGlyph.field_2272 + italicOffsetUp, this.bakedGlyph.field_2279), new Vector2f(this.bakedGlyph.field_2272 + italicOffsetDown, this.bakedGlyph.field_2278), new Vector2f(this.bakedGlyph.field_2280 + italicOffsetDown, this.bakedGlyph.field_2278), new Vector2f(this.bakedGlyph.field_2280 + italicOffsetUp, this.bakedGlyph.field_2279)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(this.bakedGlyph.field_2276, this.bakedGlyph.field_2274), new Vector2f(this.bakedGlyph.field_2276, this.bakedGlyph.field_2273), new Vector2f(this.bakedGlyph.field_2275, this.bakedGlyph.field_2273), new Vector2f(this.bakedGlyph.field_2275, this.bakedGlyph.field_2274)};
        for (int i = 0; i < 4; ++i) {
            Vector3f position = new Vector3f((Vector2fc)positions[i], 0.0f);
            Vector2f texCoord = texCoords[i];
            meshBuilder.method_22912((double)position.x, (double)position.y, (double)position.z).method_39415(-1).method_22913(texCoord.x, texCoord.y).method_22916(0);
        }
        mesh = AcceleratedTextRenderingFeature.getMeshType().getBuilder().build(meshCollector);
        this.meshes.put(extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

