/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.event.IModBusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModLoader {
    private static final ModLoader instance = new ModLoader();
    private final Logger logger = LoggerFactory.getLogger((String)"ModLoader");
    private final IEventBus eventBus = IEventBus.create();
    private final Map<String, ModContainer> modContainerMap = new HashMap<String, ModContainer>();

    public void postEvent(Event event) {
        if (event instanceof IModBusEvent) {
            for (EventPriority phase : EventPriority.values()) {
                for (ModContainer container : this.modContainerMap.values()) {
                    container.acceptEvent(phase, (Event)((Object)((IModBusEvent)((Object)event))));
                }
            }
            return;
        }
        for (EventPriority phase : EventPriority.values()) {
            try {
                this.eventBus.post(phase, event);
            }
            catch (Throwable ex) {
                this.logger.error("An exception was thrown while posing event {}.", (Object)event, (Object)ex);
            }
        }
    }

    public ModContainer createModContainer(String modid) {
        return this.modContainerMap.computeIfAbsent(modid, ModContainer::new);
    }

    public <T extends Event> T postEventWithReturn(T event) {
        this.postEvent(event);
        return event;
    }

    public static ModLoader get() {
        return instance;
    }
}

