#> callyourdog:image/set_image_data
#
# This function sets the image data.
#
# @input $(image_data) {string[][]} The data to set  
# @input $(width) {number} The width of the image  
# @input $(height) {number} The height of the image  
# @input $(background_color) {string} The background color of the image  
# @input $(description) {string[]} The description on the right hand side  
# @writes storage callyourdog:image image_data  
# @writes storage callyourdog:image width  
# @writes storage callyourdog:image height  
# @writes storage callyourdog:image background_color  
# @writes storage callyourdog:image description  
# @writes storage callyourdog:image pixel_character.blank  
# @writes storage callyourdog:image pixel_character.chat  
# @writes storage callyourdog:image pixel_character.lore

data remove storage callyourdog:image image_data
data remove storage callyourdog:image width
data remove storage callyourdog:image height
data remove storage callyourdog:image background_color
data remove storage callyourdog:image description

$data modify storage callyourdog:image image_data set value $(image_data)
$data modify storage callyourdog:image width set value $(width)
$data modify storage callyourdog:image height set value $(height)
$data modify storage callyourdog:image background_color set value "$(background_color)"
$data modify storage callyourdog:image description set value $(description)

data modify storage callyourdog:image pixel_character.blank set value "　"
data modify storage callyourdog:image pixel_character.pixel set value "▌▌"
data modify storage callyourdog:image pixel_character.line_break set value '\n'

function callyourdog:image/process/generate
