/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons;

import com.mojang.logging.LogUtils;
import net.alminoris.almirisweapons.Config;
import net.alminoris.almirisweapons.entity.ModEntities;
import net.alminoris.almirisweapons.entity.client.projectile.BulletEntityRenderer;
import net.alminoris.almirisweapons.item.ModItemGroups;
import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.sound.ModSounds;
import net.alminoris.almirisweapons.util.helper.WeaponSetsHelper;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="almirisweapons")
public class AlmirisWeapons {
    public static final String MOD_ID = "almirisweapons";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AlmirisWeapons(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(CreativeModeTabEvent.BuildContents entries) {
        if (entries.getTab() == ModItemGroups.ALMIRISWEAPONS_TAB) {
            for (String name : WeaponSetsHelper.MATERIALS) {
                entries.m_246326_((ItemLike)ModItems.HALBERDS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.RAPIERS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.CLAYMORES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.BATTLE_AXES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.SAI.get(name).get());
                entries.m_246326_((ItemLike)ModItems.MACES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.DAGGERS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.GLAIVES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.KATANAS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.BATTLE_STAVES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.SCYTHES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.ODACHIS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.DANE_AXES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.BEARDED_AXES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.KATARS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.STABBING_TIPS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.AXE_TIPS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.MACE_TIPS.get(name).get());
                entries.m_246326_((ItemLike)ModItems.SINGLEEDGE_BLADES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.DOUBLEEDGE_BLADES.get(name).get());
                entries.m_246326_((ItemLike)ModItems.CURVED_BLADES.get(name).get());
            }
            entries.m_246326_((ItemLike)ModItems.ARQUEBUS.get());
            entries.m_246326_((ItemLike)ModItems.BLUNDERBUSS.get());
            entries.m_246326_((ItemLike)ModItems.MATCHLOCK_PISTOL.get());
            entries.m_246326_((ItemLike)ModItems.BULLET.get());
            entries.m_246326_((ItemLike)ModItems.ARQUEBUS_BARREL.get());
            entries.m_246326_((ItemLike)ModItems.BLUNDERBUSS_BARREL.get());
            entries.m_246326_((ItemLike)ModItems.PISTOL_BARREL.get());
            entries.m_246326_((ItemLike)ModItems.MATCHLOCK_MECHANISM.get());
            entries.m_246326_((ItemLike)ModItems.GUN_STOCK.get());
            entries.m_246326_((ItemLike)ModItems.SMALL_STICK.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="almirisweapons", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BULLET.get()), BulletEntityRenderer::new);
        }
    }
}

