/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.item.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.alminoris.almirisweapons.item.custom.AbstractFirearmItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FirearmItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final Map<UUID, Map<InteractionHand, Float>> recoilMap = new HashMap<UUID, Map<InteractionHand, Float>>();
    private static final Map<UUID, Map<InteractionHand, Integer>> reloadMap = new HashMap<UUID, Map<InteractionHand, Integer>>();
    private static final RandomSource random = RandomSource.m_216327_();

    public FirearmItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public static void triggerRecoil(UUID player, InteractionHand hand, double strength) {
        recoilMap.computeIfAbsent(player, k -> new HashMap()).put(hand, Float.valueOf((float)strength));
    }

    public static void startReload(UUID player, InteractionHand hand, int ticks) {
        reloadMap.computeIfAbsent(player, k -> new HashMap()).put(hand, ticks);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int reloadTicks;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        UUID playerId = mc.f_91074_.m_20148_();
        InteractionHand hand = mc.f_91074_.m_21205_() == stack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        float recoilOffset = recoilMap.getOrDefault(playerId, Map.of()).getOrDefault(hand, Float.valueOf(0.0f)).floatValue();
        int maxReloadTicks = reloadTicks = reloadMap.getOrDefault(playerId, Map.of()).getOrDefault(hand, 0).intValue();
        if (recoilOffset > 0.0f) {
            Item item = stack.m_41720_();
            if (item instanceof AbstractFirearmItem) {
                AbstractFirearmItem firearm = (AbstractFirearmItem)item;
                String id = firearm.m_5524_();
                if (id.contains("arquebus")) {
                    poseStack.m_252880_(0.0f, 0.0f, -recoilOffset * 1.2f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-recoilOffset * 15.0f));
                } else if (id.contains("blunderbuss")) {
                    poseStack.m_252880_((random.m_188501_() - 0.5f) * 0.05f, 0.0f, -recoilOffset * 1.5f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-recoilOffset * 20.0f));
                } else if (id.contains("pistol")) {
                    poseStack.m_252880_(0.0f, 0.0f, -recoilOffset * 0.6f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-recoilOffset * 5.0f));
                }
            }
            if ((recoilOffset *= 0.75f) < 0.01f) {
                recoilOffset = 0.0f;
            }
            recoilMap.computeIfAbsent(playerId, k -> new HashMap()).put(hand, Float.valueOf(recoilOffset));
        }
        if (reloadTicks > 0) {
            float progress = 1.0f - (float)reloadTicks / (float)maxReloadTicks;
            poseStack.m_252880_(0.0f, progress * -0.4f, progress * 0.2f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(progress * 25.0f));
            reloadMap.computeIfAbsent(playerId, k -> new HashMap()).put(hand, --reloadTicks);
        }
        ItemRenderer renderer = mc.m_91291_();
        BakedModel model = renderer.m_174264_(stack, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, 0);
        renderer.m_115143_(stack, displayContext, false, poseStack, buffer, packedLight, packedOverlay, model);
    }
}

