/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.alminoris.almirisweapons.entity.custom.projectile.BulletEntity;
import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.item.custom.FirearmConfig;
import net.alminoris.almirisweapons.item.render.FirearmItemRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFirearmItem
extends Item {
    private final Map<UUID, Integer> reloadTimers = new HashMap<UUID, Integer>();

    public AbstractFirearmItem(Item.Properties settings) {
        super(settings);
    }

    protected abstract FirearmConfig getConfig();

    protected abstract Map<UUID, Integer> getPullTicks();

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (user.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        this.getPullTicks().put(user.m_20148_(), 0);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        block9: {
            block8: {
                if (!(entity instanceof Player)) break block8;
                player = (Player)entity;
                if (!world.f_46443_) break block9;
            }
            return;
        }
        UUID uuid = player.m_20148_();
        if (this.getPullTicks().containsKey(uuid)) {
            int ticks = this.getPullTicks().get(uuid) + 1;
            this.getPullTicks().put(uuid, ticks);
            if (ticks >= this.getConfig().minUseTicks()) {
                this.getPullTicks().remove(uuid);
                player.m_5810_();
                this.fire(world, player, player.m_21120_(player.m_7655_()), player.m_7655_());
            }
        }
        if (this.reloadTimers.containsKey(uuid)) {
            int ticksLeft = this.reloadTimers.get(uuid) - 1;
            if (ticksLeft <= 0) {
                this.playSound(world, player, this.getConfig().reloadSound(), this.getConfig().reloadVolume(), this.getConfig().reloadPitch());
                this.reloadTimers.remove(uuid);
            } else {
                this.reloadTimers.put(uuid, ticksLeft);
            }
        }
    }

    private void startReload(Level world, Player player, ItemStack stack, InteractionHand hand) {
        int reloadTime = this.getConfig().reloadTicks();
        player.m_36335_().m_41524_((Item)this, reloadTime);
        this.reloadTimers.put(player.m_20148_(), reloadTime);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.getConfig().reloadParticle() != null) {
                serverWorld.m_8767_(this.getConfig().reloadParticle(), player.m_20185_(), player.m_20188_() - 0.2, player.m_20189_(), this.getConfig().reloadParticleCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.f_46443_) {
            FirearmItemRenderer.startReload(player.m_20148_(), hand, reloadTime);
        }
    }

    private void playSound(Level world, Player player, SoundEvent sound, float volume, float pitch) {
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), volume, pitch);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int count) {
        Player player;
        block5: {
            block4: {
                if (!(user instanceof Player)) break block4;
                player = (Player)user;
                if (!world.f_46443_) break block5;
            }
            return;
        }
        UUID uuid = player.m_20148_();
        int usedTicks = this.getPullTicks().getOrDefault(uuid, 0);
        this.getPullTicks().remove(uuid);
        if (usedTicks >= this.getConfig().minUseTicks()) {
            this.fire(world, player, stack, player.m_7655_());
        }
    }

    private void fire(Level world, Player player, ItemStack stack, InteractionHand hand) {
        if (player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        if (world.f_46441_.m_188501_() < this.getConfig().misfireChance()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.almirisweapons.misfire"));
            this.playSound(world, player, this.getConfig().misfireSound(), 1.0f, 1.0f);
            this.startReload(world, player, stack, hand);
            return;
        }
        ItemStack ammo = this.findAmmo(player);
        if (ammo.m_41619_() || ammo.m_41613_() < this.getConfig().ammoPerShot()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.almirisweapons.no_ammo"));
            return;
        }
        ammo.m_41774_(this.getConfig().ammoPerShot());
        for (int i = 0; i < this.getConfig().projectilesPerShot(); ++i) {
            ItemStack bulletStack = new ItemStack((ItemLike)ModItems.BULLET.get());
            BulletEntity bullet = new BulletEntity(world, (LivingEntity)player, bulletStack, stack);
            bullet.setDamage(this.getConfig().damage());
            bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + (world.f_46441_.m_188501_() - 0.5f) * this.getConfig().spreadAngle(), 0.0f, this.getConfig().velocity(), this.getConfig().inaccuracy());
            world.m_7967_((Entity)bullet);
        }
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        this.playSound(world, player, this.getConfig().shootSound(), this.getConfig().soundVolume(), this.getConfig().soundPitch());
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_(this.getConfig().smokeParticle(), player.m_20185_(), player.m_20188_(), player.m_20189_(), this.getConfig().smokeCount(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpeed());
            if (this.getConfig().flameParticle() != null) {
                serverWorld.m_8767_(this.getConfig().flameParticle(), player.m_20185_(), player.m_20188_(), player.m_20189_(), this.getConfig().flameCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.f_46443_) {
            FirearmItemRenderer.triggerRecoil(player.m_20148_(), hand, this.getConfig().recoilStrength());
        }
        this.applyRecoil((LivingEntity)player);
        this.startReload(world, player, stack, hand);
    }

    protected void applyRecoil(LivingEntity user) {
        double yawRad = Math.toRadians(user.m_146908_());
        double rx = -Math.sin(yawRad) * this.getConfig().recoilStrength();
        double rz = Math.cos(yawRad) * this.getConfig().recoilStrength();
        double ry = this.getConfig().recoilVertical();
        user.m_20256_(user.m_20184_().m_82520_(rx, ry, rz));
    }

    private ItemStack findAmmo(Player player) {
        if (player.m_21206_().m_150930_((Item)ModItems.BULLET.get())) {
            return player.m_21206_();
        }
        if (player.m_21205_().m_150930_((Item)ModItems.BULLET.get())) {
            return player.m_21205_();
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)ModItems.BULLET.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level context, List<Component> tooltip, TooltipFlag type) {
        super.m_7373_(stack, context, tooltip, type);
        FirearmConfig cfg = this.getConfig();
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"item.modifiers.mainhand").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)" ").m_130946_(cfg.damage() + " ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.almirisweapons.damage").m_130940_(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.m_237113_((String)" ").m_130946_((float)cfg.reloadTicks() / 20.0f + "s ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.almirisweapons.reload_time").m_130940_(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.m_237113_((String)" ").m_130946_(cfg.ammoPerShot() + " ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.almirisweapons.ammo_per_shot").m_130940_(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.m_237113_((String)" ").m_130946_((int)(cfg.misfireChance() * 100.0f) + "% ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237115_((String)"tooltip.almirisweapons.misfire").m_130940_(ChatFormatting.DARK_GREEN)));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.getConfig().useAction();
    }

    public int m_8105_(ItemStack stack) {
        return this.getConfig().maxUseTime();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final FirearmItemRenderer renderer = new FirearmItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

