/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.alminoris.almirisweapons.entity.custom.projectile.BulletEntity;
import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.item.custom.FirearmConfig;
import net.alminoris.almirisweapons.item.render.FirearmItemRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class AbstractFirearmItem
extends Item {
    private final Map<UUID, Integer> reloadTimers = new HashMap<UUID, Integer>();

    public AbstractFirearmItem(Item.Properties settings) {
        super(settings);
    }

    protected abstract FirearmConfig getConfig();

    protected abstract Map<UUID, Integer> getPullTicks();

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)user.getItemInHand(hand));
        }
        this.getPullTicks().put(user.getUUID(), 0);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        block9: {
            block8: {
                if (!(entity instanceof Player)) break block8;
                player = (Player)entity;
                if (!world.isClientSide) break block9;
            }
            return;
        }
        UUID uuid = player.getUUID();
        if (this.getPullTicks().containsKey(uuid)) {
            int ticks = this.getPullTicks().get(uuid) + 1;
            this.getPullTicks().put(uuid, ticks);
            if (ticks >= this.getConfig().minUseTicks()) {
                this.getPullTicks().remove(uuid);
                player.stopUsingItem();
                this.fire(world, player, player.getItemInHand(player.getUsedItemHand()), player.getUsedItemHand());
            }
        }
        if (this.reloadTimers.containsKey(uuid)) {
            int ticksLeft = this.reloadTimers.get(uuid) - 1;
            if (ticksLeft <= 0) {
                this.playSound(world, player, this.getConfig().reloadSound(), this.getConfig().reloadVolume(), this.getConfig().reloadPitch());
                this.reloadTimers.remove(uuid);
            } else {
                this.reloadTimers.put(uuid, ticksLeft);
            }
        }
    }

    private void startReload(Level world, Player player, ItemStack stack, InteractionHand hand) {
        int reloadTime = this.getConfig().reloadTicks();
        player.getCooldowns().addCooldown((Item)this, reloadTime);
        this.reloadTimers.put(player.getUUID(), reloadTime);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.getConfig().reloadParticle() != null) {
                serverWorld.sendParticles(this.getConfig().reloadParticle(), player.getX(), player.getEyeY() - 0.2, player.getZ(), this.getConfig().reloadParticleCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.isClientSide) {
            FirearmItemRenderer.startReload(player.getUUID(), hand, reloadTime);
        }
    }

    private void playSound(Level world, Player player, SoundEvent sound, float volume, float pitch) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), sound, player.getSoundSource(), volume, pitch);
    }

    public void onStopUsing(ItemStack stack, LivingEntity user, int count) {
        Player player;
        block5: {
            block4: {
                if (!(user instanceof Player)) break block4;
                player = (Player)user;
                if (!user.getCommandSenderWorld().isClientSide) break block5;
            }
            return;
        }
        UUID uuid = player.getUUID();
        int usedTicks = this.getPullTicks().getOrDefault(uuid, 0);
        this.getPullTicks().remove(uuid);
        if (usedTicks >= this.getConfig().minUseTicks()) {
            this.fire(user.getCommandSenderWorld(), player, stack, player.getUsedItemHand());
        }
    }

    private void fire(Level world, Player player, ItemStack stack, InteractionHand hand) {
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return;
        }
        if (world.random.nextFloat() < this.getConfig().misfireChance()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.almirisweapons.misfire"));
            this.playSound(world, player, this.getConfig().misfireSound(), 1.0f, 1.0f);
            this.startReload(world, player, stack, hand);
            return;
        }
        ItemStack ammo = this.findAmmo(player);
        if (ammo.isEmpty() || ammo.getCount() < this.getConfig().ammoPerShot()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.almirisweapons.no_ammo"));
            return;
        }
        ammo.shrink(this.getConfig().ammoPerShot());
        for (int i = 0; i < this.getConfig().projectilesPerShot(); ++i) {
            ItemStack bulletStack = new ItemStack((ItemLike)ModItems.BULLET.get());
            BulletEntity bullet = new BulletEntity(world, (LivingEntity)player, bulletStack, stack);
            bullet.setDamage(this.getConfig().damage());
            bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + (world.random.nextFloat() - 0.5f) * this.getConfig().spreadAngle(), 0.0f, this.getConfig().velocity(), this.getConfig().inaccuracy());
            world.addFreshEntity((Entity)bullet);
        }
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        this.playSound(world, player, this.getConfig().shootSound(), this.getConfig().soundVolume(), this.getConfig().soundPitch());
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles(this.getConfig().smokeParticle(), player.getX(), player.getEyeY(), player.getZ(), this.getConfig().smokeCount(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpeed());
            if (this.getConfig().flameParticle() != null) {
                serverWorld.sendParticles(this.getConfig().flameParticle(), player.getX(), player.getEyeY(), player.getZ(), this.getConfig().flameCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.isClientSide) {
            FirearmItemRenderer.triggerRecoil(player.getUUID(), hand, this.getConfig().recoilStrength());
        }
        this.applyRecoil((LivingEntity)player);
        this.startReload(world, player, stack, hand);
    }

    protected void applyRecoil(LivingEntity user) {
        double yawRad = Math.toRadians(user.getYRot());
        double rx = -Math.sin(yawRad) * this.getConfig().recoilStrength();
        double rz = Math.cos(yawRad) * this.getConfig().recoilStrength();
        double ry = this.getConfig().recoilVertical();
        user.setDeltaMovement(user.getDeltaMovement().add(rx, ry, rz));
    }

    private ItemStack findAmmo(Player player) {
        if (player.getOffhandItem().is((Item)ModItems.BULLET.get())) {
            return player.getOffhandItem();
        }
        if (player.getMainHandItem().is((Item)ModItems.BULLET.get())) {
            return player.getMainHandItem();
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is((Item)ModItems.BULLET.get())) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        FirearmConfig cfg = this.getConfig();
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"item.modifiers.mainhand").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)" ").append(cfg.damage() + " ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"tooltip.almirisweapons.damage").withStyle(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.literal((String)" ").append((float)cfg.reloadTicks() / 20.0f + "s ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"tooltip.almirisweapons.reload_time").withStyle(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.literal((String)" ").append(cfg.ammoPerShot() + " ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"tooltip.almirisweapons.ammo_per_shot").withStyle(ChatFormatting.DARK_GREEN)));
        tooltip.add((Component)Component.literal((String)" ").append((int)(cfg.misfireChance() * 100.0f) + "% ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.translatable((String)"tooltip.almirisweapons.misfire").withStyle(ChatFormatting.DARK_GREEN)));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.getConfig().useAction();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.getConfig().maxUseTime();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private final FirearmItemRenderer renderer = new FirearmItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

