/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alminoris.almirisweapons.entity.custom.projectile.BulletEntity;
import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.item.custom.FirearmConfig;
import net.alminoris.almirisweapons.item.render.FirearmItemRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFirearmItem
extends class_1792 {
    private final Map<UUID, Integer> reloadTimers = new HashMap<UUID, Integer>();

    public AbstractFirearmItem(class_1792.class_1793 settings) {
        super(settings);
    }

    protected abstract FirearmConfig getConfig();

    protected abstract Map<UUID, Integer> getPullTicks();

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_7357().method_7904((class_1792)this)) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        this.getPullTicks().put(user.method_5667(), 0);
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        block9: {
            block8: {
                if (!(entity instanceof class_1657)) break block8;
                player = (class_1657)entity;
                if (!world.field_9236) break block9;
            }
            return;
        }
        UUID uuid = player.method_5667();
        if (this.getPullTicks().containsKey(uuid)) {
            int ticks = this.getPullTicks().get(uuid) + 1;
            this.getPullTicks().put(uuid, ticks);
            if (ticks >= this.getConfig().minUseTicks()) {
                this.getPullTicks().remove(uuid);
                player.method_6075();
                this.fire(world, player, player.method_5998(player.method_6058()), player.method_6058());
            }
        }
        if (this.reloadTimers.containsKey(uuid)) {
            int ticksLeft = this.reloadTimers.get(uuid) - 1;
            if (ticksLeft <= 0) {
                this.playSound(world, player, this.getConfig().reloadSound(), this.getConfig().reloadVolume(), this.getConfig().reloadPitch());
                this.reloadTimers.remove(uuid);
            } else {
                this.reloadTimers.put(uuid, ticksLeft);
            }
        }
    }

    private void startReload(class_1937 world, class_1657 player, class_1799 stack, class_1268 hand) {
        int reloadTime = this.getConfig().reloadTicks();
        player.method_7357().method_7906((class_1792)this, reloadTime);
        this.reloadTimers.put(player.method_5667(), reloadTime);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.getConfig().reloadParticle() != null) {
                serverWorld.method_14199(this.getConfig().reloadParticle(), player.method_23317(), player.method_23320() - 0.2, player.method_23321(), this.getConfig().reloadParticleCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.field_9236) {
            FirearmItemRenderer.startReload(player.method_5667(), hand, reloadTime);
        }
    }

    private void playSound(class_1937 world, class_1657 player, class_3414 sound, float volume, float pitch) {
        world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), sound, player.method_5634(), volume, pitch);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 player;
        block5: {
            block4: {
                if (!(user instanceof class_1657)) break block4;
                player = (class_1657)user;
                if (!world.field_9236) break block5;
            }
            return;
        }
        UUID uuid = player.method_5667();
        int usedTicks = this.getPullTicks().getOrDefault(uuid, 0);
        this.getPullTicks().remove(uuid);
        if (usedTicks >= this.getConfig().minUseTicks()) {
            this.fire(world, player, stack, player.method_6058());
        }
    }

    private void fire(class_1937 world, class_1657 player, class_1799 stack, class_1268 hand) {
        if (player.method_7357().method_7904((class_1792)this)) {
            return;
        }
        if (world.field_9229.nextFloat() < this.getConfig().misfireChance()) {
            player.method_7353((class_2561)new class_2588("message.almirisweapons.misfire"), true);
            this.playSound(world, player, this.getConfig().misfireSound(), 1.0f, 1.0f);
            this.startReload(world, player, stack, hand);
            return;
        }
        class_1799 ammo = this.findAmmo(player);
        if (ammo.method_7960() || ammo.method_7947() < this.getConfig().ammoPerShot()) {
            player.method_7353((class_2561)new class_2588("message.almirisweapons.no_ammo"), true);
            return;
        }
        ammo.method_7934(this.getConfig().ammoPerShot());
        for (int i = 0; i < this.getConfig().projectilesPerShot(); ++i) {
            class_1799 bulletStack = new class_1799((class_1935)ModItems.BULLET);
            BulletEntity bullet = new BulletEntity(world, (class_1309)player, bulletStack, stack);
            bullet.method_7438(this.getConfig().damage());
            bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454() + (world.field_9229.nextFloat() - 0.5f) * this.getConfig().spreadAngle(), 0.0f, this.getConfig().velocity(), this.getConfig().inaccuracy());
            world.method_8649((class_1297)bullet);
        }
        stack.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
        this.playSound(world, player, this.getConfig().shootSound(), this.getConfig().soundVolume(), this.getConfig().soundPitch());
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(this.getConfig().smokeParticle(), player.method_23317(), player.method_23320(), player.method_23321(), this.getConfig().smokeCount(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpread(), this.getConfig().smokeSpeed());
            if (this.getConfig().flameParticle() != null) {
                serverWorld.method_14199(this.getConfig().flameParticle(), player.method_23317(), player.method_23320(), player.method_23321(), this.getConfig().flameCount(), 0.05, 0.05, 0.05, 0.01);
            }
        }
        if (world.field_9236) {
            FirearmItemRenderer.triggerRecoil(player.method_5667(), hand, this.getConfig().recoilStrength());
        }
        this.applyRecoil((class_1309)player);
        this.startReload(world, player, stack, hand);
    }

    protected void applyRecoil(class_1309 user) {
        double yawRad = Math.toRadians(user.method_36454());
        double rx = -Math.sin(yawRad) * this.getConfig().recoilStrength();
        double rz = Math.cos(yawRad) * this.getConfig().recoilStrength();
        double ry = this.getConfig().recoilVertical();
        user.method_18799(user.method_18798().method_1031(rx, ry, rz));
    }

    private class_1799 findAmmo(class_1657 player) {
        if (player.method_6079().method_31574(ModItems.BULLET)) {
            return player.method_6079();
        }
        if (player.method_6047().method_31574(ModItems.BULLET)) {
            return player.method_6047();
        }
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!stack.method_31574(ModItems.BULLET)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        FirearmConfig cfg = this.getConfig();
        tooltip.add((class_2561)new class_2585(""));
        tooltip.add((class_2561)new class_2588("item.modifiers.mainhand").method_27692(class_124.field_1080));
        tooltip.add((class_2561)new class_2585(" ").method_10852((class_2561)new class_2585(cfg.damage() + " ").method_27692(class_124.field_1077)).method_10852((class_2561)new class_2588("tooltip.almirisweapons.damage").method_27692(class_124.field_1077)));
        tooltip.add((class_2561)new class_2585(" ").method_10852((class_2561)new class_2585((float)cfg.reloadTicks() / 20.0f + "s ").method_27692(class_124.field_1077)).method_10852((class_2561)new class_2588("tooltip.almirisweapons.reload_time").method_27692(class_124.field_1077)));
        tooltip.add((class_2561)new class_2585(" ").method_10852((class_2561)new class_2585(cfg.ammoPerShot() + " ").method_27692(class_124.field_1077)).method_10852((class_2561)new class_2588("tooltip.almirisweapons.ammo_per_shot").method_27692(class_124.field_1077)));
        tooltip.add((class_2561)new class_2585(" ").method_10852((class_2561)new class_2585((int)(cfg.misfireChance() * 100.0f) + "% ").method_27692(class_124.field_1077)).method_10852((class_2561)new class_2588("tooltip.almirisweapons.misfire").method_27692(class_124.field_1077)));
    }

    public class_1839 method_7853(class_1799 stack) {
        return this.getConfig().useAction();
    }

    public int method_7881(class_1799 stack) {
        return this.getConfig().maxUseTime();
    }
}

