/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.datagen;

import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.util.helper.WeaponSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "almirisweapons", existingFileHelper);
    }

    protected void registerModels() {
        this.generatedItem(ModItems.SMALL_STICK);
        this.generatedItem(ModItems.BULLET);
        this.generatedItem(ModItems.ARQUEBUS_BARREL);
        this.generatedItem(ModItems.BLUNDERBUSS_BARREL);
        this.generatedItem(ModItems.PISTOL_BARREL);
        this.generatedItem(ModItems.MATCHLOCK_MECHANISM);
        this.generatedItem(ModItems.GUN_STOCK);
        for (String name : WeaponSetsHelper.MATERIALS) {
            this.handheldItem(ModItems.DAGGERS.get(name));
            this.handheldItem(ModItems.BATTLE_AXES.get(name));
            this.handheldItem(ModItems.BEARDED_AXES.get(name));
            this.handheldItem(ModItems.MACES.get(name));
            this.generatedItem(ModItems.STABBING_TIPS.get(name));
            this.generatedItem(ModItems.MACE_TIPS.get(name));
            this.generatedItem(ModItems.AXE_TIPS.get(name));
            this.generatedItem(ModItems.CURVED_BLADES.get(name));
            this.generatedItem(ModItems.SINGLEEDGE_BLADES.get(name));
            this.generatedItem(ModItems.DOUBLEEDGE_BLADES.get(name));
        }
    }

    private ItemModelBuilder generatedItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"almirisweapons", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder handheldItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"almirisweapons", (String)("item/" + item.getId().getPath())));
    }
}

