/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.almirisweapons.entity.custom.projectile;

import net.alminoris.almirisweapons.entity.ModEntities;
import net.alminoris.almirisweapons.item.ModItems;
import net.alminoris.almirisweapons.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulletEntity
extends AbstractArrow {
    private double damage = 8.0;

    public BulletEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public BulletEntity(Level world, LivingEntity owner, ItemStack stack, @Nullable ItemStack shotFrom) {
        super((EntityType)ModEntities.BULLET.get(), owner, world, stack, shotFrom);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)ModSounds.EMPTY.get();
    }

    public void tick() {
        super.tick();
        if (this.getCommandSenderWorld().isClientSide && !this.inGround) {
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        Entity entity;
        super.onHitEntity(entityHitResult);
        if (!this.getCommandSenderWorld().isClientSide && (entity = entityHitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity shooter;
            Entity entity2;
            LivingEntity target = (LivingEntity)entity;
            DamageSource source = this.getCommandSenderWorld().damageSources().arrow((AbstractArrow)this, (entity2 = this.getOwner()) instanceof LivingEntity ? (shooter = (LivingEntity)entity2) : null);
            target.hurt(source, (float)this.damage);
            this.discard();
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.BULLET.get());
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        int count;
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide && (count = this.random.nextIntBetweenInclusive(0, 2)) > 0) {
            ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)Items.IRON_NUGGET, count));
            this.level().addFreshEntity((Entity)drop);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("BulletDamage")) {
            this.damage = nbt.getDouble("BulletDamage");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putDouble("BulletDamage", this.damage);
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }
}

