/*
 * Decompiled with CFR 0.152.
 */
package com.quinn275.hewn.block.custom;

import com.quinn275.hewn.block.ModBlocks;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class Wattle
extends Block {
    public static final EnumProperty<ConnectionType> CONNECTION = EnumProperty.create((String)"connection", ConnectionType.class);

    public Wattle() {
        super(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CONNECTION, (Comparable)((Object)ConnectionType.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.neighborChanged(state, world, pos, null, pos, isMoving);
    }

    private BlockState getUpdatedState(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockPos east = pos.east();
        BlockPos west = pos.west();
        BlockPos up = pos.above();
        BlockPos down = pos.below();
        BlockPos south = pos.south();
        BlockPos north = pos.north();
        BlockState upState = world.getBlockState(up);
        BlockState downState = world.getBlockState(down);
        BlockState eastState = world.getBlockState(east);
        BlockState westState = world.getBlockState(west);
        BlockState southState = world.getBlockState(south);
        BlockState northState = world.getBlockState(north);
        Block upBlock = upState.getBlock();
        Block downBlock = downState.getBlock();
        Block eastBlock = eastState.getBlock();
        Block westBlock = westState.getBlock();
        Block southBlock = southState.getBlock();
        Block northBlock = northState.getBlock();
        Block leftBlock = (Block)ModBlocks.WATTLE_LEFT.get();
        Block rightBlock = (Block)ModBlocks.WATTLE_RIGHT.get();
        Block crossBlock = (Block)ModBlocks.WATTLE_CROSS.get();
        HashSet<Block> leftBlocks = new HashSet<Block>(Arrays.asList(leftBlock, crossBlock));
        HashSet<Block> rightBlocks = new HashSet<Block>(Arrays.asList(rightBlock, crossBlock));
        if (upState.is(crossBlock) && eastState.is(crossBlock) && westState.is(crossBlock) && downState.is(crossBlock)) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.FOUR));
        }
        if (upState.is(crossBlock) && (leftBlocks.contains(eastBlock) && rightBlocks.contains(westBlock) || leftBlocks.contains(southBlock) && rightBlocks.contains(northBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_TOP));
        }
        if (downState.is(crossBlock) && (leftBlocks.contains(westBlock) && rightBlocks.contains(eastBlock) || leftBlocks.contains(northBlock) && rightBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_BOTTOM));
        }
        if (rightBlocks.contains(upBlock) && leftBlocks.contains(downBlock) && (westState.is(crossBlock) || northState.is(crossBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_EAST));
        }
        if (rightBlocks.contains(downBlock) && leftBlocks.contains(upBlock) && (eastState.is(crossBlock) || southState.is(crossBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_WEST));
        }
        if (rightBlocks.contains(upBlock) && rightBlocks.contains(downBlock) && rightBlocks.contains(eastBlock) && rightBlocks.contains(westBlock) || rightBlocks.contains(upBlock) && rightBlocks.contains(downBlock) && rightBlocks.contains(southBlock) && rightBlocks.contains(northBlock)) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL_LEFT));
        }
        if (leftBlocks.contains(upBlock) && leftBlocks.contains(downBlock) && leftBlocks.contains(eastBlock) && leftBlocks.contains(westBlock) || leftBlocks.contains(upBlock) && leftBlocks.contains(downBlock) && leftBlocks.contains(southBlock) && leftBlocks.contains(northBlock)) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL_RIGHT));
        }
        if (leftBlocks.contains(upBlock) && (leftBlocks.contains(eastBlock) || leftBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.TWO_EAST_TOP));
        }
        if (rightBlocks.contains(upBlock) && (rightBlocks.contains(westBlock) || rightBlocks.contains(northBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.TWO_WEST_TOP));
        }
        if (leftBlocks.contains(downBlock) && (leftBlocks.contains(westBlock) || leftBlocks.contains(northBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.TWO_WEST_BOTTOM));
        }
        if (rightBlocks.contains(downBlock) && (rightBlocks.contains(eastBlock) || rightBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.TWO_EAST_BOTTOM));
        }
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.NONE));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.getUpdatedState(state, (LevelAccessor)world, pos);
        if (!newState.equals(state)) {
            world.setBlockAndUpdate(pos, newState);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState = this.getUpdatedState(state, level, pos);
        return newState;
    }

    public static enum ConnectionType implements StringRepresentable
    {
        NONE("none"),
        TWO_WEST_TOP("two_west_top"),
        TWO_WEST_BOTTOM("two_west_bottom"),
        TWO_EAST_TOP("two_east_top"),
        TWO_EAST_BOTTOM("two_east_bottom"),
        THREE_WEST("three_west"),
        THREE_EAST("three_east"),
        THREE_TOP("three_top"),
        THREE_BOTTOM("three_bottom"),
        DIAGONAL_LEFT("diagonal_left"),
        DIAGONAL_RIGHT("diagonal_right"),
        FOUR("four");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

