/*
 * Decompiled with CFR 0.152.
 */
package com.quinn275.hewn.block.custom;

import com.quinn275.hewn.block.ModBlocks;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WattleRight
extends Block {
    public static final EnumProperty<ConnectionType> CONNECTION = EnumProperty.create((String)"connection", ConnectionType.class);

    public WattleRight() {
        super(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CONNECTION, (Comparable)((Object)ConnectionType.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.neighborChanged(state, world, pos, null, pos, isMoving);
    }

    private BlockState getUpdatedState(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockPos east = pos.east();
        BlockPos west = pos.west();
        BlockPos up = pos.above();
        BlockPos down = pos.below();
        BlockPos south = pos.south();
        BlockPos north = pos.north();
        BlockPos downEast = pos.below().east();
        BlockPos downSouth = pos.below().south();
        BlockPos upWest = pos.above().west();
        BlockPos upNorth = pos.above().north();
        BlockState upState = world.getBlockState(up);
        BlockState downState = world.getBlockState(down);
        BlockState eastState = world.getBlockState(east);
        BlockState westState = world.getBlockState(west);
        BlockState southState = world.getBlockState(south);
        BlockState northState = world.getBlockState(north);
        BlockState downEastState = world.getBlockState(downEast);
        BlockState upWestState = world.getBlockState(upWest);
        BlockState downSouthState = world.getBlockState(downSouth);
        BlockState upNorthState = world.getBlockState(upNorth);
        Block upBlock = upState.getBlock();
        Block downBlock = downState.getBlock();
        Block eastBlock = eastState.getBlock();
        Block westBlock = westState.getBlock();
        Block southBlock = southState.getBlock();
        Block northBlock = northState.getBlock();
        Block downEastBlock = downEastState.getBlock();
        Block upWestBlock = upWestState.getBlock();
        Block downSouthBlock = downSouthState.getBlock();
        Block upNorthBlock = upNorthState.getBlock();
        Block rightBlock = (Block)ModBlocks.WATTLE_RIGHT.get();
        Block crossBlock = (Block)ModBlocks.WATTLE_CROSS.get();
        HashSet<Block> includedBlocks = new HashSet<Block>(Arrays.asList(rightBlock, (Block)ModBlocks.WATTLE_LEFT.get(), crossBlock));
        HashSet<Block> selfBlocks = new HashSet<Block>(Arrays.asList(rightBlock, crossBlock));
        if ((selfBlocks.contains(eastBlock) && selfBlocks.contains(westBlock) || selfBlocks.contains(southBlock) && selfBlocks.contains(northBlock)) && selfBlocks.contains(upBlock) && selfBlocks.contains(downBlock)) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL));
        }
        if (selfBlocks.contains(upBlock) && selfBlocks.contains(downBlock) && (selfBlocks.contains(eastBlock) && includedBlocks.contains(downEastBlock) && !selfBlocks.contains(downEastBlock) || selfBlocks.contains(southBlock) && includedBlocks.contains(downSouthBlock) && !selfBlocks.contains(downSouthBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL));
        }
        if (selfBlocks.contains(upBlock) && selfBlocks.contains(downBlock) && (selfBlocks.contains(westBlock) && includedBlocks.contains(upWestBlock) && !selfBlocks.contains(upWestBlock) || selfBlocks.contains(northBlock) && includedBlocks.contains(upNorthBlock) && !selfBlocks.contains(upNorthBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL));
        }
        if ((selfBlocks.contains(upBlock) && (selfBlocks.contains(eastBlock) || selfBlocks.contains(southBlock)) || selfBlocks.contains(downBlock) && (selfBlocks.contains(eastBlock) || selfBlocks.contains(northBlock))) && (!selfBlocks.contains(westBlock) && selfBlocks.contains(downEastBlock) || !selfBlocks.contains(northBlock) && selfBlocks.contains(downSouthBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_BOTTOM));
        }
        if ((selfBlocks.contains(upBlock) || selfBlocks.contains(downBlock)) && (selfBlocks.contains(westBlock) && !selfBlocks.contains(eastBlock) || selfBlocks.contains(northBlock) && !selfBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_TOP));
        }
        if (selfBlocks.contains(upBlock) && (selfBlocks.contains(westBlock) && selfBlocks.contains(eastBlock) || selfBlocks.contains(northBlock) && selfBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_TOP));
        }
        if (selfBlocks.contains(downBlock) && (selfBlocks.contains(westBlock) && selfBlocks.contains(eastBlock) || selfBlocks.contains(northBlock) && selfBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_BOTTOM));
        }
        if (selfBlocks.contains(upBlock) && (selfBlocks.contains(westBlock) || selfBlocks.contains(northBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_TOP));
        }
        if (selfBlocks.contains(downBlock) && (selfBlocks.contains(eastBlock) || selfBlocks.contains(southBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.THREE_BOTTOM));
        }
        if (selfBlocks.contains(upBlock) && (includedBlocks.contains(upWestBlock) && !selfBlocks.contains(upWestBlock) || includedBlocks.contains(upNorthBlock) && !selfBlocks.contains(upNorthBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL));
        }
        if (selfBlocks.contains(downBlock) && (includedBlocks.contains(downEastBlock) && !selfBlocks.contains(downEastBlock) || includedBlocks.contains(downSouthBlock) && !selfBlocks.contains(downSouthBlock))) {
            return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.DIAGONAL));
        }
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)ConnectionType.NONE));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.getUpdatedState(state, (LevelAccessor)world, pos);
        if (!newState.equals(state)) {
            world.setBlockAndUpdate(pos, newState);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockState newState = this.getUpdatedState(state, level, pos);
        return newState;
    }

    public static enum ConnectionType implements StringRepresentable
    {
        NONE("none"),
        THREE_TOP("three_top"),
        THREE_BOTTOM("three_bottom"),
        DIAGONAL("diagonal");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

