/*
 * Decompiled with CFR 0.152.
 */
package com.quinn275.hewn.item.custom;

import com.quinn275.hewn.block.ModBlocks;
import com.quinn275.hewn.component.ModDataComponents;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class HammerToolItem
extends Item {
    private static final Map<Block, Block> HAMMER_MAP = Map.of((Block)ModBlocks.WATTLE.get(), (Block)ModBlocks.WATTLE_B.get(), (Block)ModBlocks.WATTLE_B.get(), (Block)ModBlocks.WATTLE.get(), (Block)ModBlocks.WATTLE_LEFT.get(), (Block)ModBlocks.WATTLE_LEFT_B.get(), (Block)ModBlocks.WATTLE_LEFT_B.get(), (Block)ModBlocks.WATTLE_LEFT.get(), (Block)ModBlocks.WATTLE_RIGHT.get(), (Block)ModBlocks.WATTLE_RIGHT_B.get(), (Block)ModBlocks.WATTLE_RIGHT_B.get(), (Block)ModBlocks.WATTLE_RIGHT.get(), (Block)ModBlocks.WATTLE_CROSS.get(), (Block)ModBlocks.WATTLE_CROSS_B.get(), (Block)ModBlocks.WATTLE_CROSS_B.get(), (Block)ModBlocks.WATTLE_CROSS.get());

    public HammerToolItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hewn.hammer_tool.shift_down"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hewn.hammer_tool"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Block clickedBlock = level.getBlockState(context.getClickedPos()).getBlock();
        if (HAMMER_MAP.containsKey(clickedBlock) && !level.isClientSide()) {
            level.setBlockAndUpdate(context.getClickedPos(), HAMMER_MAP.get(clickedBlock).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (ServerLevel)level, (LivingEntity)context.getPlayer(), item -> context.getPlayer().onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            level.playSound(null, context.getClickedPos(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS);
            context.getItemInHand().set(ModDataComponents.COORDINATES, (Object)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

