/*
 * Decompiled with CFR 0.152.
 */
package com.quinn275.hewn.item.custom;

import com.quinn275.hewn.component.ModDataComponents;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TestItem
extends Item {
    private static final Map<Block, Block> NORTH_CYCLE = Map.of(Blocks.COAL_BLOCK, Blocks.DIAMOND_BLOCK, Blocks.DIAMOND_BLOCK, Blocks.COAL_BLOCK);
    private static final Map<Direction, Map<Block, Block>> CYCLE_MAP = Map.of(Direction.NORTH, NORTH_CYCLE);

    public TestItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hewn.test_item.shift_down"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hewn.test_item"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Block clickedBlock = level.getBlockState(context.getClickedPos()).getBlock();
        Direction face = context.getClickedFace();
        Map<Block, Block> faceMap = CYCLE_MAP.get(face);
        if (faceMap != null && faceMap.containsKey(clickedBlock) && !level.isClientSide()) {
            level.setBlockAndUpdate(context.getClickedPos(), faceMap.get(clickedBlock).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (ServerLevel)level, (LivingEntity)context.getPlayer(), item -> context.getPlayer().onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            level.playSound(null, context.getClickedPos(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS);
            context.getItemInHand().set(ModDataComponents.COORDINATES, (Object)context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }
}

