/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lv.id.bonne.animalpenpaper.config.annotations.JsonComment;
import lv.id.bonne.animalpenpaper.config.annotations.JsonComments;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AnimalFoodConfiguration {
    @JsonComments(value={@JsonComment(value="List of food items for each animal."), @JsonComment(value="`minecraft:<entity>` is a way how to define entity to have food item."), @JsonComment(value="Food items are list of foods: []"), @JsonComment(value="Adding `#` before food item indicates that it is a tag. Otherwise it is parsed as item."), @JsonComment(value="<entity> : [<food_list>].")})
    @Expose
    @SerializedName(value="animal_foods")
    private Map<NamespacedKey, List<FoodItem>> foodItems = new LinkedHashMap<NamespacedKey, List<FoodItem>>();

    public static AnimalFoodConfiguration getDefaultConfig() {
        AnimalFoodConfiguration configuration = new AnimalFoodConfiguration();
        configuration.setDefaults(true);
        return configuration;
    }

    public boolean isInvalid() {
        return this.foodItems == null;
    }

    public void setDefaults(boolean init) {
        if (this.foodItems == null || init) {
            this.foodItems = new HashMap<NamespacedKey, List<FoodItem>>();
            this.populateDefaultCooldowns();
        }
    }

    private void populateDefaultCooldowns() {
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"armadillo"), i -> List.of(new FoodItem("#minecraft:armadillo_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"axolotl"), i -> List.of(new FoodItem("#minecraft:axolotl_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"bee"), i -> List.of(new FoodItem("#minecraft:bee_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"camel"), i -> List.of(new FoodItem("#minecraft:camel_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"cat"), i -> List.of(new FoodItem("#minecraft:cat_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"chicken"), i -> List.of(new FoodItem("#minecraft:chicken_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"cod"), i -> List.of(new FoodItem("minecraft:seagrass"), new FoodItem("minecraft:kelp")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"cow"), i -> List.of(new FoodItem("#minecraft:cow_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"dolphin"), i -> List.of(new FoodItem("#minecraft:fishes")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"donkey"), i -> List.of(new FoodItem("#minecraft:donkey_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"fox"), i -> List.of(new FoodItem("#minecraft:fox_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"frog"), i -> List.of(new FoodItem("#minecraft:frog_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"glow_squid"), i -> List.of(new FoodItem("#minecraft:fishes")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"goat"), i -> List.of(new FoodItem("#minecraft:goat_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"hoglin"), i -> List.of(new FoodItem("#minecraft:hoglin_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"horse"), i -> List.of(new FoodItem("#minecraft:horse_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"llama"), i -> List.of(new FoodItem("#minecraft:llama_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"mooshroom"), i -> List.of(new FoodItem("#minecraft:cow_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"mule"), i -> List.of(new FoodItem("#minecraft:mule_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"ocelot"), i -> List.of(new FoodItem("#minecraft:ocelot_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"panda"), i -> List.of(new FoodItem("#minecraft:panda_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"parrot"), i -> List.of(new FoodItem("#minecraft:parrot_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"pig"), i -> List.of(new FoodItem("#minecraft:pig_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"polar_bear"), i -> List.of(new FoodItem("minecraft:salmon")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"pufferfish"), i -> List.of(new FoodItem("minecraft:seagrass"), new FoodItem("minecraft:kelp")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"rabbit"), i -> List.of(new FoodItem("#minecraft:rabbit_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"salmon"), i -> List.of(new FoodItem("minecraft:seagrass"), new FoodItem("minecraft:kelp")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"sheep"), i -> List.of(new FoodItem("#minecraft:sheep_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"skeleton_horse"), i -> List.of(new FoodItem("#minecraft:horse_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"sniffer"), i -> List.of(new FoodItem("#minecraft:sniffer_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"squid"), i -> List.of(new FoodItem("#minecraft:fishes")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"strider"), i -> List.of(new FoodItem("#minecraft:strider_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"trader_llama"), i -> List.of(new FoodItem("#minecraft:trader_llama_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"tropical_fish"), i -> List.of(new FoodItem("minecraft:seagrass"), new FoodItem("minecraft:kelp")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"turtle"), i -> List.of(new FoodItem("#minecraft:turtle_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"wolf"), i -> List.of(new FoodItem("#minecraft:wolf_food")));
        this.foodItems.computeIfAbsent(NamespacedKey.minecraft((String)"zombie_horse"), i -> List.of(new FoodItem("#minecraft:horse_food")));
    }

    public boolean isFoodItem(@NotNull Entity entity, ItemStack item) {
        return this.foodItems.getOrDefault(entity.getType().getKey(), Collections.emptyList()).stream().anyMatch(foodItem -> foodItem.matches(item));
    }

    public List<Material> getFoodItems(EntityType entityType) {
        return this.foodItems.getOrDefault(entityType.getKey(), Collections.emptyList()).stream().flatMap(foodItem -> foodItem.allFoodItems.stream()).collect(Collectors.toList());
    }

    public static class FoodItem {
        private final String identifier;
        private final boolean isTag;
        private final Material material;
        private final NamespacedKey tagKey;
        private final List<Material> allFoodItems;

        public FoodItem(String identifier) {
            this.identifier = identifier;
            this.isTag = identifier.startsWith("#");
            this.allFoodItems = new ArrayList<Material>(1);
            if (this.isTag) {
                Tag tag;
                String tagName = identifier.substring(1);
                this.tagKey = NamespacedKey.fromString((String)tagName);
                this.material = null;
                if (this.tagKey != null && (tag = Bukkit.getTag((String)"items", (NamespacedKey)this.tagKey, Material.class)) != null) {
                    Arrays.stream(Material.values()).filter(arg_0 -> ((Tag)tag).isTagged(arg_0)).forEach(this.allFoodItems::add);
                }
            } else {
                this.material = Material.matchMaterial((String)identifier);
                this.allFoodItems.add(this.material);
                this.tagKey = null;
            }
        }

        public boolean matches(ItemStack itemStack) {
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                return false;
            }
            if (this.isTag) {
                if (this.tagKey == null) {
                    return false;
                }
                Tag tag = Bukkit.getTag((String)"items", (NamespacedKey)this.tagKey, Material.class);
                return tag != null && tag.isTagged((Keyed)itemStack.getType());
            }
            return this.material != null && itemStack.getType() == this.material;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

