/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.config.AnimalFoodConfiguration;
import lv.id.bonne.animalpenpaper.config.Configuration;
import lv.id.bonne.animalpenpaper.config.adapters.FoodItemTypeAdapter;
import lv.id.bonne.animalpenpaper.config.adapters.NamespacedKeyTypeAdapter;
import lv.id.bonne.animalpenpaper.config.util.CommentGeneration;
import org.bukkit.NamespacedKey;

public class ConfigurationManager {
    private final Gson gson;
    private Configuration configuration;
    private AnimalFoodConfiguration animalFoodConfiguration;

    public ConfigurationManager() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(NamespacedKey.class, (Object)new NamespacedKeyTypeAdapter());
        builder.registerTypeAdapter(AnimalFoodConfiguration.FoodItem.class, (Object)new FoodItemTypeAdapter());
        this.gson = builder.create();
    }

    public void generateConfig(Variants config) {
        this.reset(config);
        try {
            this.writeConfig(config, true);
        }
        catch (IOException e) {
            AnimalPenPlugin.getInstance().getLogger().throwing("ConfigManager", "Error Generating config file: ", e);
        }
    }

    private File getConfigFile(Variants config) {
        return new File(AnimalPenPlugin.getInstance().getDataFolder(), config.getFile());
    }

    public void readConfig() {
        FileReader reader;
        try {
            reader = new FileReader(this.getConfigFile(Variants.GENERAL));
            try {
                this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
                if (this.isInvalid(Variants.GENERAL)) {
                    this.configuration.setDefaults(false);
                    this.writeConfig(Variants.GENERAL, false);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (JsonSyntaxException var2) {
            this.reset(Variants.GENERAL);
            try {
                this.writeConfig(Variants.GENERAL, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to read config. Generated default one.");
        }
        catch (IOException var2) {
            this.generateConfig(Variants.GENERAL);
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to open config. Generated default one.");
        }
        try {
            reader = new FileReader(this.getConfigFile(Variants.ANIMAL_FOOD));
            try {
                this.animalFoodConfiguration = (AnimalFoodConfiguration)this.gson.fromJson((Reader)reader, AnimalFoodConfiguration.class);
                if (this.isInvalid(Variants.ANIMAL_FOOD)) {
                    this.animalFoodConfiguration.setDefaults(false);
                    this.writeConfig(Variants.ANIMAL_FOOD, false);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (JsonSyntaxException var2) {
            this.reset(Variants.ANIMAL_FOOD);
            try {
                this.writeConfig(Variants.ANIMAL_FOOD, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to read animal food config. Generated default one.");
        }
        catch (IOException var2) {
            this.generateConfig(Variants.ANIMAL_FOOD);
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to open animal food config. Generated default one.");
        }
    }

    public void reloadConfig() {
        FileReader reader;
        try {
            reader = new FileReader(this.getConfigFile(Variants.GENERAL));
            try {
                this.configuration = (Configuration)this.gson.fromJson((Reader)reader, Configuration.class);
                if (this.isInvalid(Variants.GENERAL)) {
                    AnimalPenPlugin.getInstance().getLogger().warning("Failed to validate config.");
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException var2) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to read config. " + var2.getMessage());
        }
        try {
            reader = new FileReader(this.getConfigFile(Variants.ANIMAL_FOOD));
            try {
                this.animalFoodConfiguration = (AnimalFoodConfiguration)this.gson.fromJson((Reader)reader, AnimalFoodConfiguration.class);
                if (this.isInvalid(Variants.ANIMAL_FOOD)) {
                    AnimalPenPlugin.getInstance().getLogger().warning("Failed to validate animal food config.");
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException var2) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to read animal food config. " + var2.getMessage());
        }
    }

    protected void reset(Variants config) {
        if (config == Variants.GENERAL) {
            this.configuration = Configuration.getDefaultConfig();
        }
        if (config == Variants.ANIMAL_FOOD) {
            this.animalFoodConfiguration = AnimalFoodConfiguration.getDefaultConfig();
        }
    }

    private boolean isInvalid(Variants config) {
        if (config == Variants.GENERAL) {
            return this.configuration == null || this.configuration.isInvalid();
        }
        if (config == Variants.ANIMAL_FOOD) {
            return this.animalFoodConfiguration == null || this.animalFoodConfiguration.isInvalid();
        }
        return true;
    }

    public void writeConfig(Variants config, boolean overwrite) throws IOException {
        File dir = AnimalPenPlugin.getInstance().getDataFolder();
        if (dir.exists() || dir.mkdirs()) {
            if (this.getConfigFile(config).exists() && !overwrite) {
                File backupFile;
                int backupNumber = 1;
                do {
                    backupFile = new File(dir, this.getConfigFile(config).getName() + ".bak" + backupNumber);
                    ++backupNumber;
                } while (backupFile.exists());
                Files.copy(this.getConfigFile(config).toPath(), backupFile.toPath(), new CopyOption[0]);
            }
            if (this.getConfigFile(config).exists() || this.getConfigFile(config).createNewFile()) {
                try {
                    Path path = Paths.get(this.getConfigFile(config).toURI());
                    if (config == Variants.GENERAL) {
                        Files.write(path, CommentGeneration.writeWithComments(this.gson, this.configuration).getBytes(), new OpenOption[0]);
                    }
                    if (config == Variants.ANIMAL_FOOD) {
                        Files.write(path, CommentGeneration.writeWithComments(this.gson, this.animalFoodConfiguration).getBytes(), new OpenOption[0]);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public AnimalFoodConfiguration getAnimalFoodConfiguration() {
        return this.animalFoodConfiguration;
    }

    public static enum Variants {
        GENERAL("config.json"),
        ANIMAL_FOOD("animal_foods.json");

        private final String file;

        private Variants(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

