/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.data;

import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lv.id.bonne.animalpenpaper.config.adapters.EntitySnapshotTypeAdapter;
import org.bukkit.Material;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class AnimalData {
    private final Map<Material, Integer> cooldowns = new HashMap<Material, Integer>();
    private final List<EntitySnapshot> variants = new ArrayList<EntitySnapshot>();
    @JsonAdapter(value=EntitySnapshotTypeAdapter.class)
    private EntitySnapshot entitySnapshot = null;
    public int version = 1;
    private EntityType entityType;
    private long entityCount;
    private int scuteCount;
    @Nullable
    private Material appliedMaterial;
    @Nullable
    private Boolean appliedFlag;

    public AnimalData(EntityType entityType, EntitySnapshot entitySnapshot, long entityCount) {
        this.entityType = entityType;
        this.entityCount = entityCount;
        this.entitySnapshot = entitySnapshot;
    }

    public AnimalData() {
    }

    public void setCooldown(Material key, int value) {
        this.cooldowns.put(key, value);
    }

    public int getCooldown(Material key) {
        return this.cooldowns.getOrDefault(key, 0);
    }

    public boolean hasCooldown(Material key) {
        return this.cooldowns.containsKey(key) && this.cooldowns.get(key) > 0;
    }

    public Map<Material, Integer> getCooldowns() {
        return this.cooldowns;
    }

    public int scutes() {
        return this.scuteCount;
    }

    public void setScutes(int scuteCount) {
        this.scuteCount = scuteCount;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public EntitySnapshot entitySnapshot() {
        return this.entitySnapshot;
    }

    public void setEntitySnapshot(EntitySnapshot entitySnapshot) {
        this.entitySnapshot = entitySnapshot;
    }

    public long entityCount() {
        return this.entityCount;
    }

    public void setEntityCount(long entityCount) {
        this.entityCount = entityCount;
    }

    public void addEntityCount(long amount) {
        this.entityCount += amount;
    }

    public void reduceEntityCount(long amount) {
        this.entityCount -= amount;
    }

    public List<EntitySnapshot> getVariants() {
        return this.variants;
    }

    public void addVariant(EntitySnapshot snapshot) {
        this.variants.add(snapshot);
    }

    public void setAppliedMaterial(@Nullable Material material) {
        this.appliedMaterial = material;
    }

    public void setAppliedFlag(@Nullable Boolean flag) {
        this.appliedFlag = flag;
    }

    public Optional<Boolean> getAppliedFlag() {
        return Optional.ofNullable(this.appliedFlag);
    }

    public Optional<Material> getAppliedMaterial() {
        return Optional.ofNullable(this.appliedMaterial);
    }
}

