/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.BlockData;
import org.bukkit.block.BlockFace;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BlockDataType
implements PersistentDataType<String, BlockData> {
    public static final BlockDataType INSTANCE = new BlockDataType();
    private static final Gson GSON = new GsonBuilder().create();

    @NotNull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @NotNull
    public Class<BlockData> getComplexType() {
        return BlockData.class;
    }

    @NotNull
    public String toPrimitive(@NotNull BlockData complex, @NotNull PersistentDataAdapterContext context) {
        try {
            return GSON.toJson((Object)complex);
        }
        catch (Exception e) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to serialize BlockData: " + e.getMessage());
            return "{\"blockFace\":\"NORTH\",\"cooldowns\":[]}";
        }
    }

    @NotNull
    public BlockData fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
        try {
            BlockData data = (BlockData)GSON.fromJson(primitive, BlockData.class);
            if (data.blockFace == null) {
                data.blockFace = BlockFace.NORTH;
            }
            if (data.version == 0) {
                data.version = 1;
            }
            return data;
        }
        catch (JsonSyntaxException e) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to deserialize BlockData: " + e.getMessage());
            AnimalPenPlugin.getInstance().getLogger().warning("Raw JSON: " + primitive);
            BlockData fallback = new BlockData();
            fallback.blockFace = BlockFace.NORTH;
            return fallback;
        }
    }
}

