/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.listeners;

import com.destroystokyo.paper.event.entity.EntityZapEvent;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.List;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.data.BlockData;
import lv.id.bonne.animalpenpaper.events.block.AnimalBlockAttackEvent;
import lv.id.bonne.animalpenpaper.events.block.AnimalBlockBreakEvent;
import lv.id.bonne.animalpenpaper.events.block.AnimalBlockInteractEvent;
import lv.id.bonne.animalpenpaper.events.block.AnimalBlockPlaceEvent;
import lv.id.bonne.animalpenpaper.managers.AquariumManager;
import lv.id.bonne.animalpenpaper.menu.AnimalPenVariantMenu;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import lv.id.bonne.animalpenpaper.util.Utils;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.block.data.type.Slab;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AquariumListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenPlace(BlockPlaceEvent event) {
        BlockFace blockFace;
        if (!AquariumManager.isAquarium(event.getItemInHand())) {
            return;
        }
        if (event.getBlockReplacedState().getType() == Material.SMOOTH_STONE_SLAB) {
            event.setCancelled(true);
            return;
        }
        AnimalBlockPlaceEvent placeEvent = new AnimalBlockPlaceEvent(event.getPlayer(), event.getBlock().getLocation(), false);
        if (!placeEvent.callEvent()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        org.bukkit.block.data.BlockData blockData = event.getBlock().getBlockData();
        if (blockData instanceof Slab) {
            Slab slab = (Slab)blockData;
            slab.setType(Slab.Type.BOTTOM);
            slab.setWaterlogged(false);
            block.setBlockData((org.bukkit.block.data.BlockData)slab);
        }
        if ((blockFace = event.getBlockAgainst().getFace(event.getBlock())) == BlockFace.UP || blockFace == BlockFace.DOWN) {
            blockFace = event.getPlayer().getFacing().getOppositeFace();
        }
        BlockData data = new BlockData();
        data.blockFace = blockFace;
        AquariumManager.completeAquariumCreation(block, data, event.getItemInHand());
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenBreak(BlockBreakEvent event) {
        org.bukkit.block.data.BlockData blockData;
        if (!AquariumManager.isAquarium(event.getBlock())) {
            return;
        }
        Block block = event.getBlock();
        AnimalData animalData = AquariumManager.getAnimalData(block);
        AnimalBlockBreakEvent breakEvent = new AnimalBlockBreakEvent(event.getPlayer(), event.getBlock().getLocation(), animalData, false);
        if (!breakEvent.callEvent()) {
            event.setCancelled(true);
            return;
        }
        if (animalData != null) {
            ItemStack itemStack = AquariumManager.createEmptyWaterContainer();
            AquariumManager.setWaterContainerData(itemStack, animalData);
            block.getWorld().dropItem(block.getLocation(), itemStack);
        }
        if ((blockData = block.getBlockData()) instanceof Slab) {
            Slab slab = (Slab)blockData;
            block.getRelative(BlockFace.UP).setType(Material.AIR);
            slab.setWaterlogged(false);
            block.setBlockData((org.bukkit.block.data.BlockData)slab);
        }
        ItemStack animalPenItem = AquariumManager.getAquariumItem(block);
        AquariumManager.clearBlockData(block, false);
        event.setDropItems(false);
        block.getWorld().dropItem(block.getLocation(), animalPenItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        Entity eventEntity = event.getRightClicked();
        if (!AquariumManager.isAquarium(eventEntity) || !(eventEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)eventEntity;
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getItem(event.getHand());
        if (AquariumManager.isWaterContainer(itemStack)) {
            return;
        }
        AnimalPenPlugin.getInstance().task.startTrackingEntity((Entity)entity, false, false);
        event.setCancelled(true);
        AnimalBlockInteractEvent interactEvent = new AnimalBlockInteractEvent(player, itemStack, event.getHand(), entity.getLocation(), AquariumManager.getAnimalData((Entity)entity), false);
        if (!interactEvent.callEvent()) {
            return;
        }
        if (itemStack.isEmpty() && event.getHand() == EquipmentSlot.HAND) {
            AnimalPenVariantMenu.openMenu((Entity)entity, player);
            return;
        }
        if (AnimalPenPlugin.animalFoodConfiguration().isFoodItem((Entity)entity, itemStack)) {
            AquariumManager.handleFood(entity, player, itemStack);
        } else if (itemStack.getType() == Material.WATER_BUCKET) {
            AquariumManager.handleWaterBucket((Entity)entity, player, itemStack);
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void onEntityLootDropping(EntityDamageEvent event) {
        Entity eventEntity = event.getEntity();
        if (!AquariumManager.isAquarium(eventEntity) || !(eventEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)eventEntity;
        event.setCancelled(true);
        Entity directEntity = event.getDamageSource().getDirectEntity();
        if (directEntity == null || directEntity.getType() != EntityType.PLAYER) {
            return;
        }
        if (event.getDamageSource().getDamageType() != DamageType.PLAYER_ATTACK) {
            return;
        }
        Player player = (Player)directEntity;
        ItemStack attackItem = player.getInventory().getItemInMainHand();
        if (player.hasCooldown(attackItem)) {
            return;
        }
        if (!Utils.getTag(NamespacedKey.minecraft((String)"swords")).isTagged((Keyed)attackItem.getType()) && !Utils.getTag(NamespacedKey.minecraft((String)"axes")).isTagged((Keyed)attackItem.getType())) {
            return;
        }
        AnimalBlockAttackEvent attackEvent = new AnimalBlockAttackEvent(player, attackItem, entity.getLocation(), AquariumManager.getAnimalData((Entity)entity), false);
        if (!attackEvent.callEvent()) {
            return;
        }
        AquariumManager.handleKilling(entity, player, attackItem);
    }

    @EventHandler
    public void onAnimalPenExplode(BlockExplodeEvent event) {
        boolean hasAnimalPen = event.blockList().stream().anyMatch(AquariumManager::isAquarium);
        if (!hasAnimalPen) {
            return;
        }
        event.blockList().removeIf(AquariumManager::isAquarium);
    }

    @EventHandler
    public void onAnimalPenExplode(EntityExplodeEvent event) {
        boolean hasAnimalPen = event.blockList().stream().anyMatch(AquariumManager::isAquarium);
        if (!hasAnimalPen) {
            return;
        }
        event.blockList().removeIf(AquariumManager::isAquarium);
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenPush(BlockPistonExtendEvent event) {
        boolean hasAnimalPen = event.getBlocks().stream().anyMatch(AquariumManager::isAquarium);
        if (!hasAnimalPen) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenPush(BlockPistonRetractEvent event) {
        boolean hasAnimalPen = event.getBlocks().stream().anyMatch(AquariumManager::isAquarium);
        if (!hasAnimalPen) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenPlaceBlock(BlockCanBuildEvent event) {
        if (!AquariumManager.isAquarium(event.getBlock())) {
            return;
        }
        event.setBuildable(false);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!AquariumManager.isAquarium(entity)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageOtherEntities(EntityDamageEvent event) {
        Entity entity = event.getDamageSource().getCausingEntity();
        if (entity == null || !AquariumManager.isAquarium(entity)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityRemoveEvent(EntityDeathEvent event) {
        if (AquariumManager.isAquarium((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityZapEvent(EntityZapEvent event) {
        if (AquariumManager.isAquarium(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTransformEvent(EntityTransformEvent event) {
        if (AquariumManager.isAquarium(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWaterPlace(PlayerBucketEmptyEvent event) {
        if (AquariumManager.isAquarium(event.getBlock()) || AquariumManager.isAquarium(event.getBlock().getRelative(BlockFace.DOWN))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWaterPlace(PlayerBucketFillEvent event) {
        if (AquariumManager.isAquarium(event.getBlock()) || AquariumManager.isAquarium(event.getBlock().getRelative(BlockFace.DOWN))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWaterSpread(BlockFromToEvent event) {
        if (AquariumManager.isAquarium(event.getToBlock())) {
            event.setCancelled(true);
        }
        if (AquariumManager.isAquarium(event.getBlock())) {
            event.setCancelled(true);
        }
        if (AquariumManager.isAquarium(event.getToBlock().getRelative(BlockFace.DOWN))) {
            event.setCancelled(true);
        }
        if (AquariumManager.isAquarium(event.getBlock().getRelative(BlockFace.DOWN))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        if (event.getTarget() != null && AquariumManager.isAquarium((Entity)event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDispenseArmor(BlockDispenseArmorEvent event) {
        if (AquariumManager.isAquarium((Entity)event.getTargetEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDispenseBlock(BlockDispenseEvent event) {
        org.bukkit.block.data.BlockData blockData = event.getBlock().getBlockData();
        if (blockData instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)blockData;
            if (AquariumManager.isAquarium(event.getBlock().getRelative(dispenser.getFacing())) || AquariumManager.isAquarium(event.getBlock().getRelative(dispenser.getFacing()).getRelative(BlockFace.DOWN))) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onSponge(SpongeAbsorbEvent event) {
        event.getBlocks().removeIf(blockState -> {
            Block block = blockState.getBlock();
            return AquariumManager.isAquarium(block) || AquariumManager.isAquarium(block.getRelative(BlockFace.DOWN));
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDropItems(EntityDropItemEvent event) {
        if (AquariumManager.isAquarium(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityPickUpItems(EntityPickupItemEvent event) {
        if (AquariumManager.isAquarium((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        ItemStack result = event.getRecipe().getResult();
        if (!result.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
            return;
        }
        CustomModelData data = (CustomModelData)result.getData(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (data.strings().contains("animal_pen:aquarium")) {
            ItemMeta itemMeta = result.getItemMeta();
            itemMeta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.name").style(StyleUtil.WHITE));
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line3")));
            result.setItemMeta(itemMeta);
            event.setCurrentItem(result);
        }
    }
}

