/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.listeners;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.Iterator;
import java.util.List;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.events.item.AnimalCatchEvent;
import lv.id.bonne.animalpenpaper.events.item.AnimalDepositEvent;
import lv.id.bonne.animalpenpaper.events.item.AnimalReleaseEvent;
import lv.id.bonne.animalpenpaper.events.item.AnimalWithdrawEvent;
import lv.id.bonne.animalpenpaper.managers.AquariumManager;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.OwnableEntity;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WaterAnimalContainerListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onEntityCatch(PlayerInteractEntityEvent event) {
        long maxAmount;
        OwnableEntity ownableEntity;
        Ageable ageable;
        Player player = event.getPlayer();
        if (event.getPlayer().isSneaking()) {
            return;
        }
        Entity entity = event.getRightClicked();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AquariumManager.isWaterContainer(item)) {
            return;
        }
        event.setCancelled(true);
        if (!(entity instanceof WaterMob)) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.not_water_animal"));
            return;
        }
        WaterMob animal = (WaterMob)entity;
        if (animal.isDead() || !animal.hasAI()) {
            return;
        }
        if (animal instanceof Ageable && !(ageable = (Ageable)animal).isAdult()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.baby"));
            return;
        }
        if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).getOwner() != null) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.owned"));
            return;
        }
        if (animal.isLeashed()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.leashed"));
            return;
        }
        if (!animal.isEmpty()) {
            animal.eject();
        }
        EntityEquipment equipment = animal.getEquipment();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = equipment.getItem(slot);
            if (Math.random() <= (double)equipment.getDropChance(slot)) {
                entity.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
            }
            equipment.setDropChance(slot, 0.0f);
        }
        if (AnimalPenPlugin.configuration().isBlocked(animal.getType())) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.blocked"));
            return;
        }
        EntityType entityType = animal.getType();
        AnimalData storedData = AquariumManager.getAnimalData(item);
        if (storedData != null && storedData.entityType() != entityType) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.wrong"));
            return;
        }
        if (storedData == null) {
            storedData = new AnimalData(entityType, entity.createSnapshot(), 0L);
        }
        if ((maxAmount = AnimalPenPlugin.configuration().getMaximalAnimalCount()) > 0L && storedData.entityCount() + 1L > maxAmount) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.full"));
            return;
        }
        AnimalCatchEvent animalCatchEvent = new AnimalCatchEvent(player, entity, storedData, false);
        if (!animalCatchEvent.callEvent()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.unknown", Component.translatable((String)entity.getType().translationKey())));
            return;
        }
        AquariumManager.addAnimal(item, entityType, entity.createSnapshot(), 1L);
        entity.remove();
        player.swingMainHand();
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.captured", Component.translatable((String)entity.getType().translationKey())));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityRelease(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null) {
            return;
        }
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AquariumManager.isWaterContainer(item)) {
            return;
        }
        event.setCancelled(true);
        AnimalData storedData = AquariumManager.getAnimalData(item);
        if (storedData == null) {
            return;
        }
        EntityType entityType = storedData.entityType();
        Location spawnLoc = block.getLocation().add(0.5, 1.0, 0.5);
        World world = player.getWorld();
        AnimalReleaseEvent animalReleaseEvent = new AnimalReleaseEvent(player, spawnLoc, storedData, false);
        if (!animalReleaseEvent.callEvent()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.release"));
            return;
        }
        Entity entity = storedData.entitySnapshot() != null ? storedData.entitySnapshot().createEntity(spawnLoc) : world.spawnEntity(spawnLoc, entityType, CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (storedData.entitySnapshot() == null) {
            storedData.setEntitySnapshot(entity.createSnapshot());
        }
        if (!(entity instanceof WaterMob)) {
            return;
        }
        WaterMob mob = (WaterMob)entity;
        mob.getEquipment().clear();
        AquariumManager.removeAnimal(item, 1L);
        player.swingMainHand();
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.released", Component.translatable((String)entity.getType().translationKey())));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInteractWithPenWithAnimalCage(PlayerInteractEvent event) {
        if (event.getHand() == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AquariumManager.isWaterContainer(item)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!AquariumManager.isAquarium(block)) {
            return;
        }
        event.setCancelled(true);
        AnimalData penData = AquariumManager.getAnimalData(block);
        AnimalData itemData = AquariumManager.getAnimalData(item);
        if (itemData == null && penData == null) {
            return;
        }
        if (penData == null) {
            AnimalDepositEvent animalDepositEvent = new AnimalDepositEvent(player, block.getLocation(), itemData, null, false);
            if (!animalDepositEvent.callEvent()) {
                player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.deposit"));
                return;
            }
            AquariumManager.setAquariumData(block, itemData);
            item.setAmount(-1);
            player.getInventory().setItem(event.getHand(), item);
            player.swingMainHand();
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.inserted"));
            return;
        }
        if (itemData == null) {
            if (!player.isSneaking() || penData.entityCount() < 2L) {
                return;
            }
            itemData = new AnimalData(penData.entityType(), penData.entitySnapshot(), penData.entityCount() / 2L);
            itemData.getCooldowns().putAll(penData.getCooldowns());
            AnimalWithdrawEvent animalWithdrawEvent = new AnimalWithdrawEvent(player, block.getLocation(), itemData, penData, false);
            if (!animalWithdrawEvent.callEvent()) {
                event.getPlayer().sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.withdrawn"));
                return;
            }
            AquariumManager.setWaterContainerData(item, itemData);
            penData.reduceEntityCount(itemData.entityCount());
            AquariumManager.setAquariumData(block, penData);
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.withdrawn", itemData.entityCount()));
            return;
        }
        if (penData.entityType() != itemData.entityType()) {
            return;
        }
        AnimalDepositEvent animalDepositEvent = new AnimalDepositEvent(player, block.getLocation(), itemData, penData, false);
        if (!animalDepositEvent.callEvent()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.deposit"));
            return;
        }
        penData.addEntityCount(itemData.entityCount());
        itemData.getCooldowns().forEach((key, value) -> penData.getCooldowns().merge((Material)key, (Integer)value, Math::max));
        itemData.getCooldowns().clear();
        penData.setScutes(penData.scutes() + itemData.scutes());
        itemData.setScutes(0);
        int maxStoredVariants = AnimalPenPlugin.configuration().getMaxStoredVariants();
        long amount = itemData.entityCount();
        if (itemData.entityCount() > 1L && penData.getVariants().size() + itemData.getVariants().size() > maxStoredVariants) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.too_many_variants"));
            penData.reduceEntityCount(1L);
            itemData.setEntityCount(1L);
            AquariumManager.setWaterContainerData(item, itemData);
            --amount;
        } else {
            Iterator<EntitySnapshot> iterator = itemData.getVariants().iterator();
            for (int size = penData.getVariants().size(); size < maxStoredVariants && iterator.hasNext(); ++size) {
                penData.addVariant(iterator.next());
            }
            itemData.getVariants().clear();
            AquariumManager.setWaterContainerData(item, null);
        }
        AquariumManager.setAquariumData(block, penData);
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.deposited", amount));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteractWithPenWithEmptyHand(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getItem() != null && !event.getItem().getType().isAir() || event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!AquariumManager.isAquarium(block)) {
            return;
        }
        event.setCancelled(true);
        AnimalData penData = AquariumManager.getAnimalData(block);
        if (penData == null) {
            return;
        }
        AnimalWithdrawEvent animalWithdrawEvent = new AnimalWithdrawEvent(event.getPlayer(), block.getLocation(), null, penData, false);
        if (!animalWithdrawEvent.callEvent()) {
            event.getPlayer().sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.error.withdrawn"));
            return;
        }
        ItemStack itemStack = AquariumManager.createEmptyWaterContainer();
        AquariumManager.setWaterContainerData(itemStack, penData);
        AquariumManager.clearBlockData(block, true);
        event.getPlayer().getInventory().setItem(event.getHand() == null ? EquipmentSlot.HAND : event.getHand(), itemStack);
        event.getPlayer().sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.taken"));
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onProtectionOfUsage(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AquariumManager.isWaterContainer(item)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onProtectionOfUsage(PlayerInteractEvent event) {
        if (!AquariumManager.isWaterContainer(event.getItem())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        ItemStack result = event.getRecipe().getResult();
        if (!result.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
            return;
        }
        CustomModelData data = (CustomModelData)result.getData(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (data.strings().contains("animal_pen:water_animal_container")) {
            ItemMeta itemMeta = result.getItemMeta();
            itemMeta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.name").style(StyleUtil.WHITE));
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line3")));
            result.setItemMeta(itemMeta);
            event.setCurrentItem(result);
        }
    }
}

