/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.data.AnimalDataType;
import lv.id.bonne.animalpenpaper.data.BlockData;
import lv.id.bonne.animalpenpaper.data.BlockDataType;
import lv.id.bonne.animalpenpaper.events.block.AnimalBlockBreedEvent;
import lv.id.bonne.animalpenpaper.managers.Helper;
import lv.id.bonne.animalpenpaper.menu.AnimalPenVariantMenu;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import lv.id.bonne.animalpenpaper.util.Utils;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.world.entity.AgeableMob;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Frog;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenManager {
    public static final NamespacedKey ANIMAL_DATA_KEY = new NamespacedKey("animal_pen", "animal_pen_data");
    public static final String ANIMAL_CAGE_MODEL = "animal_pen:animal_cage";
    private static final String ANIMAL_CAGE_FILLED_MODEL = "animal_pen:animal_cage_filled";
    public static final String ANIMAL_PEN_MODEL = "animal_pen:animal_pen";

    public static boolean isAnimalCage(ItemStack item) {
        if (item == null || item.getType() != Material.GLASS_BOTTLE) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasCustomModelDataComponent()) {
            return false;
        }
        List dataComponents = meta.getCustomModelDataComponent().getStrings();
        return dataComponents.contains(ANIMAL_CAGE_MODEL) || dataComponents.contains(ANIMAL_CAGE_FILLED_MODEL);
    }

    public static AnimalData addAnimal(ItemStack handItem, @NotNull EntityType type, EntitySnapshot entitySnapshot, long amount) {
        ItemMeta itemMeta = handItem.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        AnimalData animalData = (AnimalData)dataContainer.getOrDefault(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)new AnimalData(type, entitySnapshot, 0L));
        animalData.addEntityCount(amount);
        if (animalData.getVariants().size() <= AnimalPenPlugin.configuration().getMaxStoredVariants()) {
            animalData.addVariant(entitySnapshot);
        }
        AnimalPenManager.updateAnimalCageItemMeta(animalData, itemMeta);
        handItem.setItemMeta(itemMeta);
        return animalData;
    }

    public static ItemStack removeAnimal(ItemStack item, long amount) {
        ItemMeta itemMeta = item.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        AnimalData animalData = (AnimalData)dataContainer.get(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
        if (animalData == null) {
            return item;
        }
        animalData.reduceEntityCount(amount);
        AnimalPenManager.updateAnimalCageItemMeta(animalData, itemMeta);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Nullable
    public static AnimalData getAnimalData(ItemStack item) {
        if (!AnimalPenManager.isAnimalCage(item)) {
            return null;
        }
        return (AnimalData)item.getItemMeta().getPersistentDataContainer().get(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void setAnimalCageData(ItemStack item, @Nullable AnimalData animalData) {
        ItemMeta itemMeta = item.getItemMeta();
        AnimalPenManager.updateAnimalCageItemMeta(animalData, itemMeta);
        item.setItemMeta(itemMeta);
    }

    public static ItemStack createEmptyAnimalCage() {
        ItemStack bottle = new ItemStack(Material.GLASS_BOTTLE);
        ItemMeta meta = bottle.getItemMeta();
        if (meta == null) {
            return bottle;
        }
        meta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.name").style(StyleUtil.WHITE));
        AnimalPenManager.updateAnimalCageItemMeta(null, meta);
        meta.setMaxStackSize(Integer.valueOf(1));
        bottle.setItemMeta(meta);
        return bottle;
    }

    private static void updateAnimalCageItemMeta(@Nullable AnimalData animalData, ItemMeta itemMeta) {
        if (animalData == null || animalData.entityCount() <= 0L) {
            itemMeta.getPersistentDataContainer().remove(ANIMAL_DATA_KEY);
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line3")));
            CustomModelDataComponent component = itemMeta.getCustomModelDataComponent();
            component.setStrings(List.of(ANIMAL_CAGE_MODEL));
            itemMeta.setCustomModelDataComponent(component);
        } else {
            itemMeta.getPersistentDataContainer().set(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)animalData);
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.description.top"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.description.entity", Component.translatable((String)animalData.entityType().translationKey()).style(StyleUtil.YELLOW)), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.description.amount", Component.text((long)animalData.entityCount()).style(StyleUtil.YELLOW)), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line3"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.release_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.release_tip.line2")));
            CustomModelDataComponent component = itemMeta.getCustomModelDataComponent();
            if (!component.getStrings().contains(ANIMAL_CAGE_FILLED_MODEL)) {
                component.setStrings(List.of(ANIMAL_CAGE_FILLED_MODEL, animalData.entityType().key().asString()));
                itemMeta.setCustomModelDataComponent(component);
            }
        }
    }

    public static boolean isAnimalPen(@NotNull ItemStack item) {
        if (item.getType() != Material.SMOOTH_STONE_SLAB) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasCustomModelDataComponent()) {
            return false;
        }
        return meta.getCustomModelDataComponent().getStrings().contains(ANIMAL_PEN_MODEL);
    }

    public static boolean isAnimalPen(@Nullable Block block) {
        if (block == null || block.getType() != Material.SMOOTH_STONE_SLAB) {
            return false;
        }
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        return block.getWorld().getPersistentDataContainer().has(penKey, (PersistentDataType)BlockDataType.INSTANCE);
    }

    public static boolean isAnimalPen(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void completePenCreation(Block block, BlockData blockData, @NotNull ItemStack itemInHand) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        Entity decorationEntity = block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.501, 0.5), EntityType.ITEM_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
            newEntity.setPersistent(true);
            newEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
            if (newEntity instanceof ItemDisplay) {
                ItemDisplay display = (ItemDisplay)newEntity;
                display.setVisibleByDefault(true);
                ItemStack itemStack = new ItemStack(itemInHand);
                itemStack.setAmount(1);
                display.setItemStack(itemStack);
                Transformation transform = display.getTransformation();
                transform.getScale().set(1.001f, 1.0f, 1.001f);
                display.setTransformation(transform);
            }
            newEntity.getPersistentDataContainer().set(Helper.DECORATION_ENTITY_KEY, PersistentDataType.STRING, (Object)penKey.getKey());
        });
        blockData.decorationEntity = decorationEntity.getUniqueId();
        Entity countEntity = block.getWorld().spawnEntity(block.getLocation().add(Utils.center(blockData.blockFace)), EntityType.TEXT_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
            newEntity.setPersistent(false);
            newEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
            if (newEntity instanceof TextDisplay) {
                TextDisplay display = (TextDisplay)newEntity;
                display.setVisibleByDefault(true);
                display.setSeeThrough(false);
                display.text((Component)Component.text((int)0));
            }
            newEntity.getPersistentDataContainer().set(Helper.COUNTER_ENTITY_KEY, PersistentDataType.STRING, (Object)penKey.getKey());
        });
        blockData.countEntity = countEntity.getUniqueId();
        block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
    }

    public static void validateAnimalPen(@NotNull Entity entity) {
        Block block = entity.getLocation().getBlock();
        if (block.getType() != Material.SMOOTH_STONE_SLAB) {
            return;
        }
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to load animal pen block. Restoring...");
            blockData = new BlockData();
        }
        if (blockData.entity == null) {
            blockData.entity = entity.getUniqueId();
            blockData.blockFace = entity.getFacing();
            Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getBoundingBox().expand(1.0), findEntity -> findEntity.getType() == EntityType.TEXT_DISPLAY && findEntity.getFacing() == entity.getFacing() && findEntity.getPersistentDataContainer().has(penKey));
            if (!nearbyEntities.isEmpty()) {
                blockData.countEntity = ((Entity)nearbyEntities.iterator().next()).getUniqueId();
            }
            if (!(nearbyEntities = block.getWorld().getNearbyEntities(block.getBoundingBox().expand(1.0), findEntity -> findEntity.getType() == EntityType.ITEM_DISPLAY && findEntity.getFacing() == entity.getFacing() && findEntity.getPersistentDataContainer().has(penKey))).isEmpty()) {
                blockData.decorationEntity = ((Entity)nearbyEntities.iterator().next()).getUniqueId();
            }
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeInstance attribute = livingEntity.getAttribute(Attribute.SCALE);
            if (attribute != null && livingEntity instanceof Animals) {
                AnimalData animalData;
                if (attribute.getBaseValue() != (double)AnimalPenPlugin.configuration().getAnimalSize()) {
                    attribute.setBaseValue((double)AnimalPenPlugin.configuration().getAnimalSize());
                }
                if (AnimalPenPlugin.configuration().isGrowAnimals() && (animalData = AnimalPenManager.getAnimalData(entity)) != null) {
                    AttributeModifier modifier = attribute.getModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                    float multiplier = AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)animalData.entityCount();
                    if (modifier != null && modifier.getAmount() != (double)multiplier) {
                        attribute.getModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                        attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)multiplier, AttributeModifier.Operation.ADD_NUMBER));
                    }
                }
            }
            livingEntity.setPose(livingEntity.getPose());
        }
    }

    public static AnimalData getAnimalData(Block block) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null || blockData.entity == null) {
            return null;
        }
        return AnimalPenManager.getAnimalData(block.getWorld().getEntity(blockData.entity));
    }

    public static AnimalData getAnimalData(Entity entity) {
        if (entity == null) {
            AnimalPenPlugin.getInstance().getLogger().severe("Animal Pen entity is removed! Cannot access data!");
            return null;
        }
        return (AnimalData)entity.getPersistentDataContainer().get(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void setAnimalPenData(Block block, AnimalData newData) {
        Entity entity;
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().getOrDefault(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)new BlockData());
        if (blockData.entity == null || block.getWorld().getEntity(blockData.entity) == null) {
            entity = newData.entitySnapshot() != null ? newData.entitySnapshot().createEntity(block.getLocation().add(0.5, 0.5, 0.5)) : block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.5, 0.5), newData.entityType(), CreatureSpawnEvent.SpawnReason.CUSTOM);
            if (entity instanceof Sheep) {
                Sheep sheep = (Sheep)entity;
                newData.getAppliedFlag().ifPresent(arg_0 -> ((Sheep)sheep).setSheared(arg_0));
                newData.getAppliedMaterial().ifPresent(dye -> sheep.setColor(Utils.getDyeColor(dye)));
            } else if (entity instanceof MushroomCow) {
                MushroomCow cow = (MushroomCow)entity;
                newData.getAppliedMaterial().ifPresent(dye -> {
                    SuspiciousEffectEntry suspiciousEffectEntry = Utils.FLOWER_EFFECTS.get(dye);
                    if (suspiciousEffectEntry != null) {
                        cow.addEffectToNextStew(suspiciousEffectEntry, true);
                    }
                });
            }
            entity.setGravity(false);
            entity.setNoPhysics(true);
            entity.setPersistent(true);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setCollidable(false);
                livingEntity.setAI(false);
                livingEntity.setRemoveWhenFarAway(false);
                livingEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
                AttributeInstance attribute = livingEntity.getAttribute(Attribute.SCALE);
                if (attribute != null) {
                    attribute.setBaseValue((double)AnimalPenPlugin.configuration().getAnimalSize());
                    if (AnimalPenPlugin.configuration().isGrowAnimals()) {
                        attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
                    }
                }
            }
            blockData.entity = entity.getUniqueId();
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        } else {
            LivingEntity livingEntity;
            AttributeInstance attribute;
            entity = block.getWorld().getEntity(blockData.entity);
            if (AnimalPenPlugin.configuration().isGrowAnimals() && entity instanceof LivingEntity && (attribute = (livingEntity = (LivingEntity)entity).getAttribute(Attribute.SCALE)) != null) {
                attribute.removeModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
            }
        }
        if (entity == null) {
            AnimalPenPlugin.getInstance().getLogger().severe("Animal Pen entity is removed! Cannot access data!");
            return;
        }
        AnimalPenPlugin.getInstance().task.startTrackingEntity(entity, false, true);
        entity.getPersistentDataContainer().set(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)newData);
        Helper.updateCountTextEntity(block, blockData, newData.entityCount(), penKey);
    }

    public static void setAnimalPenData(Entity entity, AnimalData newData) {
        if (newData.entityCount() <= 0L) {
            ItemStack itemStack = AnimalPenManager.createEmptyAnimalCage();
            entity.getWorld().dropItem(entity.getLocation(), itemStack);
            AnimalPenPlugin.getInstance().task.stopTrackingEntity(entity, true);
            entity.getPersistentDataContainer().remove(ANIMAL_DATA_KEY);
            entity.remove();
        } else {
            LivingEntity livingEntity;
            AttributeInstance attribute;
            entity.getPersistentDataContainer().set(ANIMAL_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)newData);
            if (AnimalPenPlugin.configuration().isGrowAnimals() && entity instanceof LivingEntity && (attribute = (livingEntity = (LivingEntity)entity).getAttribute(Attribute.SCALE)) != null) {
                attribute.removeModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
            }
        }
        Block block = entity.getLocation().getBlock();
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().getOrDefault(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)new BlockData());
        Helper.updateCountTextEntity(block, blockData, newData.entityCount(), penKey);
    }

    public static void clearBlockData(Block block, boolean keepBlock) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null) {
            return;
        }
        AnimalPenPlugin.getInstance().task.stopTrackingEntity(blockData.entity, block.getWorld(), true);
        Helper.removeEntity(block.getWorld(), blockData.entity);
        blockData.entity = null;
        if (keepBlock) {
            Helper.updateCountTextEntity(block, blockData, 0L, penKey);
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        } else {
            Helper.removeEntity(block.getWorld(), blockData.countEntity);
            Helper.removeEntity(block.getWorld(), blockData.decorationEntity);
            block.getWorld().getPersistentDataContainer().remove(penKey);
            block.getWorld().getNearbyEntitiesByType(Display.class, block.getLocation(), 1.0).forEach(display -> {
                if (display.getPersistentDataContainer().has(penKey, PersistentDataType.BOOLEAN)) {
                    display.remove();
                }
            });
        }
    }

    public static ItemStack getAnimalPenItem(Block block) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null || blockData.decorationEntity == null) {
            return AnimalPenManager.createAnimalPen();
        }
        Entity entity = block.getWorld().getEntity(blockData.decorationEntity);
        if (!(entity instanceof ItemDisplay)) {
            return AnimalPenManager.createAnimalPen();
        }
        ItemDisplay display = (ItemDisplay)entity;
        return display.getItemStack();
    }

    public static ItemStack createAnimalPen() {
        return AnimalPenManager.createAnimalPen("animal_pen_oak");
    }

    public static ItemStack createAnimalPen(String type) {
        ItemStack smoothStoneSlab = new ItemStack(Material.SMOOTH_STONE_SLAB);
        ItemMeta meta = smoothStoneSlab.getItemMeta();
        if (meta == null) {
            return smoothStoneSlab;
        }
        CustomModelDataComponent customData = meta.getCustomModelDataComponent();
        customData.setStrings(List.of(ANIMAL_PEN_MODEL, "animal_pen:" + type));
        meta.setCustomModelDataComponent(customData);
        meta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen." + type).style(StyleUtil.WHITE));
        meta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line3")));
        smoothStoneSlab.setItemMeta(meta);
        return smoothStoneSlab;
    }

    public static void handleFood(LivingEntity entity, Player player, ItemStack itemStack) {
        AnimalData data = AnimalPenManager.getAnimalData((Entity)entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.APPLE)) {
            return;
        }
        long maxCount = AnimalPenPlugin.configuration().getMaximalAnimalCount();
        if (maxCount > 0L && data.entityCount() >= maxCount) {
            return;
        }
        int stackSize = itemStack.getAmount();
        if (entity.getType() == EntityType.AXOLOTL && itemStack.getType() == Material.TROPICAL_FISH_BUCKET && itemStack.getMaxStackSize() == 1) {
            HashMap all = player.getInventory().all(Material.TROPICAL_FISH_BUCKET);
            stackSize = all.size();
        }
        if ((stackSize = (int)Math.min(data.entityCount(), (long)stackSize)) < 2) {
            return;
        }
        stackSize = (int)Math.min((maxCount - data.entityCount()) * 2L, (long)stackSize);
        Utils.triggerItemUse((Entity)entity, player, itemStack, stackSize % 2 == 1 ? stackSize - 1 : stackSize);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (entity.getType() == EntityType.AXOLOTL && itemStack.getType() == Material.TROPICAL_FISH_BUCKET && itemStack.getMaxStackSize() == 1) {
                int removedItems;
                int n = removedItems = stackSize % 2 == 1 ? stackSize - 1 : stackSize;
                while (removedItems-- > 0) {
                    int slot = player.getInventory().first(Material.TROPICAL_FISH_BUCKET);
                    if (slot == -1) continue;
                    player.getInventory().setItem(slot, null);
                }
            } else if (stackSize % 2 == 1) {
                itemStack.subtract(stackSize - 1);
            } else {
                itemStack.subtract(stackSize);
            }
        }
        int amount = stackSize / 2;
        AnimalBlockBreedEvent breedEvent = new AnimalBlockBreedEvent(player, entity.getLocation(), entity.getType(), data.entityCount(), amount, true);
        data.addEntityCount(amount);
        entity.getWorld().spawnParticle(Particle.HEART, entity.getLocation(), 5, 0.2, 0.2, 0.2, 0.05);
        entity.getWorld().playSound((Entity)entity, entity.getEatingSound(itemStack), new Random().nextFloat(0.8f, 1.2f), 1.0f);
        player.swingMainHand();
        data.setCooldown(Material.APPLE, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.APPLE, stackSize));
        if (entity.getType() == EntityType.TURTLE) {
            data.setScutes(amount);
            if (AnimalPenPlugin.configuration().isDropScuteAtStart()) {
                AnimalPenManager.handleScutes((Entity)entity, data);
            }
        }
        AnimalPenManager.setAnimalPenData((Entity)entity, data);
        if (!(entity instanceof Breedable)) {
            return;
        }
        entity.getWorld().spawnEntity(entity.getLocation().add(0.0, 0.5, 0.0), EntityType.EXPERIENCE_ORB, CreatureSpawnEvent.SpawnReason.CUSTOM, orb -> ((ExperienceOrb)orb).setExperience((int)Math.round((double)(amount * 4) + new Random().nextGaussian() * Math.sqrt(amount * 4))));
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            for (int i = 0; i < amount; ++i) {
                CriteriaTriggers.BRED_ANIMALS.trigger(((CraftPlayer)player).getHandle(), ((CraftAnimals)entity).getHandle(), ((CraftAnimals)entity).getHandle(), (AgeableMob)((CraftAnimals)entity).getHandle());
            }
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.ANIMALS_BRED, amount);
        }
        breedEvent.callEvent();
    }

    public static void handleBrush(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.ARMADILLO) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.BRUSH)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.damage(16, (LivingEntity)player);
        }
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), Material.ARMADILLO_SCUTE, 1);
        entity.getWorld().playSound(entity, Sound.ENTITY_ARMADILLO_BRUSH, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        player.swingMainHand();
        data.setCooldown(Material.BRUSH, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.BRUSH, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleWaterBucket(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.AXOLOTL) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.WATER_BUCKET)) {
            return;
        }
        if (!(entity instanceof Axolotl)) {
            return;
        }
        Axolotl axolotl = (Axolotl)entity;
        ItemStack newBucket = axolotl.getBaseBucketItem();
        newBucket.setData(DataComponentTypes.AXOLOTL_VARIANT, (Object)axolotl.getVariant());
        if (axolotl.customName() != null) {
            newBucket.setData(DataComponentTypes.CUSTOM_NAME, (Object)axolotl.customName());
        }
        Sound sound = Sound.ITEM_BUCKET_FILL_AXOLOTL;
        data.reduceEntityCount(1L);
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        player.getInventory().addItem(new ItemStack[]{newBucket});
        entity.getWorld().playSound(entity, sound, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        player.swingMainHand();
        data.setCooldown(Material.WATER_BUCKET, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.WATER_BUCKET, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            CriteriaTriggers.FILLED_BUCKET.trigger(((CraftPlayer)player).getHandle(), CraftItemStack.asNMSCopy((ItemStack)newBucket));
        }
    }

    public static void handleShears(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() == EntityType.SHEEP) {
            AnimalPenManager.handleShearsWool(entity, player, itemStack);
        } else if (entity.getType() == EntityType.BEE) {
            AnimalPenManager.handleShearsHoney(entity, player, itemStack);
        }
    }

    public static void handleShearsHoney(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.BEE) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.SHEARS) || data.hasCooldown(Material.GLASS_BOTTLE)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.damage(1, (LivingEntity)player);
        }
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), Material.HONEYCOMB, 3);
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.BLOCK_BEEHIVE_SHEAR, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.SHEARS, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.SHEARS, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleShearsWool(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.SHEEP) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.SHEARS)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.damage(1, (LivingEntity)player);
        }
        Sheep sheep = (Sheep)entity;
        sheep.shear();
        Material woolMaterial = Utils.getWoolMaterial(sheep.getColor());
        int woolCount = 1;
        int dropLimits = AnimalPenPlugin.configuration().getDropLimits(Material.WHITE_WOOL);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        Random random = new Random();
        int i = 0;
        while ((long)i < data.entityCount() && woolCount < dropLimits) {
            woolCount += random.nextInt(3);
            ++i;
        }
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), woolMaterial, woolCount);
        player.swingMainHand();
        data.setCooldown(Material.SHEARS, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.SHEARS, data.entityCount()));
        data.setAppliedFlag(true);
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleBucket(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() == EntityType.CHICKEN || entity.getType() == EntityType.SNIFFER || entity.getType() == EntityType.TURTLE) {
            AnimalPenManager.handleBucketEggs(entity, player, itemStack);
        } else if (entity.getType() == EntityType.COW || entity.getType() == EntityType.MOOSHROOM || entity.getType() == EntityType.GOAT) {
            AnimalPenManager.handleBucketMilk(entity, player, itemStack);
        }
    }

    public static void handleBucketMilk(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.COW && entity.getType() != EntityType.MOOSHROOM && entity.getType() != EntityType.GOAT) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.BUCKET)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MILK_BUCKET)});
        player.swingMainHand();
        entity.getWorld().playSound(entity, entity.getType() == EntityType.GOAT ? Sound.ENTITY_GOAT_MILK : Sound.ENTITY_COW_MILK, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.BUCKET, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.BUCKET, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleGlassBottle(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.BEE) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.SHEARS) || data.hasCooldown(Material.GLASS_BOTTLE)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.HONEY_BOTTLE)});
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.BLOCK_BEEHIVE_DRIP, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.GLASS_BOTTLE, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.GLASS_BOTTLE, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleBucketEggs(Entity entity, Player player, ItemStack itemStack) {
        Sound sound;
        Material material;
        if (entity.getType() != EntityType.CHICKEN && entity.getType() != EntityType.SNIFFER && entity.getType() != EntityType.TURTLE) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.BUCKET)) {
            return;
        }
        switch (entity.getType()) {
            case CHICKEN: {
                Chicken.Variant variant = ((Chicken)entity).getVariant();
                material = variant == Chicken.Variant.WARM ? Material.BROWN_EGG : (variant == Chicken.Variant.COLD ? Material.BLUE_EGG : Material.EGG);
                sound = Sound.ENTITY_CHICKEN_EGG;
                break;
            }
            case SNIFFER: {
                material = Material.SNIFFER_EGG;
                sound = Sound.BLOCK_SNIFFER_EGG_PLOP;
                break;
            }
            case TURTLE: {
                material = Material.TURTLE_EGG;
                sound = Sound.ENTITY_TURTLE_LAY_EGG;
                break;
            }
            default: {
                return;
            }
        }
        int dropLimits = AnimalPenPlugin.configuration().getDropLimits(material);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        int itemCount = (int)Math.min(data.entityCount(), (long)dropLimits);
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), material, itemCount);
        player.swingMainHand();
        entity.getWorld().playSound(entity, sound, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.BUCKET, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.BUCKET, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleDyes(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.SHEEP) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.WHITE_DYE)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        data.setAppliedMaterial(itemStack.getType());
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        Sheep sheep = (Sheep)entity;
        sheep.setColor(Utils.getDyeColor(itemStack.getType()));
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.ITEM_DYE_USE, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.WHITE_DYE, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.WHITE_DYE, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleMagmaBlock(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.FROG) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.MAGMA_BLOCK)) {
            return;
        }
        int froglightCount = (int)Math.min(data.entityCount(), (long)itemStack.getAmount());
        int dropLimits = AnimalPenPlugin.configuration().getDropLimits(Material.PEARLESCENT_FROGLIGHT);
        if (dropLimits > 0) {
            froglightCount = Math.min(froglightCount, dropLimits);
        }
        Frog frog = (Frog)entity;
        Material material = Utils.getFrogLight(frog);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract(froglightCount);
        }
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), material, froglightCount);
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.ENTITY_FROG_TONGUE, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.MAGMA_BLOCK, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.MAGMA_BLOCK, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleBowl(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() == EntityType.MOOSHROOM) {
            AnimalPenManager.handleBowlSoup(entity, player, itemStack);
        } else if (entity.getType() == EntityType.SNIFFER) {
            AnimalPenManager.handleBowlSeeds(entity, player, itemStack);
        }
    }

    public static void handleBowlSoup(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.MOOSHROOM) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.BOWL)) {
            return;
        }
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        MushroomCow mushroomCow = (MushroomCow)entity;
        List effectsForNextStew = mushroomCow.getStewEffects();
        ItemStack stewItem = new ItemStack(Material.MUSHROOM_STEW);
        if (!effectsForNextStew.isEmpty()) {
            SuspiciousStewMeta itemMeta = (SuspiciousStewMeta)stewItem.getItemMeta();
            effectsForNextStew.forEach(effect -> itemMeta.addCustomEffect(effect, false));
            stewItem.setItemMeta((ItemMeta)itemMeta);
        }
        player.getInventory().addItem(new ItemStack[]{stewItem});
        player.swingMainHand();
        entity.getWorld().playSound(entity, effectsForNextStew.isEmpty() ? Sound.ENTITY_MOOSHROOM_MILK : Sound.ENTITY_MOOSHROOM_SUSPICIOUS_MILK, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.BOWL, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.BOWL, data.entityCount()));
        data.setAppliedMaterial(null);
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleBowlSeeds(Entity entity, Player player, ItemStack itemStack) {
        Collection randomItems;
        if (entity.getType() != EntityType.SNIFFER) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.BOWL)) {
            return;
        }
        LootTable lootTable = LootTables.SNIFFER_DIGGING.getLootTable();
        LootContext lootParams = new LootContext.Builder(entity.getLocation()).lootedEntity(entity).build();
        int dropLimits = AnimalPenPlugin.configuration().getDropLimits(Material.TORCHFLOWER_SEEDS);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        ArrayList itemStackList = new ArrayList();
        Random random = new Random();
        for (int seedCount = (int)Math.min(data.entityCount(), (long)dropLimits); seedCount > 0 && !(randomItems = lootTable.populateLoot(random, lootParams)).isEmpty(); seedCount -= randomItems.stream().mapToInt(ItemStack::getAmount).sum()) {
            randomItems.forEach(item -> {
                boolean added = false;
                for (ItemStack stack : itemStackList) {
                    if (!item.isSimilar(stack) || stack.getAmount() >= stack.getMaxStackSize()) continue;
                    stack.add(item.getAmount());
                    added = true;
                    break;
                }
                if (!added) {
                    itemStackList.add(item);
                }
            });
        }
        itemStackList.forEach(seedStack -> entity.getWorld().dropItem(entity.getLocation().add(0.0, 1.0, 0.0), seedStack));
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.ENTITY_SNIFFER_DROP_SEED, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        data.setCooldown(Material.BOWL, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.BOWL, data.entityCount()));
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleSmallFlowers(Entity entity, Player player, ItemStack itemStack) {
        if (entity.getType() != EntityType.MOOSHROOM) {
            return;
        }
        AnimalData data = AnimalPenManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        MushroomCow mushroomCow = (MushroomCow)entity;
        if (mushroomCow.getVariant() != MushroomCow.Variant.BROWN) {
            return;
        }
        if (mushroomCow.hasEffectsForNextStew()) {
            return;
        }
        SuspiciousEffectEntry suspiciousEffectEntry = Utils.FLOWER_EFFECTS.get(itemStack.getType());
        if (suspiciousEffectEntry == null) {
            return;
        }
        mushroomCow.addEffectToNextStew(suspiciousEffectEntry, false);
        Utils.triggerItemUse(entity, player, itemStack, 1);
        data.setAppliedMaterial(itemStack.getType());
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        player.swingMainHand();
        entity.getWorld().playSound(entity, Sound.ENTITY_MOOSHROOM_EAT, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        AnimalPenManager.setAnimalPenData(entity, data);
    }

    public static void handleScutes(Entity entity, AnimalData animalData) {
        if (animalData.scutes() == 0) {
            return;
        }
        int scutes = animalData.scutes();
        animalData.setScutes(0);
        Utils.dropItems(entity.getWorld(), entity.getLocation().add(0.0, 1.0, 0.0), Material.TURTLE_SCUTE, scutes);
    }

    public static void handleKilling(LivingEntity entity, Player player, ItemStack itemStack) {
        Sound deathSound;
        int cooldown;
        AnimalData data = AnimalPenManager.getAnimalData((Entity)entity);
        if (data == null) {
            return;
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.USE_ITEM, itemStack.getType());
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.damage(1, (LivingEntity)player);
        }
        if ((cooldown = AnimalPenPlugin.configuration().getAttackCooldown()) > 0) {
            player.setCooldown(itemStack, cooldown);
        }
        data.reduceEntityCount(1L);
        AnimalPenManager.setAnimalPenData((Entity)entity, data);
        LootTable lootTable = Bukkit.getLootTable((NamespacedKey)NamespacedKey.minecraft((String)("entities/" + entity.getType().getKey().value())));
        if (lootTable != null) {
            if (player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.FIRE_ASPECT)) {
                entity.setFireTicks(1);
                entity.setVisualFire(TriState.FALSE);
            }
            Collection itemStacks = lootTable.populateLoot(new Random(), new LootContext.Builder(entity.getLocation()).killer((HumanEntity)player).lootedEntity((Entity)entity).build());
            Location location = entity.getLocation().add(0.0, 1.0, 0.0);
            itemStacks.forEach(item -> entity.getWorld().dropItemNaturally(location, item));
            int reward = ((Mob)entity).getPossibleExperienceReward();
            entity.getWorld().spawnEntity(location, EntityType.EXPERIENCE_ORB, CreatureSpawnEvent.SpawnReason.CUSTOM, orb -> ((ExperienceOrb)orb).setExperience(reward));
        }
        if ((deathSound = entity.getDeathSound()) != null) {
            entity.getWorld().playSound(entity.getLocation(), deathSound, new Random().nextFloat(0.5f, 1.0f), 1.0f);
        } else {
            entity.getWorld().playSound(entity.getLocation(), Sound.ENTITY_GENERIC_DEATH, new Random().nextFloat(0.5f, 1.0f), 1.0f);
        }
        entity.getWorld().spawnParticle(Particle.SMOKE, entity.getLocation().add(0.0, 0.5, 0.0), 10, 0.3, 0.3, 0.3, 0.01);
        entity.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, entity.getLocation().add(0.0, 0.5, 0.0), 2, 0.2, 0.2, 0.2, 0.0);
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(((CraftPlayer)player).getHandle(), ((CraftEntity)entity).getHandle(), ((CraftDamageSource)DamageSource.builder((DamageType)DamageType.PLAYER_ATTACK).build()).getHandle());
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.MOB_KILLS);
            player.incrementStatistic(Statistic.KILL_ENTITY, entity.getType());
        }
    }

    public static void processCooldownFinish(Entity entity, Material key, AnimalData animalData) {
        if (entity.getType() == EntityType.TURTLE && key == Material.APPLE && !AnimalPenPlugin.configuration().isDropScuteAtStart()) {
            AnimalPenManager.handleScutes(entity, animalData);
        } else if (entity.getType() == EntityType.SHEEP && key == Material.SHEARS) {
            ((Sheep)entity).setSheared(false);
            animalData.setAppliedFlag(false);
        }
    }

    public static void applyVariant(Entity entity, EntitySnapshot selectedVariant) {
        if (selectedVariant == null) {
            return;
        }
        Block block = entity.getLocation().add(0.0, -0.5, 0.0).getBlock();
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_animal_pen");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null) {
            return;
        }
        AnimalData animalData = AnimalPenManager.getAnimalData(entity);
        if (animalData == null) {
            return;
        }
        animalData.setAppliedMaterial(null);
        animalData.setAppliedFlag(null);
        animalData.setEntitySnapshot(selectedVariant);
        blockData.entity = null;
        block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        AnimalPenPlugin.getInstance().task.stopTrackingEntity(entity, false);
        entity.getPersistentDataContainer().remove(ANIMAL_DATA_KEY);
        AnimalPenVariantMenu.close(entity);
        entity.remove();
        AnimalPenManager.setAnimalPenData(block, animalData);
    }
}

