/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TranslationManager {
    private FileConfiguration messagesConfig;

    public TranslationManager() {
        this.loadMessages(false);
        this.updateConfig();
    }

    private void loadMessages(boolean reset) {
        File messagesFile = new File(AnimalPenPlugin.getInstance().getDataFolder(), "messages.yml");
        if (!messagesFile.exists() || reset) {
            AnimalPenPlugin.getInstance().saveResource("messages.yml", reset);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        AnimalPenPlugin.getInstance().getLogger().info("Loaded translation fallbacks from messages.yml");
    }

    public void reload() {
        this.loadMessages(false);
    }

    public void reset() {
        this.loadMessages(true);
    }

    public Component getTranslatable(String key) {
        String fallback = this.messagesConfig.getString(key);
        if (fallback == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("No fallback found for translation key: " + key);
            fallback = key;
        }
        return Component.translatable((String)key).fallback(fallback);
    }

    public Component getTranslatable(String key, Object ... args) {
        String fallback = this.messagesConfig.getString(key);
        if (fallback == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("No fallback found for translation key: " + key);
            fallback = key;
        }
        Component[] componentArgs = new Component[args.length];
        for (int i = 0; i < args.length; ++i) {
            componentArgs[i] = args[i] instanceof Component ? (Component)args[i] : Component.text((String)String.valueOf(args[i]));
        }
        return Component.translatable((String)key, (ComponentLike[])componentArgs).fallback(fallback);
    }

    public void updateConfig() {
        try {
            File configFile = new File(AnimalPenPlugin.getInstance().getDataFolder(), "messages.yml");
            YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)configFile);
            try (InputStream jarConfigStream = AnimalPenPlugin.getInstance().getResource("messages.yml");){
                if (jarConfigStream == null) {
                    AnimalPenPlugin.getInstance().getLogger().warning("Default config not found in jar!");
                    return;
                }
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(jarConfigStream, StandardCharsets.UTF_8));
                boolean updated = false;
                for (String key : defaultConfig.getKeys(true)) {
                    if (currentConfig.contains(key)) continue;
                    Object defaultValue = defaultConfig.get(key);
                    currentConfig.set(key, defaultValue);
                    updated = true;
                    AnimalPenPlugin.getInstance().getLogger().info("Added missing message key '" + key + "' with default value");
                }
                if (updated) {
                    currentConfig.save(configFile);
                    this.messagesConfig = currentConfig;
                    AnimalPenPlugin.getInstance().getLogger().info("Messages configuration updated successfully");
                } else {
                    AnimalPenPlugin.getInstance().getLogger().info("Messages configuration is up to date");
                }
            }
        }
        catch (Exception e) {
            AnimalPenPlugin.getInstance().getLogger().severe("Failed to update messages configuration: " + e.getMessage());
            AnimalPenPlugin.getInstance().getLogger().throwing(this.getClass().getName(), "updateConfig", e);
        }
    }
}

