/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.util;

import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.text.DecimalFormat;
import java.util.Map;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import net.minecraft.advancements.CriteriaTriggers;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Utils {
    public static final NamespacedKey ANIMAL_SIZE_MODIFIER = new NamespacedKey("animal_pen_plugin", "animal_size");
    public static final Map<Material, SuspiciousEffectEntry> FLOWER_EFFECTS = Map.ofEntries(Map.entry(Material.ALLIUM, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.FIRE_RESISTANCE, (int)80)), Map.entry(Material.AZURE_BLUET, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.BLINDNESS, (int)160)), Map.entry(Material.BLUE_ORCHID, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.SATURATION, (int)7)), Map.entry(Material.DANDELION, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.SATURATION, (int)7)), Map.entry(Material.CORNFLOWER, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.JUMP_BOOST, (int)120)), Map.entry(Material.LILY_OF_THE_VALLEY, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.POISON, (int)240)), Map.entry(Material.OXEYE_DAISY, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.REGENERATION, (int)160)), Map.entry(Material.POPPY, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.NIGHT_VISION, (int)100)), Map.entry(Material.TORCHFLOWER, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.NIGHT_VISION, (int)100)), Map.entry(Material.RED_TULIP, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.WEAKNESS, (int)180)), Map.entry(Material.ORANGE_TULIP, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.WEAKNESS, (int)180)), Map.entry(Material.PINK_TULIP, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.WEAKNESS, (int)180)), Map.entry(Material.WHITE_TULIP, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.WEAKNESS, (int)180)), Map.entry(Material.WITHER_ROSE, SuspiciousEffectEntry.create((PotionEffectType)PotionEffectType.WITHER, (int)160)));
    private static final Vector NORTH_CENTER = new Vector(0.502, 0.125, 0.0);
    private static final Vector SOUTH_CENTER = new Vector(0.502, 0.125, 1.0);
    private static final Vector EAST_CENTER = new Vector(1.0, 0.125, 0.5025);
    private static final Vector WEST_CENTER = new Vector(0.0, 0.125, 0.502);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public static void dropItems(World world, Location location, Material material, int amount) {
        while (amount > 0) {
            ItemStack dropItem = new ItemStack(material);
            if (amount > dropItem.getMaxStackSize()) {
                dropItem.setAmount(dropItem.getMaxStackSize());
                amount -= dropItem.getMaxStackSize();
            } else {
                dropItem.setAmount(amount);
                amount = 0;
            }
            world.dropItemNaturally(location, dropItem);
        }
    }

    public static void triggerItemUse(Entity entity, Player player, ItemStack itemStack, int amount) {
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(((CraftPlayer)player).getHandle(), ((CraftItemStack)itemStack).handle, ((CraftEntity)entity).getHandle());
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.USE_ITEM, itemStack.getType(), amount);
        }
    }

    public static Tag<Material> getTag(NamespacedKey tagKey) {
        return Bukkit.getTag((String)"items", (NamespacedKey)tagKey, Material.class);
    }

    public static Material getWoolMaterial(DyeColor color) {
        try {
            String woolName = color.name() + "_WOOL";
            return Material.valueOf((String)woolName);
        }
        catch (Exception e) {
            return Material.WHITE_WOOL;
        }
    }

    public static Material getFrogLight(Frog frog) {
        if (frog.getVariant() == Frog.Variant.WARM) {
            return Material.PEARLESCENT_FROGLIGHT;
        }
        if (frog.getVariant() == Frog.Variant.COLD) {
            return Material.VERDANT_FROGLIGHT;
        }
        if (frog.getVariant() == Frog.Variant.TEMPERATE) {
            return Material.OCHRE_FROGLIGHT;
        }
        return Material.PEARLESCENT_FROGLIGHT;
    }

    public static DyeColor getDyeColor(Material material) {
        try {
            String color = material.name().replace("_DYE", "");
            return DyeColor.valueOf((String)color);
        }
        catch (Exception e) {
            return DyeColor.WHITE;
        }
    }

    public static String getAxolotlType(int val) {
        if (val >= 0 && val < Axolotl.Variant.values().length) {
            return Axolotl.Variant.values()[val].name();
        }
        return "unknown";
    }

    public static String getHorseColor(int val) {
        if (val >= 0 && val < Horse.Color.values().length) {
            return Horse.Color.values()[val].name();
        }
        return "unknown";
    }

    public static String getHorseMarkings(int val) {
        if (val >= 0 && val < Horse.Style.values().length) {
            return Horse.Style.values()[val].name();
        }
        return "unknown";
    }

    public static String getLlamaVariant(int val) {
        if (val >= 0 && val < Llama.Color.values().length) {
            return Llama.Color.values()[val].name();
        }
        return "unknown";
    }

    public static String getParrotVariant(int val) {
        if (val >= 0 && val < Parrot.Variant.values().length) {
            return Parrot.Variant.values()[val].name();
        }
        return "unknown";
    }

    public static String getPufferState(int val) {
        return switch (val) {
            case 0 -> "deflated";
            case 1 -> "halfway puffed-up";
            case 2 -> "fully puffed-up";
            default -> "unknown";
        };
    }

    public static String getRabbitVariant(int val) {
        if (val >= 0 && val < Rabbit.Type.values().length) {
            return Rabbit.Type.values()[val].name();
        }
        return "unknown";
    }

    public static String getDyeColor(byte val) {
        DyeColor dyeColor = DyeColor.getByWoolData((byte)val);
        return dyeColor == null ? "unknown" : dyeColor.name();
    }

    public static String getPattern(int pattern) {
        if (pattern >= 0 && pattern < TropicalFish.Pattern.values().length) {
            return TropicalFish.Pattern.values()[pattern].name();
        }
        return "unknown";
    }

    public static String sanitizeValue(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    public static double getSpeed(double speed) {
        return speed * 42.157788;
    }

    public static double getJumpHeight(double jumpStrength) {
        return -0.1817584952 * Math.pow(jumpStrength, 3.0) + 3.689713992 * Math.pow(jumpStrength, 2.0) + 2.128599134 * jumpStrength - 0.343930367;
    }

    public static float blockFaceToYaw(BlockFace blockFace) {
        return switch (blockFace) {
            case BlockFace.NORTH -> 180.0f;
            case BlockFace.SOUTH -> 0.0f;
            case BlockFace.EAST -> 270.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 180.0f;
        };
    }

    public static Vector center(BlockFace blockFace) {
        return switch (blockFace) {
            case BlockFace.NORTH -> NORTH_CENTER;
            case BlockFace.SOUTH -> SOUTH_CENTER;
            case BlockFace.EAST -> EAST_CENTER;
            case BlockFace.WEST -> WEST_CENTER;
            default -> NORTH_CENTER;
        };
    }
}

