/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.listeners;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.event.entity.EntityZapEvent;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.List;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.managers.AnimalPenManager;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import lv.id.bonne.animalpenpaper.util.Utils;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AnimalPenListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenPlace(BlockPlaceEvent event) {
        BlockFace blockFace;
        if (!AnimalPenManager.isAnimalPen(event.getItemInHand())) {
            return;
        }
        if (event.getBlockReplacedState().getType() == Material.SMOOTH_STONE_SLAB) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        BlockData blockData = event.getBlock().getBlockData();
        if (blockData instanceof Slab) {
            Slab slab = (Slab)blockData;
            slab.setType(Slab.Type.BOTTOM);
            slab.setWaterlogged(false);
            block.setBlockData((BlockData)slab);
        }
        if ((blockFace = event.getBlockAgainst().getFace(event.getBlock())) == BlockFace.UP || blockFace == BlockFace.DOWN) {
            blockFace = event.getPlayer().getFacing().getOppositeFace();
        }
        lv.id.bonne.animalpenpaper.data.BlockData data = new lv.id.bonne.animalpenpaper.data.BlockData();
        data.blockFace = blockFace;
        AnimalPenManager.completePenCreation(block, data, event.getItemInHand());
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnimalPenBreak(BlockBreakEvent event) {
        if (!AnimalPenManager.isAnimalPen(event.getBlock())) {
            return;
        }
        Block block = event.getBlock();
        AnimalData animalData = AnimalPenManager.getAnimalData(block);
        if (animalData != null) {
            ItemStack itemStack = AnimalPenManager.createEmptyAnimalCage();
            AnimalPenManager.setAnimalCageData(itemStack, animalData);
            block.getWorld().dropItem(block.getLocation(), itemStack);
        }
        ItemStack animalPenItem = AnimalPenManager.getAnimalPenItem(block);
        AnimalPenManager.clearBlockData(block, false);
        event.setDropItems(false);
        block.getWorld().dropItem(block.getLocation(), animalPenItem);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        Entity eventEntity = event.getRightClicked();
        if (!AnimalPenManager.isAnimalPen(eventEntity) || !(eventEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)eventEntity;
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getItem(event.getHand());
        if (AnimalPenManager.isAnimalCage(itemStack)) {
            return;
        }
        AnimalPenPlugin.getInstance().task.startTrackingEntity((Entity)entity, false, true);
        event.setCancelled(true);
        if (itemStack.isEmpty()) {
            return;
        }
        if (AnimalPenPlugin.animalFoodConfiguration().isFoodItem((Entity)entity, itemStack)) {
            AnimalPenManager.handleFood(entity, player, itemStack);
        } else if (itemStack.getType() == Material.BRUSH) {
            AnimalPenManager.handleBrush((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.WATER_BUCKET) {
            AnimalPenManager.handleWaterBucket((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.SHEARS) {
            AnimalPenManager.handleShears((Entity)entity, player, itemStack);
        } else if (MaterialTags.DYES.isTagged(itemStack)) {
            AnimalPenManager.handleDyes((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.BUCKET) {
            AnimalPenManager.handleBucket((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.GLASS_BOTTLE) {
            AnimalPenManager.handleGlassBottle((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.MAGMA_BLOCK) {
            AnimalPenManager.handleMagmaBlock((Entity)entity, player, itemStack);
        } else if (itemStack.getType() == Material.BOWL) {
            AnimalPenManager.handleBowl((Entity)entity, player, itemStack);
        } else if (Utils.getTag(NamespacedKey.minecraft((String)"small_flowers")).isTagged((Keyed)itemStack.getType())) {
            AnimalPenManager.handleSmallFlowers((Entity)entity, player, itemStack);
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void onEntityLootDropping(EntityDamageEvent event) {
        Entity eventEntity = event.getEntity();
        if (!AnimalPenManager.isAnimalPen(eventEntity) || !(eventEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)eventEntity;
        event.setCancelled(true);
        Entity directEntity = event.getDamageSource().getDirectEntity();
        if (directEntity == null || directEntity.getType() != EntityType.PLAYER) {
            return;
        }
        if (event.getDamageSource().getDamageType() != DamageType.PLAYER_ATTACK) {
            return;
        }
        Player player = (Player)directEntity;
        ItemStack attackItem = player.getInventory().getItemInMainHand();
        if (player.hasCooldown(attackItem)) {
            return;
        }
        if (!Utils.getTag(NamespacedKey.minecraft((String)"swords")).isTagged((Keyed)attackItem.getType()) && !Utils.getTag(NamespacedKey.minecraft((String)"axes")).isTagged((Keyed)attackItem.getType())) {
            return;
        }
        AnimalPenManager.handleKilling(entity, player, attackItem);
    }

    @EventHandler
    public void onAnimalPenExplode(BlockExplodeEvent event) {
        boolean hasAnimalPen = event.blockList().stream().anyMatch(AnimalPenManager::isAnimalPen);
        if (!hasAnimalPen) {
            return;
        }
        event.blockList().removeIf(AnimalPenManager::isAnimalPen);
    }

    @EventHandler
    public void onAnimalPenExplode(EntityExplodeEvent event) {
        boolean hasAnimalPen = event.blockList().stream().anyMatch(AnimalPenManager::isAnimalPen);
        if (!hasAnimalPen) {
            return;
        }
        event.blockList().removeIf(AnimalPenManager::isAnimalPen);
    }

    @EventHandler
    public void onAnimalPenPush(BlockPistonExtendEvent event) {
        boolean hasAnimalPen = event.getBlocks().stream().anyMatch(AnimalPenManager::isAnimalPen);
        if (!hasAnimalPen) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onAnimalPenPush(BlockPistonRetractEvent event) {
        boolean hasAnimalPen = event.getBlocks().stream().anyMatch(AnimalPenManager::isAnimalPen);
        if (!hasAnimalPen) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onAnimalPenPlaceBlock(BlockCanBuildEvent event) {
        if (!AnimalPenManager.isAnimalPen(event.getBlock())) {
            return;
        }
        event.setBuildable(false);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!AnimalPenManager.isAnimalPen(entity)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityRemoveEvent(EntityDeathEvent event) {
        if (AnimalPenManager.isAnimalPen((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityZapEvent(EntityZapEvent event) {
        if (AnimalPenManager.isAnimalPen(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTransformEvent(EntityTransformEvent event) {
        if (AnimalPenManager.isAnimalPen(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWaterPlace(PlayerBucketEmptyEvent event) {
        if (AnimalPenManager.isAnimalPen(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWaterSpread(BlockFromToEvent event) {
        if (AnimalPenManager.isAnimalPen(event.getToBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        if (event.getTarget() != null && AnimalPenManager.isAnimalPen((Entity)event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        ItemStack result = event.getRecipe().getResult();
        if (!result.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
            return;
        }
        CustomModelData data = (CustomModelData)result.getData(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (data.strings().contains("animal_pen:animal_pen")) {
            ItemMeta itemMeta = result.getItemMeta();
            if (data.strings().size() >= 2 && ((String)data.strings().get(1)).startsWith("animal_pen:")) {
                itemMeta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen." + ((String)data.strings().get(1)).split(":")[1]).style(StyleUtil.WHITE));
            } else {
                itemMeta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen_oak").style(StyleUtil.WHITE));
            }
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_pen.tip.line3")));
            result.setItemMeta(itemMeta);
            event.setCurrentItem(result);
        }
    }
}

