/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.data.AnimalDataType;
import lv.id.bonne.animalpenpaper.data.BlockData;
import lv.id.bonne.animalpenpaper.data.BlockDataType;
import lv.id.bonne.animalpenpaper.managers.Helper;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import lv.id.bonne.animalpenpaper.util.Utils;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriteriaTriggers;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquariumManager {
    public static final NamespacedKey AQUARIUM_DATA_KEY = new NamespacedKey("animal_pen", "aquarium_data");
    public static final String WATER_CONTAINER_MODEL = "animal_pen:water_animal_container";
    private static final String WATER_CONTAINER_FILLED_MODEL = "animal_pen:water_animal_container_filled";
    public static final String AQUARIUM_MODEL = "animal_pen:aquarium";

    public static boolean isWaterContainer(ItemStack item) {
        if (item == null || item.getType() != Material.GLASS_BOTTLE) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasCustomModelDataComponent()) {
            return false;
        }
        List dataComponents = meta.getCustomModelDataComponent().getStrings();
        return dataComponents.contains(WATER_CONTAINER_MODEL) || dataComponents.contains(WATER_CONTAINER_FILLED_MODEL);
    }

    public static AnimalData addAnimal(ItemStack handItem, @NotNull EntityType type, EntitySnapshot entitySnapshot, long amount) {
        ItemMeta itemMeta = handItem.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        AnimalData animalData = (AnimalData)dataContainer.getOrDefault(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)new AnimalData(type, entitySnapshot, 0L));
        animalData.addEntityCount(amount);
        if (animalData.getVariants().size() <= AnimalPenPlugin.configuration().getMaxStoredVariants()) {
            animalData.addVariant(entitySnapshot);
        }
        AquariumManager.updateWaterContainerItemMeta(animalData, itemMeta);
        handItem.setItemMeta(itemMeta);
        return animalData;
    }

    public static ItemStack removeAnimal(ItemStack item, long amount) {
        ItemMeta itemMeta = item.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        AnimalData animalData = (AnimalData)dataContainer.get(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
        if (animalData == null) {
            return item;
        }
        animalData.reduceEntityCount(amount);
        AquariumManager.updateWaterContainerItemMeta(animalData, itemMeta);
        item.setItemMeta(itemMeta);
        return item;
    }

    @Nullable
    public static AnimalData getAnimalData(ItemStack item) {
        if (!AquariumManager.isWaterContainer(item)) {
            return null;
        }
        return (AnimalData)item.getItemMeta().getPersistentDataContainer().get(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void setWaterContainerData(ItemStack item, @Nullable AnimalData animalData) {
        ItemMeta itemMeta = item.getItemMeta();
        AquariumManager.updateWaterContainerItemMeta(animalData, itemMeta);
        item.setItemMeta(itemMeta);
    }

    public static ItemStack createEmptyWaterContainer() {
        ItemStack bottle = new ItemStack(Material.GLASS_BOTTLE);
        ItemMeta meta = bottle.getItemMeta();
        if (meta == null) {
            return bottle;
        }
        meta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.name").style(StyleUtil.WHITE));
        AquariumManager.updateWaterContainerItemMeta(null, meta);
        meta.setMaxStackSize(Integer.valueOf(1));
        bottle.setItemMeta(meta);
        return bottle;
    }

    private static void updateWaterContainerItemMeta(@Nullable AnimalData animalData, ItemMeta itemMeta) {
        if (animalData == null || animalData.entityCount() <= 0L) {
            itemMeta.getPersistentDataContainer().remove(AQUARIUM_DATA_KEY);
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line3")));
            CustomModelDataComponent component = itemMeta.getCustomModelDataComponent();
            component.setStrings(List.of(WATER_CONTAINER_MODEL));
            itemMeta.setCustomModelDataComponent(component);
        } else {
            itemMeta.getPersistentDataContainer().set(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)animalData);
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.description.top"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.description.entity", Component.translatable((String)animalData.entityType().translationKey()).style(StyleUtil.YELLOW)), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.description.amount", Component.text((long)animalData.entityCount()).style(StyleUtil.YELLOW)), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.catch_tip.line3"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.release_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.water_animal_container.release_tip.line2")));
            CustomModelDataComponent component = itemMeta.getCustomModelDataComponent();
            if (!component.getStrings().contains(WATER_CONTAINER_FILLED_MODEL)) {
                component.setStrings(List.of(WATER_CONTAINER_FILLED_MODEL, animalData.entityType().key().asString()));
                itemMeta.setCustomModelDataComponent(component);
            }
        }
    }

    public static boolean isAquarium(@NotNull ItemStack item) {
        if (item.getType() != Material.SMOOTH_STONE_SLAB) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasCustomModelDataComponent()) {
            return false;
        }
        return meta.getCustomModelDataComponent().getStrings().contains(AQUARIUM_MODEL);
    }

    public static boolean isAquarium(@Nullable Block block) {
        if (block == null || block.getType() != Material.SMOOTH_STONE_SLAB) {
            return false;
        }
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        return block.getWorld().getPersistentDataContainer().has(penKey, (PersistentDataType)BlockDataType.INSTANCE);
    }

    public static boolean isAquarium(@NotNull Entity entity) {
        return entity.getPersistentDataContainer().has(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void completeAquariumCreation(Block block, BlockData blockData, @NotNull ItemStack itemInHand) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        Entity decorationEntity = block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.501, 0.5), EntityType.ITEM_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
            newEntity.setPersistent(true);
            newEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
            if (newEntity instanceof ItemDisplay) {
                ItemDisplay display = (ItemDisplay)newEntity;
                display.setVisibleByDefault(true);
                ItemStack itemStack = new ItemStack(itemInHand);
                itemStack.setAmount(1);
                display.setItemStack(itemStack);
                Transformation transform = display.getTransformation();
                transform.getScale().set(1.001f, 1.0f, 1.001f);
                display.setTransformation(transform);
            }
            newEntity.getPersistentDataContainer().set(penKey, PersistentDataType.BOOLEAN, (Object)true);
        });
        blockData.decorationEntity = decorationEntity.getUniqueId();
        Entity countEntity = block.getWorld().spawnEntity(block.getLocation().add(Utils.center(blockData.blockFace)), EntityType.TEXT_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
            newEntity.setPersistent(true);
            newEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
            if (newEntity instanceof TextDisplay) {
                TextDisplay display = (TextDisplay)newEntity;
                display.setVisibleByDefault(true);
                display.setSeeThrough(false);
                display.text((Component)Component.text((int)0));
            }
            newEntity.getPersistentDataContainer().set(penKey, PersistentDataType.BOOLEAN, (Object)true);
        });
        blockData.countEntity = countEntity.getUniqueId();
        block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
    }

    public static void validateAquarium(@NotNull Entity entity) {
        Block block = entity.getLocation().add(0.0, -0.5, 0.0).getBlock();
        if (block.getType() != Material.SMOOTH_STONE_SLAB) {
            return;
        }
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to load aquarium block. Restoring...");
            blockData = new BlockData();
        }
        if (blockData.entity == null) {
            blockData.entity = entity.getUniqueId();
            blockData.blockFace = entity.getFacing();
            Collection nearbyEntities = block.getWorld().getNearbyEntities(block.getBoundingBox().expand(1.0), findEntity -> findEntity.getType() == EntityType.TEXT_DISPLAY && findEntity.getFacing() == entity.getFacing() && findEntity.getPersistentDataContainer().has(penKey));
            if (!nearbyEntities.isEmpty()) {
                blockData.countEntity = ((Entity)nearbyEntities.iterator().next()).getUniqueId();
            }
            if (!(nearbyEntities = block.getWorld().getNearbyEntities(block.getBoundingBox().expand(1.0), findEntity -> findEntity.getType() == EntityType.ITEM_DISPLAY && findEntity.getFacing() == entity.getFacing() && findEntity.getPersistentDataContainer().has(penKey))).isEmpty()) {
                blockData.decorationEntity = ((Entity)nearbyEntities.iterator().next()).getUniqueId();
            }
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AttributeInstance attribute = livingEntity.getAttribute(Attribute.SCALE);
            if (attribute != null && livingEntity instanceof WaterMob) {
                AnimalData animalData;
                if (attribute.getBaseValue() != (double)AnimalPenPlugin.configuration().getWaterAnimalSize()) {
                    attribute.setBaseValue((double)AnimalPenPlugin.configuration().getWaterAnimalSize());
                }
                if (AnimalPenPlugin.configuration().isGrowWaterAnimals() && (animalData = AquariumManager.getAnimalData(entity)) != null) {
                    AttributeModifier modifier = attribute.getModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                    float multiplier = AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)animalData.entityCount();
                    if (modifier != null && modifier.getAmount() != (double)multiplier) {
                        attribute.getModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                        attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)multiplier, AttributeModifier.Operation.ADD_NUMBER));
                    }
                }
            }
            livingEntity.setPose(livingEntity.getPose());
        }
    }

    public static AnimalData getAnimalData(Block block) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null || blockData.entity == null) {
            return null;
        }
        return AquariumManager.getAnimalData(block.getWorld().getEntity(blockData.entity));
    }

    public static AnimalData getAnimalData(Entity entity) {
        if (entity == null) {
            AnimalPenPlugin.getInstance().getLogger().severe("Aquarium entity is removed! Cannot access data!");
            return null;
        }
        return (AnimalData)entity.getPersistentDataContainer().get(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE);
    }

    public static void setAquariumData(Block block, AnimalData newData) {
        Entity entity;
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().getOrDefault(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)new BlockData());
        if (blockData.entity == null || block.getWorld().getEntity(blockData.entity) == null) {
            org.bukkit.block.data.BlockData attribute;
            entity = newData.entitySnapshot() != null ? newData.entitySnapshot().createEntity(block.getLocation().add(0.5, 1.0, 0.5)) : block.getWorld().spawnEntity(block.getLocation().add(0.5, 1.0, 0.5), newData.entityType(), CreatureSpawnEvent.SpawnReason.CUSTOM);
            entity.setGravity(false);
            entity.setNoPhysics(true);
            entity.setPersistent(true);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setCollidable(false);
                livingEntity.setAI(false);
                livingEntity.setRemoveWhenFarAway(false);
                livingEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
                attribute = livingEntity.getAttribute(Attribute.SCALE);
                if (attribute != null) {
                    attribute.setBaseValue((double)AnimalPenPlugin.configuration().getAnimalSize());
                    if (AnimalPenPlugin.configuration().isGrowAnimals()) {
                        attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
                    }
                }
            }
            if ((attribute = block.getBlockData()) instanceof Slab) {
                Slab slab = (Slab)attribute;
                block.getRelative(BlockFace.UP).setType(Material.WATER);
                slab.setWaterlogged(true);
                block.setBlockData((org.bukkit.block.data.BlockData)slab);
            }
            blockData.entity = entity.getUniqueId();
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        } else {
            LivingEntity livingEntity;
            AttributeInstance attribute;
            entity = block.getWorld().getEntity(blockData.entity);
            if (AnimalPenPlugin.configuration().isGrowAnimals() && entity instanceof LivingEntity && (attribute = (livingEntity = (LivingEntity)entity).getAttribute(Attribute.SCALE)) != null) {
                attribute.removeModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
            }
        }
        if (entity == null) {
            AnimalPenPlugin.getInstance().getLogger().severe("Aquarium entity is removed! Cannot access data!");
            return;
        }
        AnimalPenPlugin.getInstance().task.startTrackingEntity(entity, false, false);
        entity.getPersistentDataContainer().set(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)newData);
        Helper.updateCountTextEntity(block, blockData, newData.entityCount(), penKey);
    }

    public static void setAquariumData(Entity entity, AnimalData newData) {
        Block block = entity.getLocation().add(0.0, -0.5, 0.0).getBlock();
        if (newData.entityCount() <= 0L) {
            ItemStack itemStack = AquariumManager.createEmptyWaterContainer();
            entity.getWorld().dropItem(entity.getLocation(), itemStack);
            AnimalPenPlugin.getInstance().task.stopTrackingEntity(entity, false);
            entity.getPersistentDataContainer().remove(AQUARIUM_DATA_KEY);
            entity.remove();
            org.bukkit.block.data.BlockData blockData = block.getBlockData();
            if (blockData instanceof Slab) {
                Slab slab = (Slab)blockData;
                block.getRelative(BlockFace.UP).setType(Material.AIR);
                slab.setWaterlogged(false);
                block.setBlockData((org.bukkit.block.data.BlockData)slab);
            }
        } else {
            LivingEntity livingEntity;
            AttributeInstance attribute;
            entity.getPersistentDataContainer().set(AQUARIUM_DATA_KEY, (PersistentDataType)AnimalDataType.INSTANCE, (Object)newData);
            if (AnimalPenPlugin.configuration().isGrowWaterAnimals() && entity instanceof LivingEntity && (attribute = (livingEntity = (LivingEntity)entity).getAttribute(Attribute.SCALE)) != null) {
                attribute.removeModifier((Key)Utils.ANIMAL_SIZE_MODIFIER);
                attribute.addModifier(new AttributeModifier(Utils.ANIMAL_SIZE_MODIFIER, (double)(AnimalPenPlugin.configuration().getGrowthMultiplier().floatValue() * (float)newData.entityCount()), AttributeModifier.Operation.ADD_NUMBER));
            }
        }
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().getOrDefault(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)new BlockData());
        Helper.updateCountTextEntity(block, blockData, newData.entityCount(), penKey);
    }

    public static void clearBlockData(Block block, boolean keepBlock) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null) {
            return;
        }
        AnimalPenPlugin.getInstance().task.stopTrackingEntity(blockData.entity, block.getWorld(), false);
        Helper.removeEntity(block.getWorld(), blockData.entity);
        org.bukkit.block.data.BlockData blockData2 = block.getBlockData();
        if (blockData2 instanceof Slab) {
            Slab slab = (Slab)blockData2;
            block.getRelative(BlockFace.UP).setType(Material.AIR);
            slab.setWaterlogged(false);
            block.setBlockData((org.bukkit.block.data.BlockData)slab);
        }
        blockData.entity = null;
        if (keepBlock) {
            Helper.updateCountTextEntity(block, blockData, 0L, penKey);
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        } else {
            Helper.removeEntity(block.getWorld(), blockData.countEntity);
            Helper.removeEntity(block.getWorld(), blockData.decorationEntity);
            block.getWorld().getPersistentDataContainer().remove(penKey);
        }
    }

    public static ItemStack getAquariumItem(Block block) {
        NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), block.getX() + "_" + block.getY() + "_" + block.getZ() + "_aquarium");
        BlockData blockData = (BlockData)block.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
        if (blockData == null || blockData.decorationEntity == null) {
            return AquariumManager.createAquarium();
        }
        Entity entity = block.getWorld().getEntity(blockData.decorationEntity);
        if (!(entity instanceof ItemDisplay)) {
            return AquariumManager.createAquarium();
        }
        ItemDisplay display = (ItemDisplay)entity;
        return display.getItemStack();
    }

    public static ItemStack createAquarium() {
        ItemStack smoothStoneSlab = new ItemStack(Material.SMOOTH_STONE_SLAB);
        ItemMeta meta = smoothStoneSlab.getItemMeta();
        if (meta == null) {
            return smoothStoneSlab;
        }
        CustomModelDataComponent customData = meta.getCustomModelDataComponent();
        customData.setStrings(List.of(AQUARIUM_MODEL));
        meta.setCustomModelDataComponent(customData);
        meta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.name").style(StyleUtil.WHITE));
        meta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.aquarium.tip.line3")));
        smoothStoneSlab.setItemMeta(meta);
        return smoothStoneSlab;
    }

    public static void handleFood(LivingEntity entity, Player player, ItemStack itemStack) {
        AnimalData data = AquariumManager.getAnimalData((Entity)entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.APPLE)) {
            return;
        }
        long maxCount = AnimalPenPlugin.configuration().getMaximalAnimalCount();
        if (maxCount > 0L && data.entityCount() >= maxCount) {
            return;
        }
        int stackSize = itemStack.getAmount();
        stackSize = (int)Math.min(data.entityCount(), (long)stackSize);
        if (stackSize < 2) {
            return;
        }
        stackSize = (int)Math.min((maxCount - data.entityCount()) * 2L, (long)stackSize);
        Utils.triggerItemUse((Entity)entity, player, itemStack, stackSize % 2 == 1 ? stackSize - 1 : stackSize);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (stackSize % 2 == 1) {
                itemStack.subtract(stackSize - 1);
            } else {
                itemStack.subtract(stackSize);
            }
        }
        int amount = stackSize / 2;
        data.addEntityCount(amount);
        entity.getWorld().spawnParticle(Particle.HEART, entity.getLocation(), 5, 0.2, 0.2, 0.2, 0.05);
        entity.getWorld().playSound((Entity)entity, entity.getEatingSound(itemStack), new Random().nextFloat(0.8f, 1.2f), 1.0f);
        player.swingMainHand();
        data.setCooldown(Material.APPLE, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.APPLE, stackSize));
        AquariumManager.setAquariumData((Entity)entity, data);
    }

    public static void handleWaterBucket(Entity entity, Player player, ItemStack itemStack) {
        Sound sound;
        ItemStack newBucket;
        if (entity.getType() != EntityType.TROPICAL_FISH && entity.getType() != EntityType.SALMON && entity.getType() != EntityType.PUFFERFISH && entity.getType() != EntityType.COD && entity.getType() != EntityType.TADPOLE) {
            return;
        }
        AnimalData data = AquariumManager.getAnimalData(entity);
        if (data == null) {
            return;
        }
        if (data.hasCooldown(Material.WATER_BUCKET)) {
            return;
        }
        switch (entity.getType()) {
            case COD: {
                newBucket = new ItemStack(Material.COD_BUCKET);
                sound = Sound.ITEM_BUCKET_FILL_FISH;
                break;
            }
            case PUFFERFISH: {
                newBucket = new ItemStack(Material.PUFFERFISH_BUCKET);
                sound = Sound.ITEM_BUCKET_FILL_FISH;
                break;
            }
            case SALMON: {
                newBucket = new ItemStack(Material.SALMON_BUCKET);
                sound = Sound.ITEM_BUCKET_FILL_FISH;
                break;
            }
            case TADPOLE: {
                newBucket = new ItemStack(Material.TADPOLE_BUCKET);
                sound = Sound.ITEM_BUCKET_FILL_TADPOLE;
                break;
            }
            case TROPICAL_FISH: {
                newBucket = new ItemStack(Material.TROPICAL_FISH_BUCKET);
                TropicalFishBucketMeta itemMeta = (TropicalFishBucketMeta)newBucket.getItemMeta();
                TropicalFish tropicalFish = (TropicalFish)entity;
                itemMeta.setBodyColor(tropicalFish.getBodyColor());
                itemMeta.setPattern(tropicalFish.getPattern());
                itemMeta.setPatternColor(tropicalFish.getPatternColor());
                newBucket.setItemMeta((ItemMeta)itemMeta);
                sound = Sound.ITEM_BUCKET_FILL_FISH;
                break;
            }
            default: {
                return;
            }
        }
        data.reduceEntityCount(1L);
        Utils.triggerItemUse(entity, player, itemStack, 1);
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.subtract();
        }
        player.getInventory().addItem(new ItemStack[]{newBucket});
        entity.getWorld().playSound(entity, sound, new Random().nextFloat(0.8f, 1.2f), 1.0f);
        player.swingMainHand();
        data.setCooldown(Material.WATER_BUCKET, AnimalPenPlugin.configuration().getEntityCooldown(entity.getType(), Material.WATER_BUCKET, data.entityCount()));
        AquariumManager.setAquariumData(entity, data);
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            CriteriaTriggers.FILLED_BUCKET.trigger(((CraftPlayer)player).getHandle(), ((CraftItemStack)newBucket).handle);
        }
    }

    public static void handleKilling(LivingEntity entity, Player player, ItemStack itemStack) {
        Sound deathSound;
        int cooldown;
        AnimalData data = AquariumManager.getAnimalData((Entity)entity);
        if (data == null) {
            return;
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.USE_ITEM, itemStack.getType());
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            itemStack.damage(1, (LivingEntity)player);
        }
        if ((cooldown = AnimalPenPlugin.configuration().getAttackCooldown()) > 0) {
            player.setCooldown(itemStack, cooldown);
        }
        data.reduceEntityCount(1L);
        AquariumManager.setAquariumData((Entity)entity, data);
        LootTable lootTable = Bukkit.getLootTable((NamespacedKey)NamespacedKey.minecraft((String)("entities/" + entity.getType().getKey().value())));
        if (lootTable != null) {
            Collection itemStacks = lootTable.populateLoot(new Random(), new LootContext.Builder(entity.getLocation()).killer((HumanEntity)player).lootedEntity((Entity)entity).build());
            Location location = entity.getLocation().add(0.0, 1.0, 0.0);
            itemStacks.forEach(item -> entity.getWorld().dropItemNaturally(location, item));
        }
        if ((deathSound = entity.getDeathSound()) != null) {
            entity.getWorld().playSound(entity.getLocation(), deathSound, new Random().nextFloat(0.5f, 1.0f), 1.0f);
        } else {
            entity.getWorld().playSound(entity.getLocation(), Sound.ENTITY_GENERIC_DEATH, new Random().nextFloat(0.5f, 1.0f), 1.0f);
        }
        entity.getWorld().spawnParticle(Particle.SMOKE, entity.getLocation().add(0.0, 0.5, 0.0), 10, 0.3, 0.3, 0.3, 0.01);
        entity.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, entity.getLocation().add(0.0, 0.5, 0.0), 2, 0.2, 0.2, 0.2, 0.0);
        if (AnimalPenPlugin.configuration().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(((CraftPlayer)player).getHandle(), ((CraftEntity)entity).getHandle(), ((CraftDamageSource)DamageSource.builder((DamageType)DamageType.PLAYER_ATTACK).build()).getHandle());
        }
        if (AnimalPenPlugin.configuration().isIncreaseStatistics()) {
            player.incrementStatistic(Statistic.MOB_KILLS);
            player.incrementStatistic(Statistic.KILL_ENTITY, entity.getType());
        }
    }
}

