/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.data.BlockData;
import lv.id.bonne.animalpenpaper.data.BlockDataType;
import lv.id.bonne.animalpenpaper.util.Utils;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class Helper {
    public static DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static void removeEntity(World world, @Nullable UUID uuid) {
        Entity entity;
        if (uuid != null && (entity = world.getEntity(uuid)) != null) {
            entity.remove();
        }
    }

    static void updateCountTextEntity(Block block, BlockData blockData, long entityCount, NamespacedKey penKey) {
        Entity entity;
        if (blockData.countEntity == null || block.getWorld().getEntity(blockData.countEntity) == null) {
            entity = block.getWorld().spawnEntity(block.getLocation().add(Utils.center(blockData.blockFace)), EntityType.TEXT_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
                newEntity.setPersistent(true);
                newEntity.setRotation(Utils.blockFaceToYaw(blockData.blockFace), 0.0f);
                if (newEntity instanceof TextDisplay) {
                    TextDisplay display = (TextDisplay)newEntity;
                    display.setVisibleByDefault(true);
                    display.setSeeThrough(false);
                }
                newEntity.getPersistentDataContainer().set(penKey, PersistentDataType.BOOLEAN, (Object)true);
            });
            blockData.countEntity = entity.getUniqueId();
            block.getWorld().getPersistentDataContainer().set(penKey, (PersistentDataType)BlockDataType.INSTANCE, (Object)blockData);
        } else {
            entity = block.getWorld().getEntity(blockData.countEntity);
        }
        if (entity instanceof TextDisplay) {
            TextDisplay display = (TextDisplay)entity;
            display.text((Component)Component.text((long)entityCount));
        }
    }

    public static List<Pair<Material, Component>> generateTextMessages(Entity entity, AnimalData animalData, int tick) {
        List<Material> foodItems;
        EntityType entityType = entity.getType();
        ArrayList<Pair<Material, Component>> lines = new ArrayList<Pair<Material, Component>>(4);
        if (AnimalPenPlugin.configuration().getEntityCooldown(entityType, Material.APPLE, animalData.entityCount()) != 0 && (foodItems = AnimalPenPlugin.animalFoodConfiguration().getFoodItems(entityType)) != null && !foodItems.isEmpty()) {
            Material foodItem;
            Component component = !animalData.hasCooldown(Material.APPLE) ? AnimalPenPlugin.translations().getTranslatable("display.animal_pen.ready") : AnimalPenPlugin.translations().getTranslatable("display.animal_pen.cooldown", Component.text((String)LocalTime.of(0, 0, 0).plusSeconds(animalData.getCooldown(Material.APPLE) / 20).format(DATE_FORMATTER)));
            if (foodItems.size() == 1) {
                foodItem = foodItems.getFirst();
            } else {
                int size = foodItems.size();
                int index = tick / 100 % size;
                foodItem = foodItems.get(index);
            }
            lines.add((Pair<Material, Component>)Pair.of((Object)foodItem, (Object)component));
        }
        switch (entityType) {
            case ARMADILLO: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BRUSH, Material.ARMADILLO_SCUTE);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case AXOLOTL: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.AXOLOTL_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case COD: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.COD_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case SALMON: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.SALMON_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case PUFFERFISH: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.PUFFERFISH_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case TROPICAL_FISH: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.TROPICAL_FISH_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case TADPOLE: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WATER_BUCKET, Material.TADPOLE_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case BEE: {
                Pair<Material, Component> textPairMessage = !animalData.hasCooldown(Material.SHEARS) && !animalData.hasCooldown(Material.GLASS_BOTTLE) ? (tick / 100 % 2 == 0 ? Helper.createTextPairMessage(entityType, animalData, Material.SHEARS, Material.HONEYCOMB) : Helper.createTextPairMessage(entityType, animalData, Material.GLASS_BOTTLE, Material.HONEY_BOTTLE)) : (animalData.hasCooldown(Material.SHEARS) ? Helper.createTextPairMessage(entityType, animalData, Material.SHEARS, Material.HONEYCOMB) : Helper.createTextPairMessage(entityType, animalData, Material.GLASS_BOTTLE, Material.HONEY_BOTTLE));
                lines.add(textPairMessage);
                break;
            }
            case CHICKEN: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BUCKET, Material.EGG);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case TURTLE: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BUCKET, Material.TURTLE_EGG);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case COW: 
            case GOAT: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BUCKET, Material.MILK_BUCKET);
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case FROG: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.MAGMA_BLOCK, Utils.getFrogLight((Frog)entity));
                if (textPairMessage == null) break;
                lines.add(textPairMessage);
                break;
            }
            case MOOSHROOM: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BUCKET, Material.MILK_BUCKET);
                if (textPairMessage != null) {
                    lines.add(textPairMessage);
                }
                if ((textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BOWL, Material.MUSHROOM_STEW)) == null) break;
                lines.add(textPairMessage);
                break;
            }
            case SHEEP: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.SHEARS, Utils.getWoolMaterial(((Sheep)entity).getColor()));
                if (textPairMessage != null) {
                    lines.add(textPairMessage);
                }
                if ((textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.WHITE_DYE, Utils.getWoolMaterial(((Sheep)entity).getColor()))) == null) break;
                lines.add(textPairMessage);
                break;
            }
            case SNIFFER: {
                Pair<Material, Component> textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BUCKET, Material.SNIFFER_EGG);
                if (textPairMessage != null) {
                    lines.add(textPairMessage);
                }
                if ((textPairMessage = Helper.createTextPairMessage(entityType, animalData, Material.BOWL, tick / 100 % 2 == 0 ? Material.TORCHFLOWER_SEEDS : Material.PITCHER_POD)) == null) break;
                lines.add(textPairMessage);
            }
        }
        return lines;
    }

    private static Pair<Material, Component> createTextPairMessage(EntityType entityType, AnimalData animalData, Material material, Material result) {
        Material icon;
        Component component;
        if (AnimalPenPlugin.configuration().getEntityCooldown(entityType, material, animalData.entityCount()) == 0 || result.isAir()) {
            return null;
        }
        if (!animalData.hasCooldown(material)) {
            component = AnimalPenPlugin.translations().getTranslatable("display.animal_pen.ready");
            icon = material;
        } else {
            component = AnimalPenPlugin.translations().getTranslatable("display.animal_pen.cooldown", Component.text((String)LocalTime.of(0, 0, 0).plusSeconds(animalData.getCooldown(material) / 20).format(DATE_FORMATTER)));
            icon = result;
        }
        return Pair.of((Object)icon, (Object)component);
    }
}

