/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import java.io.File;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TranslationManager {
    private FileConfiguration messagesConfig;

    public TranslationManager() {
        this.loadMessages(false);
    }

    private void loadMessages(boolean reset) {
        File messagesFile = new File(AnimalPenPlugin.getInstance().getDataFolder(), "messages.yml");
        if (!messagesFile.exists() || reset) {
            AnimalPenPlugin.getInstance().saveResource("messages.yml", reset);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        AnimalPenPlugin.getInstance().getLogger().info("Loaded translation fallbacks from messages.yml");
    }

    public void reload() {
        this.loadMessages(false);
    }

    public void reset() {
        this.loadMessages(true);
    }

    public Component getTranslatable(String key) {
        String fallback = this.messagesConfig.getString(key);
        if (fallback == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("No fallback found for translation key: " + key);
            fallback = key;
        }
        return Component.translatable((String)key).fallback(fallback);
    }

    public Component getTranslatable(String key, Object ... args) {
        String fallback = this.messagesConfig.getString(key);
        if (fallback == null) {
            AnimalPenPlugin.getInstance().getLogger().warning("No fallback found for translation key: " + key);
            fallback = key;
        }
        Component[] componentArgs = new Component[args.length];
        for (int i = 0; i < args.length; ++i) {
            componentArgs[i] = args[i] instanceof Component ? (Component)args[i] : Component.text((String)String.valueOf(args[i]));
        }
        return Component.translatable((String)key, (ComponentLike[])componentArgs).fallback(fallback);
    }

    public Component getTranslatable(String key, String customFallback) {
        return Component.translatable((String)key).fallback(customFallback);
    }

    public Component getTranslatable(String key, String customFallback, Object ... args) {
        Component[] componentArgs = new Component[args.length];
        for (int i = 0; i < args.length; ++i) {
            componentArgs[i] = args[i] instanceof Component ? (Component)args[i] : Component.text((String)String.valueOf(args[i]));
        }
        return Component.translatable((String)key, (ComponentLike[])componentArgs).fallback(customFallback);
    }

    public boolean hasFallback(String key) {
        return this.messagesConfig.contains(key);
    }

    public String getFallback(String key) {
        return this.messagesConfig.getString(key);
    }
}

