/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.data.BlockData;
import lv.id.bonne.animalpenpaper.data.BlockDataType;
import lv.id.bonne.animalpenpaper.managers.AnimalPenManager;
import lv.id.bonne.animalpenpaper.managers.AquariumManager;
import lv.id.bonne.animalpenpaper.managers.Helper;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;

public class DisplayTextManager
implements Listener {
    public BukkitTask bukkitTask;
    static final Map<EntityReference, List<Display>> cache = new ConcurrentHashMap<EntityReference, List<Display>>(10);

    @EventHandler
    public void onEntityLoading(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            ItemDisplay display;
            if (AnimalPenManager.isAnimalPen(entity)) {
                AnimalPenManager.validateAnimalPen(entity);
                this.startTrackingEntity(entity, true, true);
                continue;
            }
            if (AquariumManager.isAquarium(entity)) {
                AquariumManager.validateAquarium(entity);
                this.startTrackingEntity(entity, true, false);
                continue;
            }
            if (!(entity instanceof ItemDisplay) || !(display = (ItemDisplay)entity).getPersistentDataContainer().has(Helper.DECORATION_ENTITY_KEY, PersistentDataType.STRING)) continue;
            String key = (String)display.getPersistentDataContainer().get(Helper.DECORATION_ENTITY_KEY, PersistentDataType.STRING);
            NamespacedKey penKey = new NamespacedKey((Plugin)AnimalPenPlugin.getInstance(), key);
            BlockData blockData = (BlockData)display.getWorld().getPersistentDataContainer().get(penKey, (PersistentDataType)BlockDataType.INSTANCE);
            if (blockData == null || blockData.entity != null) continue;
            Helper.updateCountTextEntity(display.getLocation().getBlock(), blockData, 0L, penKey);
        }
    }

    @EventHandler
    public void onPlayerCrouching(PlayerToggleSneakEvent event) {
        if (!AnimalPenPlugin.configuration().isShowCooldownsOnlyOnShift()) {
            return;
        }
        if (!event.isSneaking()) {
            cache.values().stream().flatMap(Collection::stream).forEach(display -> event.getPlayer().hideEntity((Plugin)AnimalPenPlugin.getInstance(), (Entity)display));
        } else {
            cache.values().stream().flatMap(Collection::stream).filter(display -> display.getLocation().distanceSquared(event.getPlayer().getLocation()) <= 100.0).forEach(display -> event.getPlayer().showEntity((Plugin)AnimalPenPlugin.getInstance(), (Entity)display));
        }
    }

    @EventHandler
    public void onEntityUnloading(EntitiesUnloadEvent event) {
        for (Entity entity : event.getEntities()) {
            Display display;
            if (AnimalPenManager.isAnimalPen(entity)) {
                this.stopTrackingEntity(entity, true);
                continue;
            }
            if (AquariumManager.isAquarium(entity)) {
                this.stopTrackingEntity(entity, false);
                continue;
            }
            if (!(entity instanceof Display) || !(display = (Display)entity).getPersistentDataContainer().has(Helper.COUNTER_ENTITY_KEY, PersistentDataType.STRING)) continue;
            display.remove();
        }
    }

    public void startTrackingEntity(Entity entity, boolean replace, boolean isPen) {
        EntityReference reference = new EntityReference(entity.getUniqueId(), entity.getWorld().getUID(), isPen);
        if (!cache.containsKey(reference)) {
            cache.put(reference, new ArrayList());
        } else if (replace) {
            this.stopTrackingEntity(entity, isPen);
            cache.put(reference, new ArrayList());
        }
    }

    public void stopTrackingEntity(UUID entityUUID, World world, boolean isPen) {
        if (entityUUID == null) {
            return;
        }
        this.stopTrackingEntity(new EntityReference(entityUUID, world.getUID(), isPen));
    }

    public void stopTrackingEntity(Entity entity, boolean isPen) {
        this.stopTrackingEntity(entity.getUniqueId(), entity.getWorld(), isPen);
    }

    private void stopTrackingEntity(EntityReference entityReference) {
        List<Display> leftOverEntities = cache.remove(entityReference);
        if (leftOverEntities != null) {
            leftOverEntities.forEach(Entity::remove);
        }
    }

    public void runTask() {
        final AtomicInteger tick = new AtomicInteger();
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                ArrayList<EntityReference> entityReferenceList = new ArrayList<EntityReference>(cache.keySet());
                entityReferenceList.forEach(entityReference -> {
                    Entity entity = DisplayTextManager.this.getEntity((EntityReference)entityReference);
                    if (entity != null) {
                        AnimalData animalData;
                        AnimalData animalData2 = animalData = entityReference.isPen() ? AnimalPenManager.getAnimalData(entity) : AquariumManager.getAnimalData(entity);
                        if (animalData != null) {
                            List<Display> displayList = cache.get(entityReference);
                            animalData.getCooldowns().replaceAll((key, value) -> {
                                int newValue = Math.max(0, value - 20);
                                if (newValue == 0 && value > 0 && entityReference.isPen()) {
                                    AnimalPenManager.processCooldownFinish(entity, key, animalData);
                                }
                                return newValue;
                            });
                            if (entityReference.isPen()) {
                                AnimalPenManager.setAnimalPenData(entity, animalData);
                            } else {
                                AquariumManager.setAquariumData(entity, animalData);
                            }
                            List<Pair<Material, Component>> generatedTextMessages = Helper.generateTextMessages(entity, animalData, tick.get());
                            int neededCount = generatedTextMessages.size() * 2;
                            if (displayList.size() != neededCount) {
                                displayList.forEach(Entity::remove);
                                displayList.clear();
                                double yOffset = 1.2;
                                while (displayList.size() < neededCount) {
                                    displayList.add((Display)entity.getWorld().spawnEntity(entity.getLocation().add(0.0, yOffset + 0.0625, 0.0), EntityType.ITEM_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
                                        Display display = (Display)newEntity;
                                        Transformation transform = display.getTransformation();
                                        transform.getScale().set(0.125f, 0.125f, 0.125f);
                                        transform.getTranslation().set(-0.45f, 0.0f, 0.0f);
                                        display.setTransformation(transform);
                                        display.setPersistent(false);
                                        if (AnimalPenPlugin.configuration().isShowCooldownsOnlyOnShift()) {
                                            display.setVisibleByDefault(false);
                                        } else {
                                            display.setViewRange(0.05f);
                                        }
                                    }));
                                    displayList.add((Display)entity.getWorld().spawnEntity(entity.getLocation().add(0.0, yOffset, 0.0), EntityType.TEXT_DISPLAY, CreatureSpawnEvent.SpawnReason.CUSTOM, newEntity -> {
                                        TextDisplay display = (TextDisplay)newEntity;
                                        Transformation transform = display.getTransformation();
                                        transform.getScale().set(0.4f, 0.4f, 0.4f);
                                        display.setTransformation(transform);
                                        display.setPersistent(false);
                                        display.setDefaultBackground(false);
                                        display.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
                                        if (AnimalPenPlugin.configuration().isShowCooldownsOnlyOnShift()) {
                                            display.setVisibleByDefault(false);
                                        } else {
                                            display.setViewRange(0.05f);
                                        }
                                    }));
                                    yOffset += 0.125;
                                }
                            }
                            int displayIndex = 0;
                            for (Pair messagePair : generatedTextMessages.reversed()) {
                                Display text;
                                Display item = displayList.get(displayIndex++);
                                Component message = (Component)messagePair.getValue();
                                if (item instanceof ItemDisplay) {
                                    ItemDisplay itemDisplay = (ItemDisplay)item;
                                    itemDisplay.setItemStack(new ItemStack((Material)messagePair.getKey()));
                                }
                                if (!((text = displayList.get(displayIndex++)) instanceof TextDisplay)) continue;
                                TextDisplay textDisplay = (TextDisplay)text;
                                textDisplay.text(message);
                            }
                        } else {
                            DisplayTextManager.this.stopTrackingEntity((EntityReference)entityReference);
                        }
                    } else {
                        DisplayTextManager.this.stopTrackingEntity((EntityReference)entityReference);
                    }
                });
                tick.addAndGet(20);
            }
        }.runTaskTimer((Plugin)AnimalPenPlugin.getInstance(), 0L, 20L);
    }

    public Entity getEntity(EntityReference ref) {
        World world = Bukkit.getWorld((UUID)ref.worldId());
        return world != null ? world.getEntity(ref.entityId()) : null;
    }

    public record EntityReference(UUID entityId, UUID worldId, boolean isPen) {
    }
}

