/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lv.id.bonne.animalpenpaper.config.annotations.JsonComment;
import lv.id.bonne.animalpenpaper.config.annotations.JsonComments;
import lv.id.bonne.animalpenpaper.config.annotations.SerializeWithComments;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;

public class Configuration {
    @JsonComments(value={@JsonComment(value="List of cooldowns that are applied when player performs action."), @JsonComment(value="Specifying: `animal_pen:any` will indicate that any entity using that item will have same cooldown."), @JsonComment(value="`minecraft:apple` is universal food item. It is used to indicate for feeding action."), @JsonComment(value="`minecraft:honey_bloc` is used to indicate pollen regeneration cooldown."), @JsonComment(value="<item> : <cooldown>.")})
    @Expose
    @SerializedName(value="cooldowns")
    private Map<NamespacedKey, List<CooldownEntry>> cooldownList = new HashMap<NamespacedKey, List<CooldownEntry>>();
    @JsonComments(value={@JsonComment(value="A cooldown value in game ticks between attacks that players can perform on animal pens."), @JsonComment(value="Default value: 5 game tick")})
    @Expose
    @SerializedName(value="attack_cooldown")
    private Integer attackCooldown;
    @JsonComments(value={@JsonComment(value="List of drop limits for items when player harvests Material."), @JsonComment(value="<item> : <drop_limit>.")})
    @Expose
    @SerializedName(value="drop_limits")
    private Map<NamespacedKey, Integer> dropLimitList = new HashMap<NamespacedKey, Integer>();
    @JsonComments(value={@JsonComment(value="Allows to set maximal amount of animals in the pen."), @JsonComment(value="Setting 0 will remove any limit.")})
    @Expose
    @SerializedName(value="animal_limit_in_pen")
    private long maximalAnimalCount = Integer.MAX_VALUE;
    @JsonComments(value={@JsonComment(value="Allows to toggle if animal cooldowns should be showed only if player is crouching."), @JsonComment(value="This may* increase performance impact as will not require recalculations on shift."), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="show_cooldowns_only_on_crouch")
    private Boolean showCooldownsOnlyOnShift;
    @JsonComments(value={@JsonComment(value="Allows to toggle if animal interactions should be showed even if the cooldown is not set."), @JsonComment(value="Default value = true")})
    @Expose
    @SerializedName(value="show_all_interactions")
    private Boolean showAllInteractions;
    @JsonComments(value={@JsonComment(value="Allows to enable animal growing in animal pen."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="animals_can_grow")
    private boolean growAnimals = false;
    @JsonComment(value="Allows to change default animal size in pen.")
    @Expose
    @SerializedName(value="animal_size")
    private Float animalSize;
    @JsonComments(value={@JsonComment(value="Allows to enable water animal growing in aquarium."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="water_animals_can_grow")
    private boolean growWaterAnimals = false;
    @JsonComment(value="Allows to change default water animal size in aquarium.")
    @Expose
    @SerializedName(value="water_animal_size")
    private Float waterAnimalSize;
    @JsonComments(value={@JsonComment(value="Allows to set how fast animals grows in pen and aquarium."), @JsonComment(value="Each animal is multiplied by given value to get end size."), @JsonComment(value="This option works only if animals_can_grow or water_animals_can_grow is enabled."), @JsonComment(value="Default value = 0.001")})
    @Expose
    @SerializedName(value="growth_multiplier")
    private Float growthMultiplier;
    @JsonComments(value={@JsonComment(value="Allows to specify if turtle scute are dropped when player breeds animal (true)."), @JsonComment(value="or when food cooldown timer is finished (false).")})
    @Expose
    @SerializedName(value="turtle_scute_drop_time")
    private boolean dropScuteAtStart = false;
    @JsonComments(value={@JsonComment(value="Allows to set how many different animal variants can be stored per item."), @JsonComment(value="Players will not be able to store more different variants than this value."), @JsonComment(value="Be aware, this increases NBT data size, so not recommended to put infinite amount."), @JsonComment(value="Default value = 10")})
    @Expose
    @SerializedName(value="max_stored_animal_variants")
    private Integer maxStoredAnimalVariants;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should trigger advancements."), @JsonComment(value="Triggered Criteria: player_interacted_with_entity, bred_animals, filled_bucket, player_killed_entity"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="trigger_advancements")
    private Boolean triggerAdvancements;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should increase statistics."), @JsonComment(value="Increased Statistics: Animals Bred, Mob Kills, Use Item <item>, Kill Entity <entity>"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="increase_statistics")
    private Boolean increaseStatistics;
    @JsonComment(value="Set of animals that are blocked from picking up.")
    @Expose
    @SerializedName(value="blocked_animals")
    private Set<NamespacedKey> blockedAnimals = new HashSet<NamespacedKey>();
    @JsonComment(value="")
    @Expose(serialize=false, deserialize=false)
    private static final NamespacedKey ANY = new NamespacedKey("animal_pen_paper", "any");

    public static Configuration getDefaultConfig() {
        Configuration configuration = new Configuration();
        configuration.setDefaults(true);
        return configuration;
    }

    public boolean isInvalid() {
        return this.dropLimitList == null || this.cooldownList == null || this.blockedAnimals == null || this.waterAnimalSize == null || this.waterAnimalSize.floatValue() <= 0.0f || this.animalSize == null || this.animalSize.floatValue() <= 0.0f || this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || this.attackCooldown == null || this.attackCooldown < 0 || this.maxStoredAnimalVariants == null || this.maxStoredAnimalVariants < 0 || this.triggerAdvancements == null || this.increaseStatistics == null || this.showCooldownsOnlyOnShift == null || this.showAllInteractions == null;
    }

    public void setDefaults(boolean init) {
        if (this.dropLimitList == null || init) {
            this.dropLimitList = new HashMap<NamespacedKey, Integer>();
            this.populateDefaultDropLimits();
        }
        if (this.cooldownList == null || init) {
            this.cooldownList = new HashMap<NamespacedKey, List<CooldownEntry>>();
            this.populateDefaultCooldowns();
        }
        if (this.blockedAnimals == null || init) {
            this.blockedAnimals = new HashSet<NamespacedKey>();
        }
        if (this.animalSize == null || this.animalSize.floatValue() <= 0.0f || init) {
            this.animalSize = Float.valueOf(0.33f);
        }
        if (this.waterAnimalSize == null || this.waterAnimalSize.floatValue() <= 0.0f || init) {
            this.waterAnimalSize = Float.valueOf(0.33f);
        }
        if (this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || init) {
            this.growthMultiplier = Float.valueOf(0.001f);
        }
        if (this.attackCooldown == null || this.attackCooldown < 0 || init) {
            this.attackCooldown = 5;
        }
        if (this.maxStoredAnimalVariants == null || this.maxStoredAnimalVariants < 0 || init) {
            this.maxStoredAnimalVariants = 10;
        }
        if (this.increaseStatistics == null || init) {
            this.increaseStatistics = false;
        }
        if (this.triggerAdvancements == null || init) {
            this.triggerAdvancements = false;
        }
        if (this.showCooldownsOnlyOnShift == null || init) {
            this.showCooldownsOnlyOnShift = false;
        }
        if (this.showAllInteractions == null || init) {
            this.showAllInteractions = true;
        }
        if (init) {
            this.maximalAnimalCount = Integer.MAX_VALUE;
            this.growAnimals = false;
            this.growWaterAnimals = false;
            this.dropScuteAtStart = false;
        }
    }

    private void populateDefaultCooldowns() {
        this.cooldownList.computeIfAbsent(Material.APPLE.getKey(), i -> new ArrayList()).add(new CooldownEntry(ANY, 1160, 20, 6000));
        this.cooldownList.computeIfAbsent(Material.SHEARS.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.SHEEP.getKey(), 1180, 20, 6000));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.CHICKEN.getKey(), 6020, -20, 1200));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.TURTLE.getKey(), 6020, -20, 1200));
        this.cooldownList.computeIfAbsent(Material.SHEARS.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.BEE.getKey(), 1220, -20, 20));
        this.cooldownList.computeIfAbsent(Material.GLASS_BOTTLE.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.BEE.getKey(), 1220, -20, 20));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.COW.getKey(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(Material.BOWL.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.MOOSHROOM.getKey(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.MOOSHROOM.getKey(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.GOAT.getKey(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(Material.MAGMA_BLOCK.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.FROG.getKey(), 6020, -20, 200));
        this.cooldownList.computeIfAbsent(Material.BUCKET.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.SNIFFER.getKey(), 6020, -20, 200));
        this.cooldownList.computeIfAbsent(Material.BOWL.getKey(), i -> new ArrayList()).add(new CooldownEntry(EntityType.SNIFFER.getKey(), 6020, -20, 200));
    }

    private void populateDefaultDropLimits() {
        this.dropLimitList = new HashMap<NamespacedKey, Integer>();
        this.dropLimitList.put(Material.EGG.getKey(), 80);
        this.dropLimitList.put(Material.TURTLE_EGG.getKey(), 320);
        this.dropLimitList.put(Material.WHITE_WOOL.getKey(), 320);
        this.dropLimitList.put(Material.PEARLESCENT_FROGLIGHT.getKey(), 320);
        this.dropLimitList.put(Material.TORCHFLOWER_SEEDS.getKey(), 320);
    }

    public int getEntityCooldown(EntityType entity, Material usedItem, long entityAmount) {
        if (!this.cooldownList.containsKey(usedItem.getKey())) {
            return 0;
        }
        Collection cooldownEntries = this.cooldownList.get(usedItem.getKey());
        return cooldownEntries.stream().filter(cooldownEntry -> cooldownEntry.entity.equals((Object)entity.getKey())).findFirst().map(cooldownEntry -> cooldownEntry.getValue(entityAmount)).orElseGet(() -> cooldownEntries.stream().filter(cooldownEntry -> cooldownEntry.entity.equals((Object)ANY)).findFirst().map(cooldownEntry -> cooldownEntry.getValue(entityAmount)).orElse(0));
    }

    public int getDropLimits(Material item) {
        return this.dropLimitList.getOrDefault(item.getKey(), 0);
    }

    public long getMaximalAnimalCount() {
        return this.maximalAnimalCount;
    }

    public boolean isDropScuteAtStart() {
        return this.dropScuteAtStart;
    }

    public boolean isGrowAnimals() {
        return this.growAnimals;
    }

    public float getAnimalSize() {
        return this.animalSize.floatValue();
    }

    public boolean isGrowWaterAnimals() {
        return this.growWaterAnimals;
    }

    public float getWaterAnimalSize() {
        return this.waterAnimalSize.floatValue();
    }

    public Float getGrowthMultiplier() {
        return this.growthMultiplier;
    }

    public boolean isBlocked(EntityType entityType) {
        return this.blockedAnimals.contains(entityType.getKey());
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public int getMaxStoredVariants() {
        return this.maxStoredAnimalVariants;
    }

    public boolean isTriggerAdvancements() {
        return this.triggerAdvancements;
    }

    public boolean isIncreaseStatistics() {
        return this.increaseStatistics;
    }

    public boolean isShowCooldownsOnlyOnShift() {
        return this.showCooldownsOnlyOnShift;
    }

    public boolean isShowAllInteractions() {
        return this.showAllInteractions;
    }

    @SerializeWithComments
    public static class CooldownEntry {
        @JsonComment(value="The entity ID on which cooldown is applied.")
        @Expose
        @SerializedName(value="entity")
        private NamespacedKey entity;
        @JsonComments(value={@JsonComment(value="The base cooldown value for action."), @JsonComment(value="0 means that there is no cooldown."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="base_cooldown")
        private int baseCooldown;
        @JsonComments(value={@JsonComment(value="The increment of cooldown per each animal."), @JsonComment(value="0 means that there is no cooldown increment."), @JsonComment(value="Negative value decreases base cooldown value."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="animal_increment")
        private int incrementPerAnimal;
        @JsonComments(value={@JsonComment(value="The the maximal cooldown that can be applied."), @JsonComment(value="0 means that there is no cooldown limitation."), @JsonComment(value="Negative animal_increment makes this act as lowest limit."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="cooldown_limit")
        private int cooldownLimit;

        public CooldownEntry(NamespacedKey entity, int base, int increment, int max) {
            this.entity = entity;
            this.baseCooldown = base;
            this.incrementPerAnimal = increment;
            this.cooldownLimit = max;
        }

        public int getValue(long entityAmount) {
            if (this.incrementPerAnimal > 0) {
                long endValue = (long)this.baseCooldown + entityAmount * (long)this.incrementPerAnimal;
                return (int)Math.min((long)this.cooldownLimit, endValue);
            }
            if (this.incrementPerAnimal < 0) {
                long endValue = (long)this.baseCooldown + entityAmount * (long)this.incrementPerAnimal;
                return (int)Math.max((long)this.cooldownLimit, endValue);
            }
            return this.baseCooldown;
        }
    }
}

