/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.config.util;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import lv.id.bonne.animalpenpaper.config.annotations.JsonComment;
import lv.id.bonne.animalpenpaper.config.annotations.SerializeWithComments;

public class CommentGeneration {
    public static String writeWithComments(Gson gson, Object obj) throws IllegalAccessException {
        StringBuilder jsonWithComments = new StringBuilder();
        jsonWithComments.append("{\n");
        CommentGeneration.serializeObjectWithComments(obj, jsonWithComments, gson, 1);
        jsonWithComments.append("\n}");
        return jsonWithComments.toString();
    }

    private static void serializeObjectWithComments(Object obj, StringBuilder jsonWithComments, Gson gson, int indentLevel) throws IllegalAccessException {
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        String indent = "  ".repeat(indentLevel);
        boolean first = true;
        for (int i = 0; i < fields.length; ++i) {
            JsonComment[] comment;
            Expose expose;
            Field field = fields[i];
            if (!field.trySetAccessible() || (expose = field.getAnnotation(Expose.class)) != null && !expose.serialize()) continue;
            if (!first) {
                jsonWithComments.append(",");
                jsonWithComments.append("\n");
            }
            first = false;
            String jsonPropertyName = field.getName();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (serializedName != null) {
                jsonPropertyName = serializedName.value();
            }
            if ((comment = (JsonComment[])field.getDeclaredAnnotationsByType(JsonComment.class)) != null) {
                for (JsonComment jsonComment : comment) {
                    jsonWithComments.append(indent).append("// ").append(jsonComment.value()).append("\n");
                }
            }
            jsonWithComments.append(indent).append("\"").append(jsonPropertyName).append("\": ");
            Object fieldValue = field.get(obj);
            if (fieldValue != null) {
                if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    jsonWithComments.append("[\n");
                    CommentGeneration.serializeCollection(collection, jsonWithComments, gson, indentLevel + 1);
                    jsonWithComments.append(indent).append("]");
                    continue;
                }
                if (fieldValue instanceof Map) {
                    Map map = (Map)fieldValue;
                    jsonWithComments.append("{\n");
                    CommentGeneration.serializeMap(map, jsonWithComments, gson, indentLevel + 1);
                    jsonWithComments.append(indent).append("}");
                    continue;
                }
                if (CommentGeneration.isSerializableWithComments(fieldValue)) {
                    jsonWithComments.append("{\n");
                    CommentGeneration.serializeObjectWithComments(fieldValue, jsonWithComments, gson, indentLevel + 1);
                    jsonWithComments.append("\n");
                    jsonWithComments.append(indent).append("}");
                    continue;
                }
                if (CommentGeneration.hasTypeAdapter(gson, field)) {
                    jsonWithComments.append(gson.toJson(fieldValue));
                    continue;
                }
                jsonWithComments.append(gson.toJson(fieldValue));
                continue;
            }
            jsonWithComments.append("null");
        }
    }

    private static boolean hasTypeAdapter(Gson gson, Field field) {
        Type fieldType = field.getGenericType();
        try {
            gson.getAdapter(TypeToken.get((Type)fieldType));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean hasTypeAdapter(Gson gson, Object field) {
        try {
            gson.getAdapter(TypeToken.get(field.getClass()));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void serializeCollection(Collection<?> collection, StringBuilder jsonWithComments, Gson gson, int indentLevel) throws IllegalAccessException {
        String indent = "  ".repeat(indentLevel);
        int count = 0;
        for (Object item : collection) {
            jsonWithComments.append(indent);
            if (item instanceof Collection) {
                Collection collection2 = (Collection)item;
                jsonWithComments.append("[\n");
                CommentGeneration.serializeCollection(collection2, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append(indent).append("]");
            } else if (item instanceof Map) {
                Map map = (Map)item;
                jsonWithComments.append("{\n");
                CommentGeneration.serializeMap(map, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append(indent).append("}");
            } else if (CommentGeneration.isSerializableWithComments(item)) {
                jsonWithComments.append("{\n");
                CommentGeneration.serializeObjectWithComments(item, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append("\n");
                jsonWithComments.append(indent).append("}");
            } else if (CommentGeneration.hasTypeAdapter(gson, item)) {
                jsonWithComments.append(gson.toJson(item));
            } else {
                jsonWithComments.append(gson.toJson(item));
            }
            if (++count < collection.size()) {
                jsonWithComments.append(",");
            }
            jsonWithComments.append("\n");
        }
    }

    private static void serializeMap(Map<?, ?> map, StringBuilder jsonWithComments, Gson gson, int indentLevel) throws IllegalAccessException {
        String indent = "  ".repeat(indentLevel);
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            jsonWithComments.append(indent).append("\"").append(entry.getKey()).append("\": ");
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                jsonWithComments.append("[\n");
                CommentGeneration.serializeCollection(collection, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append(indent).append("]");
            } else if (value instanceof Map) {
                Map map2 = (Map)value;
                jsonWithComments.append("{\n");
                CommentGeneration.serializeMap(map2, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append(indent).append("}");
            } else if (CommentGeneration.isSerializableWithComments(value)) {
                jsonWithComments.append("{\n");
                CommentGeneration.serializeObjectWithComments(value, jsonWithComments, gson, indentLevel + 1);
                jsonWithComments.append("\n");
                jsonWithComments.append(indent).append("}");
            } else if (CommentGeneration.hasTypeAdapter(gson, value)) {
                jsonWithComments.append(gson.toJson(value));
            } else {
                jsonWithComments.append(gson.toJson(value));
            }
            if (++count < map.size()) {
                jsonWithComments.append(",");
            }
            jsonWithComments.append("\n");
        }
    }

    private static boolean isSerializableWithComments(Object obj) {
        return obj.getClass().isAnnotationPresent(SerializeWithComments.class);
    }
}

