/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.config.adapters.EntitySnapshotTypeAdapter;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class AnimalDataType
implements PersistentDataType<String, AnimalData> {
    public static final AnimalDataType INSTANCE = new AnimalDataType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EntitySnapshot.class, (Object)new EntitySnapshotTypeAdapter()).create();

    @NotNull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @NotNull
    public Class<AnimalData> getComplexType() {
        return AnimalData.class;
    }

    @NotNull
    public String toPrimitive(@NotNull AnimalData complex, @NotNull PersistentDataAdapterContext context) {
        try {
            return GSON.toJson((Object)complex);
        }
        catch (Exception e) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to serialize AnimalData: " + e.getMessage());
            return "{\"version\":1,\"cooldowns\":{}, \"variants\":[]}";
        }
    }

    @NotNull
    public AnimalData fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
        try {
            AnimalData data = (AnimalData)GSON.fromJson(primitive, AnimalData.class);
            if (data.version == 0) {
                data.version = 1;
            }
            return data;
        }
        catch (JsonSyntaxException e) {
            AnimalPenPlugin.getInstance().getLogger().warning("Failed to deserialize AnimalData: " + e.getMessage());
            AnimalPenPlugin.getInstance().getLogger().warning("Raw JSON: " + primitive);
            return new AnimalData(null, null, 0L);
        }
    }
}

