/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.menu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.managers.AnimalPenManager;
import lv.id.bonne.animalpenpaper.managers.AquariumManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AnimalPenCreativeMenu
implements Listener,
InventoryHolder {
    private final Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)36, (Component)AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.title"));

    public AnimalPenCreativeMenu() {
        List<ItemStack> customItems = List.of(AnimalPenManager.createEmptyAnimalCage(), AnimalPenManager.createAnimalPen("animal_pen_acacia"), AnimalPenManager.createAnimalPen("animal_pen_bamboo"), AnimalPenManager.createAnimalPen("animal_pen_birch"), AnimalPenManager.createAnimalPen("animal_pen_cherry"), AnimalPenManager.createAnimalPen("animal_pen_crimson"), AnimalPenManager.createAnimalPen("animal_pen_dark_oak"), AnimalPenManager.createAnimalPen("animal_pen_jungle"), AnimalPenManager.createAnimalPen("animal_pen_mangrove"), AnimalPenManager.createAnimalPen("animal_pen_oak"), AnimalPenManager.createAnimalPen("animal_pen_pale_oak"), AnimalPenManager.createAnimalPen("animal_pen_spruce"), AnimalPenManager.createAnimalPen("animal_pen_warped"), AquariumManager.createEmptyWaterContainer(), AquariumManager.createAquarium());
        for (int i = 0; i < customItems.size(); ++i) {
            this.inventory.setItem(i, customItems.get(i));
        }
        this.setupUtilityButtons(this.inventory);
        AnimalPenPlugin.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)AnimalPenPlugin.getInstance());
    }

    public void openMenu(Player player) {
        player.openInventory(this.inventory);
    }

    private void setupUtilityButtons(Inventory inventory) {
        ItemStack closeButton = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeButton.getItemMeta();
        closeMeta.displayName(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.button.close.title").color((TextColor)NamedTextColor.RED));
        closeButton.setItemMeta(closeMeta);
        inventory.setItem(32, closeButton);
        ItemStack infoButton = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = infoButton.getItemMeta();
        infoMeta.displayName(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.button.info.title"));
        infoMeta.lore(Arrays.asList(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.button.info.tip.line1"), AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.button.info.tip.line2"), AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.button.info.tip.line3")));
        infoButton.setItemMeta(infoMeta);
        inventory.setItem(30, infoButton);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getInventory().getHolder() != this) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 32) {
            player.closeInventory();
            return;
        }
        if (slot >= 27) {
            return;
        }
        ItemStack itemToGive = clickedItem.clone();
        if (event.isShiftClick()) {
            if (player.getGameMode() != GameMode.CREATIVE) {
                player.sendMessage(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.error.creative"));
                return;
            }
            itemToGive.setAmount(itemToGive.getMaxStackSize());
        } else {
            itemToGive.setAmount(1);
        }
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{itemToGive});
        if (!leftover.isEmpty()) {
            leftover.values().forEach(item -> player.getWorld().dropItem(player.getLocation(), item));
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.warn.full-inventory"));
        } else {
            Component itemName = clickedItem.getItemMeta().hasDisplayName() ? clickedItem.getItemMeta().displayName() : Component.text((String)clickedItem.getType().name().replace("_", " ").toLowerCase());
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("menu.animal_pen.creative.success.give", itemToGive.getAmount(), itemName));
        }
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
        for (HumanEntity viewer : this.inventory.getViewers()) {
            viewer.closeInventory();
        }
        this.inventory.clear();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

