/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpenpaper.listeners;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import java.util.Iterator;
import java.util.List;
import lv.id.bonne.animalpenpaper.AnimalPenPlugin;
import lv.id.bonne.animalpenpaper.data.AnimalData;
import lv.id.bonne.animalpenpaper.managers.AnimalPenManager;
import lv.id.bonne.animalpenpaper.util.StyleUtil;
import lv.id.bonne.animalpenpaper.util.Utils;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.OwnableEntity;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AnimalCageListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onEntityCatch(PlayerInteractEntityEvent event) {
        OwnableEntity ownable;
        Tameable tameable;
        Player player = event.getPlayer();
        if (event.getPlayer().isSneaking()) {
            return;
        }
        Entity entity = event.getRightClicked();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AnimalPenManager.isAnimalCage(item)) {
            return;
        }
        event.setCancelled(true);
        if (!(entity instanceof Animals)) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.not_animal"));
            return;
        }
        Animals animal = (Animals)entity;
        if (animal.isDead() || !animal.hasAI()) {
            return;
        }
        if (!animal.isAdult()) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.baby"));
            return;
        }
        if (entity instanceof Tameable && (tameable = (Tameable)entity).getOwnerUniqueId() != null || entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwner() != null) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.tame"));
            return;
        }
        if (AnimalPenPlugin.configuration().isBlocked(animal.getType())) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.blocked"));
            return;
        }
        EntityType entityType = animal.getType();
        AnimalData storedData = AnimalPenManager.getAnimalData(item);
        if (storedData != null && storedData.entityType() != entityType) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.wrong"));
            return;
        }
        storedData = new AnimalData(entityType, entity.createSnapshot(), 0L);
        long maxAmount = AnimalPenPlugin.configuration().getMaximalAnimalCount();
        if (maxAmount > 0L && storedData.entityCount() + 1L > maxAmount) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.full"));
            return;
        }
        AnimalPenManager.addAnimal(item, entityType, entity.createSnapshot(), 1L);
        entity.remove();
        player.swingMainHand();
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.captured", Component.translatable((String)entity.getType().translationKey())));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityRelease(PlayerInteractEvent event) {
        boolean updateSnapshot;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AnimalPenManager.isAnimalCage(item)) {
            return;
        }
        event.setCancelled(true);
        AnimalData storedData = AnimalPenManager.getAnimalData(item);
        if (storedData == null) {
            return;
        }
        EntityType entityType = storedData.entityType();
        Location spawnLoc = block.getLocation().add(0.5, 1.0, 0.5);
        World world = player.getWorld();
        Entity entity = storedData.entitySnapshot() != null ? storedData.entitySnapshot().createEntity(spawnLoc) : world.spawnEntity(spawnLoc, entityType, CreatureSpawnEvent.SpawnReason.CUSTOM);
        boolean bl = updateSnapshot = storedData.getAppliedFlag().isPresent() || storedData.getAppliedMaterial().isPresent();
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            storedData.getAppliedFlag().ifPresent(shared -> {
                sheep.setSheared(shared.booleanValue());
                storedData.setAppliedFlag(null);
            });
            storedData.getAppliedMaterial().ifPresent(dye -> {
                sheep.setColor(Utils.getDyeColor(dye));
                storedData.setAppliedMaterial(null);
            });
        } else if (entity instanceof MushroomCow) {
            MushroomCow cow = (MushroomCow)entity;
            storedData.getAppliedMaterial().ifPresent(dye -> {
                SuspiciousEffectEntry suspiciousEffectEntry = Utils.FLOWER_EFFECTS.get(dye);
                if (suspiciousEffectEntry != null) {
                    cow.addEffectToNextStew(suspiciousEffectEntry, true);
                }
                storedData.setAppliedMaterial(null);
            });
        }
        if (updateSnapshot || storedData.entitySnapshot() == null) {
            storedData.setEntitySnapshot(entity.createSnapshot());
        }
        if (!(entity instanceof Animals)) {
            return;
        }
        AnimalPenManager.removeAnimal(item, 1L);
        player.swingMainHand();
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.released", Component.translatable((String)entity.getType().translationKey())));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInteractWithPenWithAnimalCage(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AnimalPenManager.isAnimalCage(item)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!AnimalPenManager.isAnimalPen(block)) {
            return;
        }
        event.setCancelled(true);
        AnimalData penData = AnimalPenManager.getAnimalData(block);
        AnimalData itemData = AnimalPenManager.getAnimalData(item);
        if (itemData == null && penData == null) {
            return;
        }
        if (penData == null) {
            AnimalPenManager.setAnimalPenData(block, itemData);
            item.setAmount(-1);
            player.getInventory().setItem(event.getHand(), item);
            player.swingMainHand();
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.inserted"));
            return;
        }
        if (itemData == null) {
            if (!player.isSneaking() || penData.entityCount() < 2L) {
                return;
            }
            itemData = new AnimalData(penData.entityType(), penData.entitySnapshot(), penData.entityCount() / 2L);
            itemData.getCooldowns().putAll(penData.getCooldowns());
            itemData.setScutes(penData.scutes() / 2);
            penData.setScutes(penData.scutes() - itemData.scutes());
            penData.getAppliedMaterial().ifPresent(itemData::setAppliedMaterial);
            penData.getAppliedFlag().ifPresent(itemData::setAppliedFlag);
            AnimalPenManager.setAnimalCageData(item, itemData);
            penData.reduceEntityCount(itemData.entityCount());
            AnimalPenManager.setAnimalPenData(block, penData);
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.withdrawn", itemData.entityCount()));
            return;
        }
        if (penData.entityType() != itemData.entityType()) {
            return;
        }
        penData.addEntityCount(itemData.entityCount());
        itemData.getCooldowns().forEach((key, value) -> penData.getCooldowns().merge((Material)key, (Integer)value, Math::max));
        itemData.getCooldowns().clear();
        penData.setScutes(penData.scutes() + itemData.scutes());
        itemData.setScutes(0);
        int maxStoredVariants = AnimalPenPlugin.configuration().getMaxStoredVariants();
        long amount = itemData.entityCount();
        if (itemData.entityCount() > 1L && penData.getVariants().size() + itemData.getVariants().size() > maxStoredVariants) {
            player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.error.too_many_variants"));
            penData.reduceEntityCount(1L);
            itemData.setEntityCount(1L);
            AnimalPenManager.setAnimalCageData(item, itemData);
            --amount;
        } else {
            Iterator<EntitySnapshot> iterator = itemData.getVariants().iterator();
            for (int size = penData.getVariants().size(); size < maxStoredVariants && iterator.hasNext(); ++size) {
                penData.addVariant(iterator.next());
            }
            itemData.getVariants().clear();
            AnimalPenManager.setAnimalCageData(item, null);
        }
        AnimalPenManager.setAnimalPenData(block, penData);
        player.sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.deposited", amount));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteractWithPenWithEmptyHand(PlayerInteractEvent event) {
        if (event.getItem() != null && !event.getItem().getType().isAir() || event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !event.getPlayer().isSneaking()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!AnimalPenManager.isAnimalPen(block)) {
            return;
        }
        event.setCancelled(true);
        AnimalData penData = AnimalPenManager.getAnimalData(block);
        if (penData == null) {
            return;
        }
        ItemStack itemStack = AnimalPenManager.createEmptyAnimalCage();
        AnimalPenManager.setAnimalCageData(itemStack, penData);
        AnimalPenManager.clearBlockData(block, true);
        event.getPlayer().getInventory().setItem(event.getHand() == null ? EquipmentSlot.HAND : event.getHand(), itemStack);
        event.getPlayer().sendMessage(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.taken"));
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onProtectionOfUsage(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (!AnimalPenManager.isAnimalCage(item)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onProtectionOfUsage(PlayerInteractEvent event) {
        if (!AnimalPenManager.isAnimalCage(event.getItem())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemCraft(CraftItemEvent event) {
        ItemStack result = event.getRecipe().getResult();
        if (!result.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
            return;
        }
        CustomModelData data = (CustomModelData)result.getData(DataComponentTypes.CUSTOM_MODEL_DATA);
        if (data.strings().contains("animal_pen:animal_cage")) {
            ItemMeta itemMeta = result.getItemMeta();
            itemMeta.displayName(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.name").style(StyleUtil.WHITE));
            itemMeta.lore(List.of(AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line1"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line2"), AnimalPenPlugin.translations().getTranslatable("item.animal_pen.animal_cage.catch_tip.line3")));
            result.setItemMeta(itemMeta);
            event.setCurrentItem(result);
        }
    }
}

