/*
 * Decompiled with CFR 0.152.
 */
package com.enbeon.books.config;

import com.enbeon.books.EnbeonsCustomBooks;
import com.enbeon.books.EnbeonsCustomBooksClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class BooksConfig {
    static final Path configLocation = FabricLoader.getInstance().getConfigDir().resolve("enbeons-custom-books-config.json");
    static final ArrayList<String> defaultPrecedence = new ArrayList<String>(List.of("mending", "frost_walker", "soul_speed", "swift_sneak", "wind_burst", "binding_curse", "vanishing_curse", "channeling", "infinity", "silk_touch", "thorns", "aqua_affinity", "blast_protection", "breach", "depth_strider", "fire_aspect", "flame", "fortune", "impaling", "looting", "luck_of_the_sea", "lure", "multishot", "punch", "respiration", "riptide", "sweeping_edge", "bane_of_arthropods", "density", "feather_falling", "fire_protection", "knockback", "loyalty", "projectile_protection", "quick_charge", "smite", "unbreaking", "efficiency", "piercing", "power", "protection", "sharpness"));
    static HashMap<class_2561, String> texts = new HashMap();
    boolean modEnabled = true;
    boolean mendingAnimated = true;
    boolean oldUnbreaking = false;
    ArrayList<String> enchantmentPrecedence = defaultPrecedence;

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isMendingAnimated() {
        return this.mendingAnimated;
    }

    public boolean isOldUnbreaking() {
        return this.oldUnbreaking;
    }

    public ArrayList<String> getEnchantmentPrecedence() {
        return this.enchantmentPrecedence;
    }

    public static void saveConfig() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.writeString(configLocation, (CharSequence)gson.toJson((Object)EnbeonsCustomBooksClient.CONFIG), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            EnbeonsCustomBooks.LOGGER.warn("Failed to save config");
        }
    }

    public static void loadConfig() {
        if (!Files.exists(configLocation, new LinkOption[0])) {
            BooksConfig.saveConfig();
            return;
        }
        try {
            Gson gson = new Gson();
            BooksConfig newConfig = (BooksConfig)gson.fromJson(Files.readString(configLocation), BooksConfig.class);
            boolean configChanged = false;
            for (int i = 0; i < defaultPrecedence.size(); ++i) {
                String enchantmentName = defaultPrecedence.get(i);
                if (newConfig.enchantmentPrecedence.contains(enchantmentName)) continue;
                configChanged = true;
                newConfig.enchantmentPrecedence.add(i, enchantmentName);
            }
            EnbeonsCustomBooksClient.CONFIG = newConfig;
            if (configChanged) {
                BooksConfig.saveConfig();
            }
        }
        catch (IOException e) {
            EnbeonsCustomBooks.LOGGER.warn("Failed to load config");
        }
    }

    public static ArrayList<class_2561> decodePrecedence(ArrayList<String> input) {
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        for (String enchantmentName : input) {
            Object keyBuilder = "enchantment.";
            keyBuilder = (String)keyBuilder + (String)(enchantmentName.contains(":") ? enchantmentName.replace(':', '.') : "minecraft." + enchantmentName);
            class_5250 enchantmentText = class_2561.method_43471((String)keyBuilder);
            output.add((class_2561)enchantmentText);
            texts.put((class_2561)enchantmentText, enchantmentName);
        }
        return output;
    }

    public static ArrayList<String> encodePrecedence(List<class_2561> input) {
        ArrayList<String> output = new ArrayList<String>();
        for (class_2561 enchantmentText : input) {
            String enchantmentName = texts.get(enchantmentText);
            if (enchantmentName == null) continue;
            output.add(enchantmentName);
        }
        return output;
    }
}

