/*
 * Decompiled with CFR 0.152.
 */
package cn.qiuye.betterae2.datagen.providers;

import cn.qiuye.betterae2.datagen.providers.langs.ItemAndBlockLanguage;
import cn.qiuye.betterae2.datagen.providers.langs.TooltipLanguage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.MethodsReturnNonnullByDefault;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class LocalizationProvider
implements DataProvider {
    private static final Map<String, Language> LANGUAGES = new TreeMap<String, Language>();
    private final DataGenerator generator;

    public LocalizationProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public static void add(String id, String chineseName, String englishName) {
        if (LANGUAGES.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate language id: " + id);
        }
        LANGUAGES.put(id, new Language(chineseName, englishName));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cached) {
        ItemAndBlockLanguage.init();
        TooltipLanguage.init();
        return CompletableFuture.allOf(this.save(cached, LangCode.EN_US), this.save(cached, LangCode.ZH_CN));
    }

    private CompletableFuture<?> save(CachedOutput cache, LangCode code) {
        Path path = this.buildLanguageFilePath(code);
        JsonObject json = new JsonObject();
        this.getProcessingStrategy(code).process(json);
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    private LanguageProcessingStrategy getProcessingStrategy(LangCode code) {
        return json -> LANGUAGES.forEach((key, language) -> json.addProperty(key, code.getValue((Language)language)));
    }

    private Path buildLanguageFilePath(LangCode code) {
        return this.generator.getPackOutput().m_245114_().resolve(String.format("assets/bae2/lang/%s.json", code.name().toLowerCase()));
    }

    public String m_6055_() {
        return "Localization (en,zh_cn)";
    }

    private record Language(String cn, String en) {
    }

    static enum LangCode {
        EN_US(Language::en),
        ZH_CN(Language::cn);

        private final Function<Language, String> valueExtractor;

        private LangCode(Function<Language, String> valueExtractor) {
            this.valueExtractor = valueExtractor;
        }

        String getValue(Language language) {
            return this.valueExtractor.apply(language);
        }
    }

    @FunctionalInterface
    public static interface LanguageProcessingStrategy {
        public void process(JsonObject var1);
    }
}

