/*
 * Decompiled with CFR 0.152.
 */
package cn.qiuye.betterae2.mixin.eae2;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.storage.IOPortBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.util.inv.AppEngInternalInventory;
import cn.qiuye.betterae2.common.definition.BAE2Items;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.tileentities.TileExIOPort;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TileExIOPort.class})
public class TileExIOPortMixin
extends IOPortBlockEntity
implements IUpgradeableObject {
    @Mutable
    @Final
    @Shadow(remap=false)
    private AppEngInternalInventory inputCells;
    @Final
    @Shadow(remap=false)
    private static int NUMBER_OF_CELL_SLOTS;

    public TileExIOPortMixin(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileExIOPort.class, TileExIOPort::new, (Block)EPPItemAndBlock.EX_IO_PORT), pos, blockState);
        Ae2Reflect.setIOPortUpgrade((IOPortBlockEntity)this, (IUpgradeInventory)UpgradeInventories.forMachine((ItemLike)EPPItemAndBlock.EX_IO_PORT, (int)5, () -> ((TileExIOPortMixin)this).saveChanges()));
        this.inputCells = Ae2Reflect.getInputCellInv((IOPortBlockEntity)this);
    }

    @Overwrite(remap=false)
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getMainNode().isActive()) {
            return TickRateModulation.IDLE;
        }
        TickRateModulation ret = TickRateModulation.SLEEP;
        int speedUpgrades = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        int superSpeedUpgrades = this.getUpgrades().getInstalledUpgrades(BAE2Items.SUPER_SPEED_CARD);
        long itemsToMove = TileExIOPortMixin.betterae2$getItemsToMove(speedUpgrades, superSpeedUpgrades);
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return TickRateModulation.IDLE;
        }
        for (int x = 0; x < NUMBER_OF_CELL_SLOTS; ++x) {
            ItemStack cell = this.inputCells.getStackInSlot(x);
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)cell, null);
            if (cellInv == null) {
                Ae2Reflect.moveSlotInCell((IOPortBlockEntity)this, (int)x);
                continue;
            }
            if (itemsToMove > 0L) {
                ret = (itemsToMove = Ae2Reflect.transferItemsFromCell((IOPortBlockEntity)this, (IGrid)grid, (StorageCell)cellInv, (long)itemsToMove)) > 0L ? TickRateModulation.IDLE : TickRateModulation.URGENT;
            }
            if (itemsToMove <= 0L || !this.matchesFullnessMode(cellInv) || !Ae2Reflect.moveSlotInCell((IOPortBlockEntity)this, (int)x)) continue;
            ret = TickRateModulation.URGENT;
        }
        return ret;
    }

    @Unique
    private static long betterae2$getItemsToMove(int speedUpgrades, int superSpeedUpgrades) {
        int result = 1;
        int speed = 16;
        if (speedUpgrades > 0 && superSpeedUpgrades == 0) {
            switch (speedUpgrades) {
                case 1: {
                    result = 2;
                    break;
                }
                case 2: {
                    result = 3;
                    break;
                }
                case 3: {
                    result = 4;
                    break;
                }
                case 4: {
                    result = 5;
                    break;
                }
                case 5: {
                    result = 6;
                }
            }
        } else if (superSpeedUpgrades > 0 && speedUpgrades == 0) {
            switch (superSpeedUpgrades) {
                case 1: {
                    result = 8;
                    break;
                }
                case 2: {
                    result = 9;
                    break;
                }
                case 3: {
                    result = 10;
                    break;
                }
                case 4: {
                    result = 11;
                    break;
                }
                case 5: {
                    result = 12;
                }
            }
        } else if (speedUpgrades > 0 && superSpeedUpgrades > 0) {
            switch (speedUpgrades) {
                case 1: {
                    result = 4;
                    break;
                }
                case 2: {
                    result = 5;
                    break;
                }
                case 3: {
                    result = 6;
                    break;
                }
                case 4: {
                    result = 7;
                    break;
                }
                case 5: {
                    result = 8;
                }
            }
        }
        long itemsToMove = (long)Math.pow(speed, result);
        return itemsToMove;
    }
}

