/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeClientRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.BlockBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class StorageBlockBase
extends BlockBase
implements IStorageBlock,
ISneakItemInteractionBlock,
EntityBlock {
    public static final BooleanProperty TICKING = BooleanProperty.create((String)"ticking");
    protected final Supplier<Integer> numberOfInventorySlotsSupplier;
    protected final Supplier<Integer> numberOfUpgradeSlotsSupplier;

    protected StorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties);
        this.numberOfInventorySlotsSupplier = numberOfInventorySlotsSupplier;
        this.numberOfUpgradeSlotsSupplier = numberOfUpgradeSlotsSupplier;
    }

    public abstract StorageBlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typePassedIn, BlockEntityType<E> typeExpected, BlockEntityTicker<? super E> blockEntityTicker) {
        return typeExpected == typePassedIn ? blockEntityTicker : null;
    }

    protected void renderUpgrades(Level level, RandomSource rand, BlockPos pos, Direction facing, RenderInfo renderInfo, BlockState storageBlockState) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        renderInfo.getUpgradeClientData().forEach((type, data) -> UpgradeClientRegistry.getUpgradeClientTickHandler((UpgradeClientDataType)type).ifPresent(renderer -> {
            Block patt0$temp = storageBlockState.getBlock();
            if (patt0$temp instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)patt0$temp;
                storageBlock.clientTickUpgrade((IUpgradeClientTickHandler)renderer, level, rand, pos, facing, (UpgradeClientDataType<?>)type, (IUpgradeClientData)data, storageBlockState, storageBlock);
            }
        }));
    }

    protected Vector3f getMiddleFacePoint(BlockState state, BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        point.add(0.0f, 0.0f, 0.6f);
        point.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        point.rotate((Quaternionfc)facing.getRotation());
        point.add((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
        return point;
    }

    private <T extends IUpgradeClientData> void clientTickUpgrade(IUpgradeClientTickHandler<T> renderer, Level level, RandomSource rand, BlockPos pos, Direction facing, UpgradeClientDataType<?> type, IUpgradeClientData data, BlockState state, StorageBlockBase storageBlock) {
        type.cast(data).ifPresent(clientData -> renderer.onClientTick(level, rand, vector -> storageBlock.getMiddleFacePoint(state, pos, facing, (Vector3f)vector), clientData));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> this.tryToPickup(level, itemEntity, be.getStorageWrapper()));
        }
    }

    protected void tryToPickup(Level level, ItemEntity itemEntity, IStorageWrapper w) {
        ItemStack remainingStack = itemEntity.getItem().copy();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)w.getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainingStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.isClientSide && Boolean.TRUE.equals(state.getValue((Property)TICKING)) ? StorageBlockBase.createTickerHelper(blockEntityType, this.getBlockEntityType(), (l, blockPos, blockState, storageBlockEntity) -> StorageBlockEntity.serverTick(l, blockPos, storageBlockEntity)) : null;
    }

    protected abstract BlockEntityType<? extends StorageBlockEntity> getBlockEntityType();

    @Override
    public int getNumberOfInventorySlots() {
        return this.numberOfInventorySlotsSupplier.get();
    }

    @Override
    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlotsSupplier.get();
    }

    @Override
    public void setTicking(Level level, BlockPos pos, BlockState currentState, boolean ticking) {
        level.setBlockAndUpdate(pos, (BlockState)currentState.setValue((Property)TICKING, (Comparable)Boolean.valueOf(ticking)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)be.getStorageWrapper().getInventoryForInputOutput())).orElse(0);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(b -> {
                b.removeFromController();
                if (b.shouldDropContents()) {
                    b.dropContents();
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            });
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
        return state;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> {
            RenderInfo renderInfo = be.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(level, rand, pos, this.getFacing(state), renderInfo, state);
        });
    }

    public VerticalFacing getVerticalFacing(BlockState state) {
        Direction facing = this.getFacing(state);
        if (facing == Direction.UP) {
            return VerticalFacing.UP;
        }
        if (facing == Direction.DOWN) {
            return VerticalFacing.DOWN;
        }
        return VerticalFacing.NO;
    }

    public Direction getHorizontalDirection(BlockState state) {
        Direction facing = this.getFacing(state);
        if (facing == Direction.UP) {
            return Direction.NORTH;
        }
        if (facing == Direction.DOWN) {
            return Direction.SOUTH;
        }
        return facing;
    }

    public abstract Direction getFacing(BlockState var1);

    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return displayItems.size();
    }

    public boolean hasFixedIndexDisplayItems() {
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> be.onNeighborChange(neighbor));
    }

    protected InteractionResult tryAddUpgrade(Player player, StorageBlockEntity b, ItemStack itemInHand, Direction facing, BlockHitResult hitResult) {
        if (hitResult.getDirection() != facing) {
            return InteractionResult.PASS;
        }
        return this.tryAddSingleUpgrade(player, b, itemInHand);
    }

    public InteractionResult tryAddSingleUpgrade(Player player, StorageBlockEntity b, ItemStack itemInHand) {
        return StorageBlockBase.tryAddSingleUpgrade(player, itemInHand, b.getStorageWrapper());
    }

    public static InteractionResult tryAddSingleUpgrade(Player player, ItemStack itemInHand, IStorageWrapper storageWrapper) {
        Item item = itemInHand.getItem();
        if (item instanceof UpgradeItemBase) {
            UpgradeItemBase upgradeItem = (UpgradeItemBase)item;
            if (itemInHand.is(ModItems.STORAGE_UPGRADE_TAG)) {
                if (player.level().isClientSide) {
                    return InteractionResult.PASS;
                }
                UpgradeHandler upgradeHandler = storageWrapper.getUpgradeHandler();
                if (upgradeItem.canAddUpgradeTo(storageWrapper, itemInHand, true, player.level().isClientSide()).successful() && InventoryHelper.insertIntoInventory((ItemStack)itemInHand, (IItemHandler)upgradeHandler, (boolean)true).getCount() != itemInHand.getCount()) {
                    InventoryHelper.insertIntoInventory((ItemStack)itemInHand.copyWithCount(1), (IItemHandler)upgradeHandler, (boolean)false);
                    itemInHand.shrink(1);
                    return InteractionResult.SUCCESS.heldItemTransformedTo(itemInHand.isEmpty() ? ItemStack.EMPTY : itemInHand);
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean trySneakItemInteraction(Player player, InteractionHand hand, BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemInHand) {
        if (level.isClientSide() || hitVec.getDirection() != this.getFacing(state)) {
            return false;
        }
        return this.tryFillUpgrades(player, hand, level, pos, itemInHand);
    }

    public boolean tryFillUpgrades(Player player, InteractionHand hand, Level level, BlockPos pos, ItemStack itemInHand) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(b -> {
            boolean result = false;
            while (!itemInHand.isEmpty() && this.tryAddSingleUpgrade(player, (StorageBlockEntity)b, itemInHand).consumesAction()) {
                result = true;
            }
            return result;
        }).orElse(false);
    }

    public List<BlockPos> getNeighborPos(BlockState state, BlockPos origin, Direction facing) {
        return List.of(origin.relative(facing));
    }
}

