/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ContentsFilteredItemHandler;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.network.StorageOpennessPayload;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public abstract class StorageBlockEntity
extends BlockEntity
implements IControllableStorage,
ILinkable,
ILockable,
Nameable,
ITierDisplay,
IUpgradeDisplay {
    public static final String STORAGE_WRAPPER_TAG = "storageWrapper";
    public static final String UPDATE_BLOCK_RENDER_TAG = "updateBlockRender";
    private final StorageWrapper storageWrapper;
    @Nullable
    protected Component displayName = null;
    private boolean updateBlockRender = false;
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean isBeingUpgraded = false;
    private boolean isDroppingContents = false;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private IItemHandler cachedFailedInsertItemHandler;
    private boolean locked = false;
    private boolean showLock = true;
    private boolean showTier = true;
    private boolean showUpgrades = false;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;
    private final Map<DisplayTintKey, Integer> displayItemTints = new HashMap<DisplayTintKey, Integer>();

    public abstract SophisticatedOpenersCounter getOpenersCounter();

    protected StorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(blockEntityType, pos, state);
        this.storageWrapper = new StorageWrapper(() -> () -> ((StorageBlockEntity)this).setChanged(), () -> {
            if (this.level != null && !this.level.isClientSide) {
                WorldHelper.notifyBlockUpdate((BlockEntity)this);
            }
        }, () -> {
            if (this.level != null && !this.level.isClientSide) {
                this.setChanged();
                WorldHelper.notifyBlockUpdate((BlockEntity)this);
            }
        }, this instanceof BarrelBlockEntity ? 4 : 1, this instanceof ICountDisplay || this instanceof IFillLevelDisplay){

            public Optional<UUID> getContentsUuid() {
                if (this.contentsUuid == null) {
                    this.contentsUuid = UUID.randomUUID();
                    this.save();
                }
                return Optional.of(this.contentsUuid);
            }

            public ItemStack getWrappedStorageStack() {
                BlockPos pos = StorageBlockEntity.this.getBlockPos();
                BlockState state = StorageBlockEntity.this.getBlockState();
                return StorageBlockEntity.this.addWrappedStorageStackData(state.getBlock().getCloneItemStack((LevelReader)StorageBlockEntity.this.getLevel(), pos, state, true, null), state);
            }

            @Override
            protected void onUpgradeRefresh() {
                Block block;
                if (StorageBlockEntity.this.canRefreshUpgrades() && (block = StorageBlockEntity.this.getBlockState().getBlock()) instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    storageBlock.setTicking(StorageBlockEntity.this.level, StorageBlockEntity.this.getBlockPos(), StorageBlockEntity.this.getBlockState(), !StorageBlockEntity.this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
                }
            }

            @Override
            public int getDefaultNumberOfInventorySlots() {
                Block block = StorageBlockEntity.this.getBlockState().getBlock();
                if (block instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    return storageBlock.getNumberOfInventorySlots();
                }
                return 0;
            }

            @Override
            protected boolean isAllowedInStorage(ItemStack stack) {
                return StorageBlockEntity.this.isAllowedInStorage(stack);
            }

            @Override
            public int getDefaultNumberOfUpgradeSlots() {
                Block block = StorageBlockEntity.this.getBlockState().getBlock();
                if (block instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    return storageBlock.getNumberOfUpgradeSlots();
                }
                return 0;
            }

            public int getBaseStackSizeMultiplier() {
                int n;
                Block block = StorageBlockEntity.this.getBlockState().getBlock();
                if (block instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    n = storageBlock.getBaseStackSizeMultiplier();
                } else {
                    n = super.getBaseStackSizeMultiplier();
                }
                return n;
            }

            public String getStorageType() {
                return StorageBlockEntity.this.getStorageType();
            }

            public Component getDisplayName() {
                return StorageBlockEntity.this.getDisplayName();
            }

            @Override
            protected boolean emptyInventorySlotsAcceptItems() {
                return !StorageBlockEntity.this.locked || StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
            }

            @Override
            public ITrackedContentsItemHandler getInventoryForInputOutput() {
                if (StorageBlockEntity.this.locked && StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
                    if (StorageBlockEntity.this.contentsFilteredItemHandler == null) {
                        StorageBlockEntity.this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(() -> super.getInventoryForInputOutput(), () -> StorageBlockEntity.this.getStorageWrapper().getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)StorageBlockEntity.this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
                    }
                    return StorageBlockEntity.this.contentsFilteredItemHandler;
                }
                return super.getInventoryForInputOutput();
            }
        };
        this.storageWrapper.setUpgradeCachesInvalidatedHandler(this::onUpgradeCachesInvalidated);
    }

    protected boolean canRefreshUpgrades() {
        return !this.isDroppingContents && this.level != null && !this.level.isClientSide;
    }

    protected ItemStack addWrappedStorageStackData(ItemStack cloneItemStack, BlockState state) {
        return cloneItemStack;
    }

    protected abstract String getStorageType();

    protected void onUpgradeCachesInvalidated() {
        this.invalidateCapabilities();
    }

    public boolean isOpen() {
        return this.getOpenersCounter().getOpenerCount() > 0;
    }

    public Component getCustomName() {
        return this.displayName;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveStorageWrapper(tag);
        this.saveSynchronizedData(tag);
        if (this.isLinkedToController) {
            tag.putBoolean("isLinkedToController", this.isLinkedToController);
        }
    }

    private void saveStorageWrapper(CompoundTag tag) {
        tag.put(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.save(new CompoundTag()));
    }

    private void saveStorageWrapperClientData(CompoundTag tag) {
        tag.put(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.saveData(new CompoundTag()));
    }

    protected void saveSynchronizedData(CompoundTag tag) {
        if (this.displayName != null) {
            tag.putString("displayName", Component.Serializer.toJson((Component)this.displayName, (HolderLookup.Provider)this.level.registryAccess()));
        }
        if (this.updateBlockRender) {
            tag.putBoolean(UPDATE_BLOCK_RENDER_TAG, true);
        }
        this.updateBlockRender = false;
        if (this.locked) {
            tag.putBoolean("locked", this.locked);
        }
        if (!this.showLock) {
            tag.putBoolean("showLock", this.showLock);
        }
        if (!this.showTier) {
            tag.putBoolean("showTier", this.showTier);
        }
        if (this.showUpgrades) {
            tag.putBoolean("showUpgrades", this.showUpgrades);
        }
        this.saveControllerPos(tag);
    }

    public void startOpen(Player player) {
        if (this.level == null || this.level.isClientSide() || this.remove || player.isSpectator()) {
            return;
        }
        this.getOpenersCounter().incrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        this.sendOpenness();
    }

    public void stopOpen(Player player) {
        if (this.level == null || this.level.isClientSide() || this.remove || player.isSpectator()) {
            return;
        }
        this.getOpenersCounter().decrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        this.sendOpenness();
    }

    public void recheckOpen() {
        if (!this.remove && this.level != null) {
            int countBeforeCheck = this.getOpenersCounter().getOpenerCount();
            this.getOpenersCounter().recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
            int countAfterCheck = this.getOpenersCounter().getOpenerCount();
            if (countBeforeCheck != countAfterCheck && (countBeforeCheck == 0 || countAfterCheck == 0)) {
                this.sendOpenness();
            }
        }
    }

    private void sendOpenness() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPos = this.level.getChunkAt(this.getBlockPos()).getPos();
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new StorageOpennessPayload(this.getBlockPos(), this.getOpenersCounter().getOpenerCount() > 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Block block;
        if (this.level == null || !((block = state.getBlock()) instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        Vec3i vec3i = storageBlock.getFacing(state).getUnitVec3i();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadStorageWrapper(tag);
        this.loadSynchronizedData(tag, registries);
        this.isLinkedToController = NBTHelper.getBoolean((CompoundTag)tag, (String)"isLinkedToController").orElse(false);
    }

    private void loadStorageWrapper(CompoundTag tag) {
        NBTHelper.getCompound((CompoundTag)tag, (String)STORAGE_WRAPPER_TAG).ifPresent(this.storageWrapper::load);
    }

    public void onLoad() {
        super.onLoad();
        this.storageWrapper.onInit();
        this.registerWithControllerOnLoad();
    }

    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        this.displayName = NBTHelper.getComponent((CompoundTag)tag, (String)"displayName", (HolderLookup.Provider)registries).orElse(null);
        this.locked = NBTHelper.getBoolean((CompoundTag)tag, (String)"locked").orElse(false);
        this.showLock = NBTHelper.getBoolean((CompoundTag)tag, (String)"showLock").orElse(true);
        this.showTier = NBTHelper.getBoolean((CompoundTag)tag, (String)"showTier").orElse(true);
        this.showUpgrades = NBTHelper.getBoolean((CompoundTag)tag, (String)"showUpgrades").orElse(false);
        if (this.level != null && this.level.isClientSide && tag.getBoolean(UPDATE_BLOCK_RENDER_TAG)) {
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
            this.displayItemTints.clear();
        }
        this.loadControllerPos(tag);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.isBeingUpgraded && !this.chunkBeingUnloaded && this.level != null) {
            this.removeFromController();
        }
        super.setRemoved();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag.isEmpty()) {
            return;
        }
        this.loadStorageWrapper(tag);
        this.loadSynchronizedData(tag, registries);
    }

    public void setUpdateBlockRender() {
        this.updateBlockRender = true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.updateBlockRender = true;
        this.saveStorageWrapperClientData(tag);
        this.saveSynchronizedData(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos blockPos, StorageBlockEntity storageBlockEntity) {
        storageBlockEntity.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public StorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public Component getName() {
        return this.getDisplayName();
    }

    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getBlockState().getBlock().getName();
    }

    protected boolean isAllowedInStorage(ItemStack stack) {
        return true;
    }

    public void changeStorageSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        int currentInventorySlots = this.getStorageWrapper().getInventoryHandler().getSlots();
        this.getStorageWrapper().changeSize(additionalInventorySlots, additionalUpgradeSlots);
        this.changeSlots(currentInventorySlots + additionalInventorySlots);
    }

    public void dropContents() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.isDroppingContents = true;
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getInventoryHandler(), (Level)this.level, (BlockPos)this.worldPosition);
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getUpgradeHandler(), (Level)this.level, (BlockPos)this.worldPosition);
        this.isDroppingContents = false;
    }

    public void setCustomName(Component customName) {
        this.displayName = customName;
        this.setChanged();
    }

    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.getStorageWrapper().getInventoryForInputOutput();
        }
        if (this.cachedFailedInsertItemHandler == null) {
            this.cachedFailedInsertItemHandler = new CachedFailedInsertInventoryHandler(() -> this.getStorageWrapper().getInventoryForInputOutput(), () -> this.level != null ? this.level.getGameTime() : 0L);
        }
        return this.cachedFailedInsertItemHandler;
    }

    public boolean shouldDropContents() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        if (this.controllerPos != null) {
            this.controllerPos = null;
            this.setChanged();
        }
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.getLevel());
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.setChanged();
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.setChanged();
    }

    public boolean canConnectStorages() {
        return !this.isLinkedToController;
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public boolean canBeConnected() {
        return this.isLinked() || super.canBeConnected();
    }

    public void setBeingUpgraded(boolean isBeingUpgraded) {
        this.isBeingUpgraded = isBeingUpgraded;
    }

    public boolean isBeingUpgraded() {
        return this.isBeingUpgraded;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void toggleLock() {
        if (this.locked) {
            this.unlock();
        } else {
            this.lock();
        }
    }

    public boolean memorizesItemsWhenLocked() {
        return false;
    }

    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return true;
    }

    private void lock() {
        this.locked = true;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlots());
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.onInventoryInputOutputHandlerRefresh();
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    private void unlock() {
        this.locked = false;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
            ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
            InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.isEmpty()) {
                    itemDisplaySettings.itemChanged(slot.intValue());
                }
            });
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.onInventoryInputOutputHandlerRefresh();
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowLock() {
        return this.showLock;
    }

    @Override
    public void toggleLockVisibility() {
        this.showLock = !this.showLock;
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowTier() {
        return this.showTier;
    }

    @Override
    public void toggleTierVisiblity() {
        this.showTier = !this.showTier;
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.showUpgrades;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        this.showUpgrades = !this.showUpgrades;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void onNeighborChange(BlockPos neighborPos) {
        Direction direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.level, this.worldPosition, direction));
    }

    @Nullable
    protected Direction getNeighborDirection(BlockPos neighborPos) {
        Direction direction = null;
        int normalX = Integer.signum(neighborPos.getX() - this.worldPosition.getX());
        int normalY = Integer.signum(neighborPos.getY() - this.worldPosition.getY());
        int normalZ = Integer.signum(neighborPos.getZ() - this.worldPosition.getZ());
        for (Direction value : Direction.values()) {
            Vec3i normal = value.getUnitVec3i();
            if (normal.getX() != normalX || normal.getY() != normalY || normal.getZ() != normalZ) continue;
            direction = value;
            break;
        }
        return direction;
    }

    public float getSlotFillPercentage(int slot) {
        return 0.0f;
    }

    public void setShouldBeOpen(boolean shouldBeOpen) {
    }

    public int getOrComputeDisplayItemTint(int displayItemIndex, int tintIndex, Supplier<Integer> getTint) {
        return this.displayItemTints.computeIfAbsent(new DisplayTintKey(displayItemIndex, tintIndex), key -> (Integer)getTint.get());
    }

    private record DisplayTintKey(int displayIndex, int tintIndex) {
    }
}

