/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.init;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ModBlockColors {
    private ModBlockColors() {
    }

    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register(ModBlockColors::getBarrelTintColor, new Block[]{(Block)ModBlocks.BARREL.get(), (Block)ModBlocks.COPPER_BARREL.get(), (Block)ModBlocks.IRON_BARREL.get(), (Block)ModBlocks.GOLD_BARREL.get(), (Block)ModBlocks.DIAMOND_BARREL.get(), (Block)ModBlocks.NETHERITE_BARREL.get(), (Block)ModBlocks.LIMITED_BARREL_1.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_1.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_1.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_1.get(), (Block)ModBlocks.LIMITED_BARREL_2.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_2.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_2.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_2.get(), (Block)ModBlocks.LIMITED_BARREL_3.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_3.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_3.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_3.get(), (Block)ModBlocks.LIMITED_BARREL_4.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_4.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_4.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_4.get()});
        event.register(ModBlockColors::getChestShulkerBoxColor, new Block[]{(Block)ModBlocks.CHEST.get(), (Block)ModBlocks.COPPER_CHEST.get(), (Block)ModBlocks.IRON_CHEST.get(), (Block)ModBlocks.GOLD_CHEST.get(), (Block)ModBlocks.DIAMOND_CHEST.get(), (Block)ModBlocks.NETHERITE_CHEST.get(), (Block)ModBlocks.SHULKER_BOX.get(), (Block)ModBlocks.COPPER_SHULKER_BOX.get(), (Block)ModBlocks.IRON_SHULKER_BOX.get(), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), (Block)ModBlocks.NETHERITE_SHULKER_BOX.get()});
    }

    private static int getBarrelTintColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            if (tintIndex == 1) {
                return be.getStorageWrapper().getAccentColor();
            }
            int displayItemIndex = tintIndex / 10 - 1;
            if (displayItemIndex >= 0) {
                int tintOffset = (displayItemIndex + 1) * 10;
                int adjustedTintIndex = tintIndex - tintOffset;
                return be.getOrComputeDisplayItemTint(displayItemIndex, adjustedTintIndex, () -> ModBlockColors.getTint(state, displayItemIndex, adjustedTintIndex, be));
            }
            return -1;
        }).orElse(-1);
    }

    private static int getTint(BlockState state, int displayItemIndex, int adjustedTintIndex, StorageBlockEntity be) {
        RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
        List displayItems = itemDisplayRenderInfo.getDisplayItems();
        ItemStack stack = ModBlockColors.getDisplayItemWithIndex(displayItemIndex, displayItems, state.getBlock() instanceof LimitedBarrelBlock);
        if (stack.isEmpty()) {
            return -1;
        }
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, stack, ItemDisplayContext.FIXED, false, null, null, 0);
        for (ItemStackRenderState.LayerRenderState layer : renderState.layers) {
            if (layer.tintLayers.length <= adjustedTintIndex) continue;
            return layer.tintLayers[adjustedTintIndex];
        }
        return -1;
    }

    private static ItemStack getDisplayItemWithIndex(int displayItemIndex, List<RenderInfo.DisplayItem> displayItems, boolean isLimitedBarrel) {
        if (isLimitedBarrel) {
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                if (displayItem.getSlotIndex() != displayItemIndex) continue;
                return displayItem.getItem();
            }
        }
        return displayItems.size() > displayItemIndex ? displayItems.get(displayItemIndex).getItem() : ItemStack.EMPTY;
    }

    private static int getChestShulkerBoxColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            return -1;
        }).orElse(-1);
    }
}

