/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.model.ExtendedUnbakedModel;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import org.apache.logging.log4j.util.Supplier;
import org.joml.Quaternionf;

public abstract class BarrelDynamicModelBase
implements ExtendedUnbakedModel {
    private static final Map<Integer, BakedModel> BAKED_PART_MODELS = new HashMap<Integer, BakedModel>();
    private static final String REFERENCE_PREFIX = "reference/";
    private Map<String, Map<BarrelModelPart, UnbakedModel>> unbakedWoodModelParts;
    private Map<String, Map<BarrelModelPart, UnbakedModel>> unbakedWoodPartitionedModelParts;
    private Map<DynamicBarrelBakingData.DynamicPart, UnbakedModel> unbakedDynamicPartModels;
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions;
    @Nullable
    private final ResourceLocation parentLocation;
    @Nullable
    private BarrelDynamicModelBase parent;
    private final Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels;
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions;

    public static void invalidateCache() {
        BAKED_PART_MODELS.clear();
    }

    protected BarrelDynamicModelBase(@Nullable ResourceLocation parentLocation, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions) {
        this.parentLocation = parentLocation;
        this.woodModelPartDefinitions = woodModelPartDefinitions;
        this.dynamicPartModels = dynamicPartModels;
        this.woodPartitionedModelPartDefinitions = woodPartitionedModelPartDefinitions;
    }

    public BakedModel bake(TextureSlots textureSlots, ModelBaker baker, ModelState modelState, boolean useAmbientOcclusion, boolean usesBlockLight, ItemTransforms itemTransforms, ContextMap contextMap) {
        Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts = this.bakeWoodModelParts(baker, modelState, this.unbakedWoodModelParts);
        Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = this.getDynamicBakingData(modelState);
        Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts = this.bakeWoodModelParts(baker, modelState, this.unbakedWoodPartitionedModelParts);
        return this.instantiateBakedModel(baker, woodModelParts, woodDynamicBakingData, woodPartitionedModelParts);
    }

    private void copyAndResolveTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        BarrelDynamicModelBase.copyTextures(woodOverrides, partitionedWoodOverrides);
        BarrelDynamicModelBase.resolveTextureReferences(partitionedWoodOverrides);
    }

    private static void resolveTextureReferences(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        partitionedWoodOverrides.values().forEach(partDefinitions -> partDefinitions.values().forEach(definition -> {
            HashMap replacements = new HashMap();
            definition.textures.forEach((key, value) -> {
                String path = value.texture().getPath();
                if (value.texture().getNamespace().equals("minecraft") && path.startsWith(REFERENCE_PREFIX)) {
                    String referredTextureName = path.substring(REFERENCE_PREFIX.length());
                    if (definition.textures().containsKey(referredTextureName)) {
                        replacements.put(key, definition.textures.get(referredTextureName));
                    }
                }
            });
            definition.textures.putAll(replacements);
        }));
    }

    private static void copyTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        woodOverrides.forEach((woodType, partDefinitions) -> {
            if (partitionedWoodOverrides.containsKey(woodType)) {
                Map partitionedWoodOverride = (Map)partitionedWoodOverrides.get(woodType);
                partDefinitions.forEach((part, definition) -> {
                    if (partitionedWoodOverride.containsKey(part)) {
                        ((BarrelModelPartDefinition)partitionedWoodOverride.get((Object)((Object)((Object)((Object)part))))).textures.putAll(definition.textures);
                    } else {
                        partitionedWoodOverride.put(part, new BarrelModelPartDefinition(null, new HashMap<String, Material>(definition.textures())));
                    }
                });
            }
        });
    }

    private Map<String, Map<BarrelModelPart, UnbakedModel>> createUnbakedWoodModelParts(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> definitions) {
        ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
        definitions.forEach((woodName, woodDefinitions) -> {
            ImmutableMap.Builder modelsBuilder = ImmutableMap.builder();
            woodDefinitions.forEach((barrelPart, barrelPartDefinition) -> barrelPartDefinition.modelLocation().ifPresent(partModelLocation -> {
                TextureSlots.Data.Builder textureBuilder = new TextureSlots.Data.Builder();
                barrelPartDefinition.textures().forEach((arg_0, arg_1) -> ((TextureSlots.Data.Builder)textureBuilder).addTexture(arg_0, arg_1));
                modelsBuilder.put((Object)barrelPart, (Object)new BlockModel(partModelLocation, Collections.emptyList(), textureBuilder.build(), Boolean.valueOf(true), null, ItemTransforms.NO_TRANSFORMS));
            }));
            woodModelsBuilder.put(woodName, (Object)modelsBuilder.build());
        });
        return woodModelsBuilder.build();
    }

    private Map<String, Map<BarrelModelPart, BakedModel>> bakeWoodModelParts(ModelBaker baker, ModelState modelState, Map<String, Map<BarrelModelPart, UnbakedModel>> woodModels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        woodModels.forEach((woodName, partModels) -> {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            partModels.forEach((part, model) -> {
                int hash = this.getBakedModelHash((UnbakedModel)model, modelState, (BarrelModelPart)((Object)((Object)part)));
                BakedModel bakedModel = BAKED_PART_MODELS.computeIfAbsent(hash, h -> UnbakedModel.bakeWithTopModelValues((UnbakedModel)model, (ModelBaker)baker, (ModelState)modelState));
                if (bakedModel != null) {
                    partBuilder.put((Object)part, (Object)bakedModel);
                }
            });
            builder.put(woodName, (Object)partBuilder.build());
        });
        return builder.build();
    }

    private Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> getDynamicBakingData(ModelState modelTransform) {
        HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = new HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>>();
        this.woodModelPartDefinitions.forEach((woodName, partDefinitions) -> {
            EnumMap dynamicPartBakingData = new EnumMap(DynamicBarrelBakingData.DynamicPart.class);
            this.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> dynamicPartBakingData.put((DynamicBarrelBakingData.DynamicPart)((Object)((Object)dynamicPart)), new DynamicBarrelBakingData(this.unbakedDynamicPartModels.get(dynamicPart), ((BarrelModelPartDefinition)partDefinitions.get((Object)BarrelModelPart.BASE)).textures(), modelTransform)));
            woodDynamicBakingData.put((String)woodName, dynamicPartBakingData);
        });
        return woodDynamicBakingData;
    }

    private int getBakedModelHash(UnbakedModel model, ModelState modelTransform, BarrelModelPart part) {
        int hash = part.hashCode();
        hash = 31 * hash + this.getDepHash(model);
        if (model instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)model;
            for (TextureSlots.SlotContents material : blockModel.getTextureSlots().values().values()) {
                hash = 31 * hash + material.hashCode();
            }
        }
        hash = 31 * hash + Boolean.valueOf(modelTransform.isUvLocked()).hashCode();
        Transformation rotation = modelTransform.getRotation();
        hash = 31 * hash + rotation.getMatrix().hashCode();
        hash = 31 * hash + rotation.getTranslation().hashCode();
        hash = 31 * hash + BarrelDynamicModelBase.robustHash(rotation.getRightRotation());
        hash = 31 * hash + BarrelDynamicModelBase.robustHash(rotation.getLeftRotation());
        hash = 31 * hash + rotation.getScale().hashCode();
        return hash;
    }

    public static int robustHash(Quaternionf q) {
        long h = 1L;
        h = 31L * h + (long)Float.floatToIntBits(q.w());
        h = 31L * h + (long)Float.floatToIntBits(q.x());
        h = 31L * h + (long)Float.floatToIntBits(q.y());
        h = 31L * h + (long)Float.floatToIntBits(q.z());
        return Long.hashCode(h);
    }

    private int getDepHash(UnbakedModel model) {
        int depHash = 0;
        while (model instanceof BarrelDynamicModelBase || model instanceof BlockModel) {
            BlockModel blockModel;
            if (model instanceof BarrelDynamicModelBase) {
                BarrelDynamicModelBase barrelModel = (BarrelDynamicModelBase)model;
                if (barrelModel.parentLocation != null) {
                    depHash = 31 * depHash + barrelModel.parentLocation.hashCode();
                }
            } else if (model instanceof BlockModel && (blockModel = (BlockModel)model).getParent() != null) {
                depHash = 31 * depHash + blockModel.parentLocation.hashCode();
            }
            model = model.getParent();
        }
        return depHash;
    }

    protected abstract BarrelBakedModelBase instantiateBakedModel(ModelBaker var1, Map<String, Map<BarrelModelPart, BakedModel>> var2, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> var3, Map<String, Map<BarrelModelPart, BakedModel>> var4);

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        this.visitAndUpdateParents(resolver);
        this.updatePartDefinitionsFromParents();
        this.updatePartitionedPartDefinitionsFromParents();
        this.updateDynamicPartModelsFromParents();
        this.unbakedWoodModelParts = this.createUnbakedWoodModelParts(this.woodModelPartDefinitions);
        this.copyAndResolveTextures(this.woodModelPartDefinitions, this.woodPartitionedModelPartDefinitions);
        this.unbakedWoodPartitionedModelParts = this.createUnbakedWoodModelParts(this.woodPartitionedModelPartDefinitions);
        this.unbakedWoodModelParts.values().forEach(partModels -> partModels.values().forEach(model -> model.resolveDependencies(resolver)));
        this.unbakedWoodPartitionedModelParts.values().forEach(partModels -> partModels.values().forEach(model -> model.resolveDependencies(resolver)));
        this.unbakedDynamicPartModels = this.createUnbakedDynamicPartModels();
        this.unbakedDynamicPartModels.values().forEach(partModel -> partModel.resolveDependencies(resolver));
    }

    private Map<DynamicBarrelBakingData.DynamicPart, UnbakedModel> createUnbakedDynamicPartModels() {
        ImmutableMap.Builder dynamicPartModelsBuilder = ImmutableMap.builder();
        this.dynamicPartModels.forEach((part, modelLocation) -> dynamicPartModelsBuilder.put((Object)part, (Object)new BlockModel(modelLocation, Collections.emptyList(), TextureSlots.Data.EMPTY, Boolean.valueOf(true), null, ItemTransforms.NO_TRANSFORMS)));
        return dynamicPartModelsBuilder.build();
    }

    private void updateDynamicPartModelsFromParents() {
        BarrelDynamicModelBase model = this.parent;
        while (model != null) {
            this.updateDynamicPartModelsFromModel(model);
            model = model.parent;
        }
    }

    private void updateDynamicPartModelsFromModel(BarrelDynamicModelBase model) {
        model.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> {
            if (!this.dynamicPartModels.containsKey(dynamicPart)) {
                this.dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)dynamicPart), (ResourceLocation)dynamicPartModel);
            }
        });
    }

    private void updatePartDefinitionsFromParents() {
        BarrelDynamicModelBase model = this.parent;
        while (model != null) {
            this.updateWoodModelPartDefinitionsFromModel(model);
            model = model.parent;
        }
    }

    private void updatePartitionedPartDefinitionsFromParents() {
        BarrelDynamicModelBase model = this.parent;
        while (model != null) {
            this.updateWoodPartitionedModelPartDefinitionsFromModel(model);
            model = model.parent;
        }
    }

    private void updateWoodModelPartDefinitionsFromModel(BarrelDynamicModelBase model) {
        model.woodModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodModelPartDefinitions.containsKey(woodType)) {
                this.woodModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    private void updateWoodPartitionedModelPartDefinitionsFromModel(BarrelDynamicModelBase model) {
        model.woodPartitionedModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodPartitionedModelPartDefinitions.containsKey(woodType)) {
                this.woodPartitionedModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodPartitionedModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodPartitionedModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodPartitionedModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    private void visitAndUpdateParents(ResolvableModel.Resolver resolver) {
        LinkedHashSet visitedModels = Sets.newLinkedHashSet();
        BarrelDynamicModelBase currentModel = this;
        while (currentModel.parentLocation != null && currentModel.parent == null) {
            visitedModels.add(currentModel);
            if (!this.updateModelParent(resolver, visitedModels, currentModel)) break;
            currentModel = currentModel.parent;
        }
    }

    private boolean updateModelParent(ResolvableModel.Resolver resolver, Set<BarrelDynamicModelBase> visitedModels, BarrelDynamicModelBase currentModel) {
        UnbakedModel unbakedModel = resolver.resolve(currentModel.parentLocation);
        if (!(unbakedModel instanceof BarrelDynamicModelBase)) {
            SophisticatedStorage.LOGGER.warn("Parent '{}' isn't a barrel model of 'BarrelDynamicModelBase' while loading '{}'", (Object)currentModel.parentLocation, (Object)currentModel);
            return false;
        }
        BarrelDynamicModelBase parentModel = (BarrelDynamicModelBase)unbakedModel;
        if (visitedModels.contains(parentModel)) {
            SophisticatedStorage.LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Supplier[]{() -> currentModel, () -> visitedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), () -> currentModel.parentLocation});
            return false;
        }
        currentModel.parent = parentModel;
        return true;
    }

    public static final class BarrelModelPartDefinition {
        @Nullable
        private ResourceLocation modelLocation;
        private final Map<String, Material> textures;

        private BarrelModelPartDefinition(@Nullable ResourceLocation modelLocation, Map<String, Material> textures) {
            this.modelLocation = modelLocation;
            this.textures = textures;
        }

        public BarrelModelPartDefinition copy() {
            return new BarrelModelPartDefinition(this.modelLocation, new HashMap<String, Material>(this.textures));
        }

        public void mergeMissing(BarrelModelPartDefinition other) {
            if (other.modelLocation != null && this.modelLocation == null) {
                this.modelLocation = other.modelLocation;
            }
            other.textures.forEach((key, value) -> {
                if (!this.textures.containsKey(key)) {
                    this.textures.put((String)key, (Material)value);
                }
            });
        }

        public static BarrelModelPartDefinition deserialize(JsonObject json) {
            ResourceLocation modelLocation = null;
            if (json.has("model")) {
                modelLocation = ResourceLocation.parse((String)json.get("model").getAsString());
            }
            HashMap<String, Material> textures = new HashMap<String, Material>();
            if (json.has("textures")) {
                JsonObject texturesJson = json.getAsJsonObject("textures");
                for (Map.Entry entry : texturesJson.entrySet()) {
                    Object textureName = ((JsonElement)entry.getValue()).getAsString();
                    if (((String)textureName).startsWith("#")) {
                        textureName = BarrelDynamicModelBase.REFERENCE_PREFIX + ((String)textureName).substring(1);
                    }
                    textures.put((String)entry.getKey(), new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)textureName)));
                }
            }
            return new BarrelModelPartDefinition(modelLocation, textures);
        }

        public Optional<ResourceLocation> modelLocation() {
            return Optional.ofNullable(this.modelLocation);
        }

        public Map<String, Material> textures() {
            return this.textures;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BarrelModelPartDefinition that = (BarrelModelPartDefinition)obj;
            return Objects.equals(this.modelLocation, that.modelLocation) && Objects.equals(this.textures, that.textures);
        }

        public int hashCode() {
            return Objects.hash(this.modelLocation, this.textures);
        }

        public String toString() {
            return "BarrelModelPartDefinition[modelLocation=" + String.valueOf(this.modelLocation) + ", textures=" + String.valueOf(this.textures) + "]";
        }
    }

    public static abstract class Loader<T extends BarrelDynamicModelBase>
    implements UnbakedModelLoader<T> {
        public T read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation parentLocation = null;
            if (modelContents.has("parent")) {
                parentLocation = ResourceLocation.parse((String)modelContents.get("parent").getAsString());
            }
            Map<BarrelModelPart, BarrelModelPartDefinition> modelParts = Loader.readModelParts(modelContents, "model_parts");
            Map<BarrelModelPart, BarrelModelPartDefinition> partitionedModelParts = Loader.readModelParts(modelContents, "partitioned_model_parts");
            Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels = Loader.readDynamicPartModels(modelContents);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = Loader.readWoodOverrides(modelContents);
            if (parentLocation == null && modelParts.isEmpty() && woodOverrides.isEmpty() && dynamicPartModels.isEmpty()) {
                SophisticatedStorage.LOGGER.warn("None of 'parent', 'model_parts' and 'wood_overrides' present in model definition");
            }
            this.mergeModelPartDefinitionsIntoWoodOnes(modelParts, woodOverrides);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions = Loader.readWoodOverrides(modelContents, Set.of(BarrelModelPart.BASE, BarrelModelPart.BASE_OPEN));
            this.mergeModelPartDefinitionsIntoWoodOnes(partitionedModelParts, woodPartitionedModelPartDefinitions);
            return this.instantiateModel(parentLocation, woodOverrides, dynamicPartModels, woodPartitionedModelPartDefinitions);
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents) {
            return Loader.readWoodOverrides(modelContents, Collections.emptySet());
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents, Set<BarrelModelPart> partsToIgnore) {
            HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = new HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>>();
            if (modelContents.has("wood_overrides")) {
                JsonObject woodOverridesJson = modelContents.getAsJsonObject("wood_overrides");
                for (Map.Entry entry : woodOverridesJson.entrySet()) {
                    JsonObject woodOverrideJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    EnumMap woodOverride = new EnumMap(BarrelModelPart.class);
                    for (Map.Entry woodModelParts : woodOverrideJson.entrySet()) {
                        JsonObject modelPartJson = ((JsonElement)woodModelParts.getValue()).getAsJsonObject();
                        BarrelModelPart.getByNameOptional((String)woodModelParts.getKey()).ifPresent(part -> {
                            if (partsToIgnore.contains(part)) {
                                return;
                            }
                            woodOverride.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson));
                        });
                    }
                    woodOverrides.put((String)entry.getKey(), woodOverride);
                }
            }
            return woodOverrides;
        }

        private static Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> readDynamicPartModels(JsonObject modelContents) {
            EnumMap<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels = new EnumMap<DynamicBarrelBakingData.DynamicPart, ResourceLocation>(DynamicBarrelBakingData.DynamicPart.class);
            if (modelContents.has("dynamic_part_models")) {
                JsonObject dynamicPartsJson = modelContents.getAsJsonObject("dynamic_part_models");
                for (Map.Entry entry : dynamicPartsJson.entrySet()) {
                    DynamicBarrelBakingData.DynamicPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)part), ResourceLocation.parse((String)((JsonElement)entry.getValue()).getAsString())));
                }
            }
            return dynamicPartModels;
        }

        private static Map<BarrelModelPart, BarrelModelPartDefinition> readModelParts(JsonObject modelContents, String memberName) {
            EnumMap<BarrelModelPart, BarrelModelPartDefinition> modelParts = new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(BarrelModelPart.class);
            if (modelContents.has(memberName)) {
                JsonObject modelPartsJson = modelContents.getAsJsonObject(memberName);
                for (Map.Entry entry : modelPartsJson.entrySet()) {
                    JsonObject modelPartJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    BarrelModelPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> modelParts.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson)));
                }
            }
            return modelParts;
        }

        private void mergeModelPartDefinitionsIntoWoodOnes(Map<BarrelModelPart, BarrelModelPartDefinition> modelPartDefinitions, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartdefinitions) {
            for (BarrelModelPart part : BarrelModelPart.values()) {
                if (!modelPartDefinitions.containsKey((Object)part)) continue;
                WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> {
                    String woodName = woodType.name().toLowerCase(Locale.ROOT);
                    if (woodModelPartdefinitions.containsKey(woodName)) {
                        Map definitions = (Map)woodModelPartdefinitions.get(woodName);
                        if (definitions.containsKey((Object)part)) {
                            ((BarrelModelPartDefinition)definitions.get((Object)part)).mergeMissing((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part));
                        } else {
                            definitions.put(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy());
                        }
                    } else {
                        woodModelPartdefinitions.put(woodName, new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(Map.of(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy())));
                    }
                });
            }
        }

        protected abstract T instantiateModel(@Nullable ResourceLocation var1, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var2, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> var3, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var4);
    }
}

